/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.untitledduck.ranching.roost;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import plus.dragons.createintegratedfarming.common.ranching.roost.AnimalRoostBlockEntity;

public abstract class UntitledAnimalRoostBlockEntity
extends AnimalRoostBlockEntity {
    private static final IntProvider FOOD_PROGRESSION = ConstantInt.of((int)2400);
    private static final IntProvider FOOD_COOLDOWN = UniformInt.of((int)400, (int)800);

    public UntitledAnimalRoostBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public abstract Predicate<ItemStack> getFoodPredicate();

    public abstract SoundEvent getAmbientSound();

    @Override
    public boolean feedItem(ItemStack stack, boolean simulate) {
        assert (this.level != null);
        if (this.feedCooldown > 0 || this.eggTime <= 0) {
            return false;
        }
        if (this.getFoodPredicate().test(stack)) {
            if (simulate) {
                return true;
            }
            Direction facing = (Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING);
            Vec3 feedPos = Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add((double)((float)facing.getStepX() * 0.5f), 0.8125, (double)((float)facing.getStepZ() * 0.5f));
            this.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), feedPos.x, feedPos.y, feedPos.z, 0.0, 0.0, 0.0);
            this.eggTime = Math.max(0, this.eggTime - FOOD_PROGRESSION.sample(this.level.random));
            this.feedCooldown = FOOD_COOLDOWN.sample(this.level.random);
            this.level.playSound(null, this.worldPosition, this.getAmbientSound(), SoundSource.BLOCKS, 1.0f, (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f + 1.0f);
            this.notifyUpdate();
            ItemStack remainer = stack.getCraftingRemainingItem();
            if (!remainer.isEmpty()) {
                Containers.dropItemStack((Level)this.level, (double)feedPos.x, (double)feedPos.y, (double)feedPos.z, (ItemStack)remainer.copy());
            }
        }
        return false;
    }
}

