/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost;

import com.google.common.base.Optional;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.contraptions.actors.seat.SeatBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostCapturable;

public class RoostBlock
extends HorizontalDirectionalBlock
implements IWrenchable,
ProperWaterloggedBlock {
    protected static final VoxelShape NORTH_SHAPE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Shapes.or((VoxelShape)RoostBlock.box((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), (VoxelShape)RoostBlock.box((double)2.0, (double)11.0, (double)0.0, (double)14.0, (double)16.0, (double)14.0)), (BooleanOp)BooleanOp.ONLY_FIRST);
    protected static final VoxelShaper SHAPE = VoxelShaper.forHorizontal((VoxelShape)NORTH_SHAPE, (Direction)Direction.NORTH);
    protected static final VoxelShape INTERACTION_SHAPE = Shapes.block();
    protected static final VoxelShape OCCULUSION_SHAPE = RoostBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);

    public RoostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FACING, WATERLOGGED}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        return this.withWater(stateForPlacement, context);
    }

    protected FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateWater(level, state, pos);
        return state;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional optional = SeatBlock.getLeashed((Level)level, (Player)player);
        if (!optional.isPresent()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Entity entity = (Entity)optional.get();
        RoostCapturable capturable = (RoostCapturable)RoostCapturable.REGISTRY.get((Object)entity.getType());
        if (capturable == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return capturable.captureBlock(level, state, pos, stack, player, entity);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE.get((Direction)state.getValue((Property)FACING));
    }

    protected VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return OCCULUSION_SHAPE;
    }

    protected VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return INTERACTION_SHAPE;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return HorizontalDirectionalBlock.simpleCodec(RoostBlock::new);
    }
}

