/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.farmersdelight.farming.harvest;

import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import plus.dragons.createintegratedfarming.api.harvester.CustomHarvestBehaviour;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class TomatoHarvestBehaviour
implements CustomHarvestBehaviour {
    private final TomatoVineBlock tomato;

    public TomatoHarvestBehaviour(TomatoVineBlock tomato) {
        this.tomato = tomato;
    }

    @Override
    public void harvest(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        boolean replant = CustomHarvestBehaviour.replant();
        boolean partial = CustomHarvestBehaviour.partial();
        boolean mature = this.tomato.getAge(state) == this.tomato.getMaxAge();
        Level level = context.world;
        if (!replant) {
            if (mature || partial) {
                this.breakTomatoes(level, behaviour, context, pos, state);
            }
            return;
        }
        if (mature) {
            this.dropTomatoes(level, behaviour, context);
            level.playSound(null, pos, (SoundEvent)ModSounds.ITEM_TOMATO_PICK_FROM_BUSH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            level.setBlock(pos, (BlockState)state.setValue((Property)this.tomato.getAgeProperty(), (Comparable)Integer.valueOf(0)), 2);
        } else if (partial) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.tomato.getAgeProperty(), (Comparable)Integer.valueOf(0)), 2);
        }
    }

    protected void breakTomatoes(Level level, HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        BlockPos above = pos.above();
        BlockState stateAbove = level.getBlockState(above);
        if (stateAbove.is((Block)this.tomato)) {
            this.breakTomatoes(level, behaviour, context, above, stateAbove);
        }
        boolean ropelogged = (Boolean)state.getValue((Property)TomatoVineBlock.ROPELOGGED);
        BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, null, (ItemStack)CustomHarvestBehaviour.getHarvestTool(context), (float)1.0f, stack -> behaviour.dropItem(context, stack));
        if (ropelogged) {
            level.setBlockAndUpdate(pos, this.getRope());
        }
    }

    protected void dropTomatoes(Level level, HarvesterMovementBehaviour behaviour, MovementContext context) {
        behaviour.dropItem(context, new ItemStack((ItemLike)ModItems.TOMATO.get(), 1 + level.random.nextInt(2)));
        if ((double)level.random.nextFloat() < 0.05) {
            behaviour.dropItem(context, new ItemStack((ItemLike)ModItems.ROTTEN_TOMATO.get()));
        }
    }

    protected BlockState getRope() {
        ResourceLocation ropeId = ResourceLocation.parse((String)((String)Configuration.DEFAULT_TOMATO_VINE_ROPE.get()));
        BlockState rope = ((Block)BuiltInRegistries.BLOCK.get(ropeId)).defaultBlockState();
        if (rope.isAir()) {
            return ((Block)ModBlocks.ROPE.get()).defaultBlockState();
        }
        return rope;
    }
}

