/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.netherdepthupgrade.content.fishing.net;

import com.scouter.netherdepthsupgrade.entity.LavaAnimal;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.state.SchematicStateFilter;
import com.simibubi.create.foundation.block.WrenchableDirectionalBlock;
import java.util.List;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.common.fluids.WaterAndLavaLoggedBlock;
import plus.dragons.createintegratedfarming.config.CIFConfig;

public class LavaFishingNetBlock
extends WrenchableDirectionalBlock
implements WaterAndLavaLoggedBlock,
SchematicStateFilter {
    protected static final int PLACEMENT_HELPER_ID = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public LavaFishingNetBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)FLUID, (Comparable)WaterAndLavaLoggedBlock.ContainedFluid.EMPTY));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get((int)PLACEMENT_HELPER_ID);
        if (!player.isShiftKeyDown() && player.mayBuild() && placementHelper.matchesItem(stack)) {
            placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return AllShapes.SAIL.get((Direction)state.getValue((Property)FACING));
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Enemy) {
            return;
        }
        if (entity instanceof WaterAnimal || entity instanceof LavaAnimal) {
            EntityDimensions dimensions = entity.getDimensions(Pose.SWIMMING);
            float maxSize = CIFConfig.server().fishingNetCapturedCreatureMaxSize.getF();
            if (dimensions.height() < maxSize && dimensions.width() < maxSize) {
                entity.makeStuckInBlock(state, new Vec3(0.25, 0.05, 0.25));
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FLUID}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        return this.withFluid(stateForPlacement, context);
    }

    protected FluidState getFluidState(BlockState state) {
        return this.fluidState(state);
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        this.updateFluid(level, state, pos);
        return state;
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.isSuppressingBounce()) {
            super.fallOn(level, state, pos, entity, fallDistance);
        } else {
            entity.causeFallDamage(fallDistance, 0.5f, level.damageSources().fall());
        }
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entityIn) {
        if (entityIn.isSuppressingBounce()) {
            super.updateEntityAfterFallOn(level, entityIn);
        } else {
            this.bounceEntity(entityIn);
        }
    }

    protected void bounceEntity(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double entityWeightOffset = entity instanceof LivingEntity ? 0.3 : 0.4;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * entityWeightOffset, vec3d.z);
        }
    }

    public BlockState filterStates(@Nullable BlockEntity be, BlockState state) {
        return (BlockState)state.setValue((Property)FLUID, (Comparable)WaterAndLavaLoggedBlock.ContainedFluid.EMPTY);
    }

    protected static class PlacementHelper
    implements IPlacementHelper {
        protected PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return stack -> {
                BlockItem blockItem;
                Item patt0$temp = stack.getItem();
                return patt0$temp instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock() instanceof LavaFishingNetBlock;
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.getBlock() instanceof LavaFishingNetBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult hitResult) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)hitResult.getLocation(), (Direction.Axis)((Direction)state.getValue((Property)FACING)).getAxis(), direction -> level.getBlockState(pos.relative(direction)).canBeReplaced());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.relative((Direction)directions.getFirst()), placed -> {
                FluidState fluidstate = level.getFluidState(pos.relative((Direction)directions.getFirst()));
                BlockState result = (BlockState)placed.setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING)));
                if (fluidstate.getType() == Fluids.WATER) {
                    result = (BlockState)result.setValue((Property)WaterAndLavaLoggedBlock.FLUID, (Comparable)WaterAndLavaLoggedBlock.ContainedFluid.WATER);
                } else if (fluidstate.getType() == Fluids.LAVA) {
                    result = (BlockState)result.setValue((Property)WaterAndLavaLoggedBlock.FLUID, (Comparable)WaterAndLavaLoggedBlock.ContainedFluid.LAVA);
                }
                return result;
            });
        }
    }
}

