/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.nakolotnik.banMace.CommandHandler;
import org.nakolotnik.banMace.ModeHandler;
import org.nakolotnik.banMace.utils.ItemPickupListener;
import org.nakolotnik.banMace.utils.LanguageManager;
import org.nakolotnik.banMace.utils.LoggerService;
import org.nakolotnik.banMace.utils.ModeSwitcher;
import org.nakolotnik.banMace.utils.RadialMenuManager;
import org.nakolotnik.banMace.utils.SettingsGUI;
import org.nakolotnik.banMace.utils.UpdateChecker;
import org.nakolotnik.banMace.utils.mods.BalloonMod;
import org.nakolotnik.banMace.utils.mods.BanMode;
import org.nakolotnik.banMace.utils.mods.BedMode;
import org.nakolotnik.banMace.utils.mods.FreezeMode;
import org.nakolotnik.banMace.utils.mods.KickMode;
import org.nakolotnik.banMace.utils.mods.SpawnMode;
import org.nakolotnik.banMace.utils.mods.TeleportToMode;

public final class BanMace
extends JavaPlugin {
    private static ModeHandler currentMode;
    private static BanMace instance;
    private LanguageManager languageManager;
    private static Material banMaceMaterial;
    private SettingsGUI settingsGUI;
    private LoggerService loggerService;
    private FreezeMode freezeModeInstance;
    private BalloonMod balloonModInstance;

    public void onEnable() {
        String[] commands;
        Listener[] listeners;
        instance = this;
        this.saveDefaultConfig();
        this.loggerService = new LoggerService(this);
        this.languageManager = new LanguageManager(this);
        this.settingsGUI = new SettingsGUI(this);
        this.freezeModeInstance = new FreezeMode();
        this.balloonModInstance = new BalloonMod();
        this.languageManager.checkAndLoadLanguageFiles();
        this.reloadAllConfigs();
        this.getServer().getPluginManager().registerEvents((Listener)new RadialMenuManager(this), (Plugin)this);
        try {
            BanMaceMode initialMode = BanMaceMode.valueOf(this.getConfig().getString("active_mode", "SPAWN"));
            BanMace.setMode(null, initialMode.getHandler());
        }
        catch (IllegalArgumentException e) {
            this.getLogger().warning("Invalid mode in config: " + this.getConfig().getString("active_mode", "SPAWN") + ". Defaulting to SPAWN mode.");
            BanMace.setMode(null, new SpawnMode());
        }
        for (Listener listener : listeners = new Listener[]{new SpawnMode(), new BedMode(), new BanMode(), new KickMode(), new ModeSwitcher(), new ItemPickupListener(this), this.freezeModeInstance, new TeleportToMode(), this.balloonModInstance}) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
        CommandHandler commandHandler = new CommandHandler(this);
        for (String cmdName : commands = new String[]{"bm-give", "bm-setlanguage", "bm-changeview", "bm-tpcoordinates", "bm-help", "bm-settings"}) {
            PluginCommand command = this.getCommand(cmdName);
            if (command != null) {
                command.setExecutor((CommandExecutor)commandHandler);
                command.setTabCompleter((TabCompleter)commandHandler);
                continue;
            }
            this.getLogger().warning("Command '" + cmdName + "' not found in plugin.yml! It will not work.");
        }
        if (this.getConfig().getBoolean("check_for_updates", true)) {
            new UpdateChecker(this).checkForUpdates();
        }
    }

    public void reloadAllConfigs() {
        this.reloadConfig();
        this.reloadBanMaceMaterial();
        this.languageManager.loadMessages(this.getConfig().getString("language", "en"));
        if (this.loggerService != null) {
            this.loggerService.reloadWebhook();
        }
    }

    public void reloadBanMaceMaterial() {
        String materialName = this.getConfig().getString("item_customization.item_material", "mace");
        Material newMaterial = this.getMaterialFromString(materialName);
        if (newMaterial != null) {
            banMaceMaterial = newMaterial;
        } else {
            this.getLogger().warning("Invalid material in config.yml: '" + materialName + "'. Defaulting to MACE.");
            banMaceMaterial = Material.MACE;
        }
    }

    private Material getMaterialFromString(String materialString) {
        Material material;
        if (materialString == null || materialString.isEmpty()) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)materialString.toLowerCase(Locale.ROOT));
        if (key != null && (material = (Material)Registry.MATERIAL.get(key)) != null) {
            return material;
        }
        try {
            return Material.valueOf((String)materialString.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public SettingsGUI getSettingsGUI() {
        return this.settingsGUI;
    }

    public LoggerService getLoggerService() {
        return this.loggerService;
    }

    public static Material getBanMaceMaterial() {
        return banMaceMaterial;
    }

    public static ModeHandler getCurrentMode() {
        return currentMode;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public static BanMace getInstance() {
        return instance;
    }

    public static void setMode(Player player, ModeHandler mode) {
        currentMode = mode;
        BanMace plugin = BanMace.getInstance();
        for (BanMaceMode banMaceMode : BanMaceMode.values()) {
            if (!banMaceMode.getHandler().getClass().equals(mode.getClass())) continue;
            plugin.getConfig().set("active_mode", (Object)banMaceMode.name());
            plugin.saveConfig();
            if (player == null || !BanMace.isHoldingBanMace(player)) break;
            plugin.updateMaceItem(player.getInventory().getItemInMainHand(), banMaceMode);
            break;
        }
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        return this.languageManager.getMessage(key, placeholders);
    }

    public String getMessage(String key) {
        return this.languageManager.getMessage(key, null);
    }

    public void onDisable() {
        if (this.freezeModeInstance != null) {
            this.freezeModeInstance.removeAllIceEffects();
            this.getLogger().info("Cleared all active freeze effects.");
        }
        if (this.balloonModInstance != null) {
            this.balloonModInstance.cleanup();
            this.getLogger().info("Cleared all active balloon effects.");
        }
        instance = null;
    }

    public ItemStack createBanMace() {
        ItemStack mace = new ItemStack(BanMace.getBanMaceMaterial());
        ItemMeta meta = mace.getItemMeta();
        if (meta != null) {
            meta.addEnchant(Enchantment.KNOCKBACK, 10, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_UNBREAKABLE});
            meta.setUnbreakable(true);
            meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this, "ban_mace"), PersistentDataType.STRING, (Object)"unique_ban_mace");
            mace.setItemMeta(meta);
            try {
                BanMaceMode initialMode = BanMaceMode.valueOf(this.getConfig().getString("active_mode", "SPAWN"));
                this.updateMaceItem(mace, initialMode);
            }
            catch (IllegalArgumentException e) {
                this.updateMaceItem(mace, BanMaceMode.SPAWN);
            }
        }
        return mace;
    }

    public void updateMaceItem(ItemStack mace, BanMaceMode mode) {
        if (mace == null || mace.getItemMeta() == null) {
            return;
        }
        ItemMeta meta = mace.getItemMeta();
        String translatedModeName = this.getMessage("mode_" + mode.name().toLowerCase());
        String nameColor = this.getConfig().getString("item_customization.name_color", "\u00a77");
        String baseName = this.getConfig().getString("item_customization.bm-name", "Ban Mace");
        meta.setDisplayName(String.format("%s%s \u00a77(\u00a7e%s\u00a77)", nameColor, baseName, translatedModeName));
        ArrayList<String> newLore = new ArrayList<String>(this.getConfig().getStringList("item_customization.lore"));
        List<String> modeLore = this.languageManager.getMessageList("lore." + mode.name().toLowerCase());
        if (modeLore != null && !modeLore.isEmpty()) {
            newLore.add("");
            newLore.addAll(modeLore);
        }
        meta.setLore(newLore);
        mace.setItemMeta(meta);
    }

    public void playTeleportEffects(Player target) {
        Particle particle = this.getParticleFromString(this.getConfig().getString("teleport_effect.particle", "portal"));
        Sound sound = this.getSoundFromString(this.getConfig().getString("teleport_sound", "entity.enderman.teleport"));
        if (particle != null) {
            int count = this.getConfig().getInt("teleport_effect.count", 100);
            double offset = this.getConfig().getDouble("teleport_effect.offset", 0.5);
            float speed = (float)this.getConfig().getDouble("teleport_effect.speed", 0.2);
            target.getWorld().spawnParticle(particle, target.getLocation().add(0.0, 1.0, 0.0), count, offset, offset, offset, (double)speed);
        } else {
            this.getLogger().warning("Invalid particle in config: " + this.getConfig().getString("teleport_effect.particle"));
        }
        if (sound != null) {
            target.getWorld().playSound(target.getLocation(), sound, 1.0f, 1.0f);
        } else {
            this.getLogger().warning("Invalid sound in config: " + this.getConfig().getString("teleport_sound"));
        }
    }

    public Sound getSoundFromString(String soundString) {
        Sound sound;
        if (soundString == null || soundString.isEmpty()) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)soundString.toLowerCase(Locale.ROOT));
        if (key != null && (sound = (Sound)Registry.SOUNDS.get(key)) != null) {
            return sound;
        }
        try {
            return Sound.valueOf((String)soundString.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Particle getParticleFromString(String particleString) {
        Particle particle;
        if (particleString == null || particleString.isEmpty()) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)particleString.toLowerCase(Locale.ROOT));
        if (key != null && (particle = (Particle)Registry.PARTICLE_TYPE.get(key)) != null) {
            return particle;
        }
        try {
            return Particle.valueOf((String)particleString.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public void displayMessage(Player player, String message) {
        switch (this.getConfig().getString("message_display_mode", "chat").toLowerCase()) {
            case "actionbar": {
                player.sendActionBar(message);
                break;
            }
            case "title": {
                player.sendTitle("", message, 10, 70, 20);
                break;
            }
            default: {
                player.sendMessage(message);
            }
        }
    }

    public static boolean isHoldingBanMace(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() != BanMace.getBanMaceMaterial() || !item.hasItemMeta()) {
            return false;
        }
        return "unique_ban_mace".equals(item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)BanMace.getInstance(), "ban_mace"), PersistentDataType.STRING));
    }

    public static enum BanMaceMode {
        SPAWN(new SpawnMode()),
        BED(new BedMode()),
        BAN(new BanMode()),
        KICK(new KickMode()),
        FREEZE(new FreezeMode()),
        TELEPORT_TO(new TeleportToMode()),
        BALLOON(new BalloonMod());

        private final ModeHandler handler;

        private BanMaceMode(ModeHandler handler) {
            this.handler = handler;
        }

        public ModeHandler getHandler() {
            return this.handler;
        }
    }
}

