/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.nakolotnik.banMace.BanMace;
import org.nakolotnik.banMace.utils.LanguageManager;

public class CommandHandler
implements CommandExecutor,
TabCompleter {
    private final BanMace plugin;
    private static final List<String> VIEW_MODES = List.of("chat", "actionbar", "title");

    public CommandHandler(BanMace plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getPermission() != null && !sender.hasPermission(command.getPermission())) {
            sender.sendMessage(this.plugin.getMessage("no_permission"));
            return true;
        }
        return switch (command.getName().toLowerCase()) {
            case "bm-give" -> this.handleGiveCommand(sender);
            case "bm-setlanguage" -> this.handleSetLanguageCommand(sender, args);
            case "bm-tpcoordinates" -> this.handleTpCoordinatesCommand(sender, args);
            case "bm-changeview" -> this.handleChangeViewCommand(sender, args);
            case "bm-help" -> this.handleHelpCommand(sender);
            case "bm-settings" -> this.handleSettingsCommand(sender);
            default -> false;
        };
    }

    private boolean handleGiveCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("must_be_player"));
            return true;
        }
        Player player = (Player)sender;
        player.getInventory().addItem(new ItemStack[]{this.plugin.createBanMace()});
        player.sendMessage(this.plugin.getMessage("mace_given"));
        this.plugin.getLoggerService().log(String.format("Player '%s' gave themselves the BanMace.", player.getName()));
        return true;
    }

    private boolean handleSetLanguageCommand(CommandSender sender, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getMessage("language_usage"));
            return true;
        }
        String newLanguage = args[0].toLowerCase();
        LanguageManager languageManager = this.plugin.getLanguageManager();
        if (!languageManager.getAvailableLanguages().contains(newLanguage)) {
            String languages = languageManager.getAvailableLanguagesString();
            sender.sendMessage(this.plugin.getMessage("invalid_language", Map.of("languages", languages)));
            return true;
        }
        languageManager.loadMessages(newLanguage);
        this.plugin.getConfig().set("language", (Object)newLanguage);
        this.plugin.saveConfig();
        sender.sendMessage(this.plugin.getMessage("language_set", Map.of("language", newLanguage.toUpperCase())));
        this.plugin.getLoggerService().log(String.format("'%s' changed plugin language to %s.", sender.getName(), newLanguage.toUpperCase()));
        return true;
    }

    private boolean handleTpCoordinatesCommand(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("must_be_player"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 3) {
            sender.sendMessage(this.plugin.getMessage("invalid_usage", Map.of("usage", "/bm-tpcoordinates <x> <y> <z>")));
            return true;
        }
        try {
            double x = Double.parseDouble(args[0]);
            double y = Double.parseDouble(args[1]);
            double z = Double.parseDouble(args[2]);
            if (BanMace.isHoldingBanMace(player)) {
                ItemStack item = player.getInventory().getItemInMainHand();
                if (item.getItemMeta() != null) {
                    ItemMeta meta = item.getItemMeta();
                    ArrayList<String> lore = meta.hasLore() ? new ArrayList<String>(meta.getLore()) : new ArrayList();
                    lore.removeIf(line -> line.toLowerCase().contains("coordinates:"));
                    lore.add(String.format("\u00a77Coordinates: X=%.1f Y=%.1f Z=%.1f", x, y, z));
                    meta.setLore(lore);
                    item.setItemMeta(meta);
                    player.sendMessage(this.plugin.getMessage("coordinates_set", Map.of("x", String.format("%.1f", x), "y", String.format("%.1f", y), "z", String.format("%.1f", z))));
                    this.plugin.getLoggerService().log(String.format("Player '%s' set mace coordinates to (%.1f, %.1f, %.1f).", player.getName(), x, y, z));
                }
            } else {
                player.sendMessage(this.plugin.getMessage("not_holding_mace"));
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessage("invalid_usage", Map.of("usage", "/bm-tpcoordinates <x> <y> <z>")));
        }
        return true;
    }

    private boolean handleChangeViewCommand(CommandSender sender, String[] args) {
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getMessage("invalid_usage", Map.of("usage", "/bm-changeview <chat|actionbar|title>")));
            return true;
        }
        String newMode = args[0].toLowerCase();
        if (!VIEW_MODES.contains(newMode)) {
            sender.sendMessage(this.plugin.getMessage("invalid_mode"));
            return true;
        }
        this.plugin.getConfig().set("message_display_mode", (Object)newMode);
        this.plugin.saveConfig();
        sender.sendMessage(this.plugin.getMessage("view_mode_changed", Map.of("mode", newMode)));
        this.plugin.getLoggerService().log(String.format("'%s' changed message display mode to %s.", sender.getName(), newMode));
        return true;
    }

    private boolean handleHelpCommand(CommandSender sender) {
        sender.sendMessage(this.plugin.getMessage("command_help"));
        return true;
    }

    private boolean handleSettingsCommand(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("must_be_player"));
            return true;
        }
        Player player = (Player)sender;
        this.plugin.getSettingsGUI().open(player);
        this.plugin.getLoggerService().log(String.format("Player '%s' opened the settings GUI.", player.getName()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getPermission() != null && !sender.hasPermission(command.getPermission())) {
            return Collections.emptyList();
        }
        return switch (command.getName().toLowerCase()) {
            case "bm-setlanguage" -> this.completeLanguage(args);
            case "bm-tpcoordinates" -> {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    yield this.completeCoordinates(p, args);
                }
                yield Collections.emptyList();
            }
            case "bm-changeview" -> this.completeViewMode(args);
            default -> Collections.emptyList();
        };
    }

    private List<String> completeLanguage(String[] args) {
        if (args.length == 1) {
            return this.filterAndCollect(this.plugin.getLanguageManager().getAvailableLanguages(), args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> completeCoordinates(Player player, String[] args) {
        Location loc = player.getLocation();
        return switch (args.length) {
            case 1 -> List.of(String.valueOf(loc.getBlockX()));
            case 2 -> List.of(String.valueOf(loc.getBlockY()));
            case 3 -> List.of(String.valueOf(loc.getBlockZ()));
            default -> Collections.emptyList();
        };
    }

    private List<String> completeViewMode(String[] args) {
        if (args.length == 1) {
            return this.filterAndCollect(VIEW_MODES, args[0]);
        }
        return Collections.emptyList();
    }

    private List<String> filterAndCollect(List<String> source, String input) {
        return source.stream().filter(s -> s.toLowerCase().startsWith(input.toLowerCase())).collect(Collectors.toList());
    }
}

