/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DiscordWebhook {
    private final String url;
    private final JavaPlugin plugin;

    public DiscordWebhook(String url, JavaPlugin plugin) {
        this.url = url;
        this.plugin = plugin;
    }

    public void sendEmbed(EmbedObject embed) {
        if (this.url == null || this.url.trim().isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL hookUrl = new URL(this.url);
                HttpsURLConnection connection = (HttpsURLConnection)hookUrl.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                connection.setRequestProperty("User-Agent", "BanMace-Plugin/1.0");
                connection.setDoOutput(true);
                JsonObject jsonPayload = new JsonObject();
                JsonArray embedsArray = new JsonArray();
                embedsArray.add((JsonElement)embed.toJsonObject());
                jsonPayload.add("embeds", (JsonElement)embedsArray);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(jsonPayload.toString().getBytes(StandardCharsets.UTF_8));
                }
                int responseCode = connection.getResponseCode();
                if (responseCode < 200 || responseCode >= 300) {
                    this.plugin.getLogger().warning("Failed to send Discord webhook. Response code: " + responseCode);
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "utf-8"));){
                        String responseLine;
                        while ((responseLine = br.readLine()) != null) {
                            this.plugin.getLogger().warning("Discord Response: " + responseLine);
                        }
                    }
                }
                connection.disconnect();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not send Discord webhook message:");
                e.printStackTrace();
            }
        });
    }

    public static class EmbedObject {
        private String title;
        private String description;
        private Integer color;
        private String authorName;
        private String authorIconUrl;
        private String footer;

        public EmbedObject setTitle(String title) {
            this.title = title;
            return this;
        }

        public EmbedObject setDescription(String description) {
            this.description = description;
            return this;
        }

        public EmbedObject setColor(int color) {
            this.color = color;
            return this;
        }

        public EmbedObject setAuthor(String name, String iconUrl) {
            this.authorName = name;
            this.authorIconUrl = iconUrl;
            return this;
        }

        public EmbedObject setFooter(String footer) {
            this.footer = footer;
            return this;
        }

        public JsonObject toJsonObject() {
            JsonObject embed = new JsonObject();
            if (this.title != null) {
                embed.addProperty("title", this.title);
            }
            if (this.description != null) {
                embed.addProperty("description", this.description);
            }
            if (this.color != null) {
                embed.addProperty("color", (Number)this.color);
            }
            embed.addProperty("timestamp", Instant.now().toString());
            if (this.authorName != null) {
                JsonObject author = new JsonObject();
                author.addProperty("name", this.authorName);
                if (this.authorIconUrl != null) {
                    author.addProperty("icon_url", this.authorIconUrl);
                }
                embed.add("author", (JsonElement)author);
            }
            if (this.footer != null) {
                JsonObject footerObj = new JsonObject();
                footerObj.addProperty("text", this.footer);
                embed.add("footer", (JsonElement)footerObj);
            }
            return embed;
        }
    }
}

