/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.nakolotnik.banMace.BanMace;

public class ItemPickupListener
implements Listener {
    private final BanMace plugin;

    public ItemPickupListener(BanMace plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        ItemStack item = event.getItem().getItemStack();
        if (!this.isBanMace(item)) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.canInteract(player)) {
            event.setCancelled(true);
            event.getItem().remove();
            player.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        if (!this.isBanMace(item)) {
            return;
        }
        if (!this.canInteract(player)) {
            event.setCancelled(true);
            player.getInventory().remove(item);
            player.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerSwapHands(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        ItemStack mainHand = event.getMainHandItem();
        ItemStack offHand = event.getOffHandItem();
        if ((this.isBanMace(mainHand) || this.isBanMace(offHand)) && !this.canInteract(player)) {
            event.setCancelled(true);
            if (this.isBanMace(mainHand)) {
                player.getInventory().remove(mainHand);
            }
            if (this.isBanMace(offHand)) {
                player.getInventory().remove(offHand);
            }
            player.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clickedItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        if ((this.isBanMace(clickedItem) || this.isBanMace(cursorItem)) && !this.canInteract(player)) {
            event.setCancelled(true);
            if (this.isBanMace(clickedItem)) {
                event.setCurrentItem(null);
            }
            if (this.isBanMace(cursorItem)) {
                event.setCursor(null);
            }
            player.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.canInteract(player)) {
            this.removeBanMaceFromInventory(player);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damager = (Player)entity;
        ItemStack item = damager.getInventory().getItemInMainHand();
        if (!this.isBanMace(item)) {
            return;
        }
        if (!this.canInteract(damager)) {
            event.setCancelled(true);
            damager.getInventory().remove(item);
            damager.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
        }
    }

    private boolean isBanMace(ItemStack item) {
        NamespacedKey key;
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer dataContainer = meta.getPersistentDataContainer();
        return dataContainer.has(key = new NamespacedKey((Plugin)this.plugin, "ban_mace"), PersistentDataType.STRING) && "unique_ban_mace".equals(dataContainer.get(key, PersistentDataType.STRING));
    }

    private boolean canInteract(Player player) {
        if (player.isOp()) {
            return true;
        }
        if (this.plugin.getConfig().getBoolean("whitelist.enabled")) {
            return this.plugin.getConfig().getStringList("whitelist.players").contains(player.getName());
        }
        return false;
    }

    private void removeBanMaceFromInventory(Player player) {
        for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
            ItemStack item = player.getInventory().getItem(slot);
            if (!this.isBanMace(item)) continue;
            player.getInventory().setItem(slot, null);
        }
    }
}

