/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.configuration.file.YamlConfiguration;
import org.nakolotnik.banMace.BanMace;

public class LanguageManager {
    private final BanMace plugin;
    private final Map<String, String> messages;
    private String currentLanguage;
    private YamlConfiguration languageConfig;

    public LanguageManager(BanMace plugin) {
        this.plugin = plugin;
        this.messages = new HashMap<String, String>();
        this.currentLanguage = "en";
    }

    public void loadMessages(String language) {
        this.currentLanguage = language;
        File languageFile = new File(this.plugin.getDataFolder(), "message_" + language + ".yml");
        if (!languageFile.exists()) {
            this.plugin.getLogger().warning("Language file for " + language + " not found. Falling back to default (en).");
            languageFile = new File(this.plugin.getDataFolder(), "message_en.yml");
        }
        this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
        this.messages.clear();
        if (this.languageConfig.getConfigurationSection("messages") == null) {
            this.plugin.getLogger().severe("Failed to load messages from " + languageFile.getName());
            return;
        }
        for (String key : this.languageConfig.getConfigurationSection("messages").getKeys(true)) {
            if (!this.languageConfig.isString("messages." + key)) continue;
            this.messages.put("messages." + key, this.languageConfig.getString("messages." + key));
        }
        this.plugin.getLogger().info("Loaded " + this.messages.size() + " string messages for language: " + language);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.messages.getOrDefault("messages." + key, key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                message = message.replace("{" + entry.getKey() + "}", entry.getValue());
                message = message.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return message;
    }

    public String getMessage(String key) {
        return this.getMessage(key, null);
    }

    public List<String> getMessageList(String key) {
        if (this.languageConfig != null) {
            return this.languageConfig.getStringList("messages." + key);
        }
        return Collections.emptyList();
    }

    public List<String> getAvailableLanguages() {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        return Arrays.stream(Objects.requireNonNull(dataFolder.listFiles())).filter(file -> file.getName().startsWith("message_") && file.getName().endsWith(".yml")).map(file -> file.getName().substring(8, file.getName().length() - 4)).collect(Collectors.toList());
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public String getAvailableLanguagesString() {
        return String.join((CharSequence)", ", this.getAvailableLanguages());
    }

    public void checkAndLoadLanguageFiles() {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        List<String> defaultLanguages = List.of("en", "ru");
        for (String lang : defaultLanguages) {
            File languageFile = new File(dataFolder, "message_" + lang + ".yml");
            if (languageFile.exists()) continue;
            this.plugin.getLogger().info("Language file for '" + lang + "' is missing. Extracting default file...");
            this.plugin.saveResource("message_" + lang + ".yml", false);
            this.plugin.getLogger().info("Extracted 'message_" + lang + ".yml'.");
        }
    }
}

