/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import java.awt.Color;
import org.bukkit.entity.Player;
import org.nakolotnik.banMace.BanMace;
import org.nakolotnik.banMace.utils.DiscordWebhook;

public class LoggerService {
    private final BanMace plugin;
    private DiscordWebhook discordWebhook;

    public LoggerService(BanMace plugin) {
        this.plugin = plugin;
        this.reloadWebhook();
    }

    public void reloadWebhook() {
        String webhookUrl = this.plugin.getConfig().getString("logging.discord.webhook_url", "");
        this.discordWebhook = webhookUrl != null && !webhookUrl.isEmpty() ? new DiscordWebhook(webhookUrl, this.plugin) : null;
    }

    public void log(String message) {
        if (this.plugin.getConfig().getBoolean("logging.console.enabled", true)) {
            this.plugin.getLogger().info(message);
        }
    }

    public void logMaceAction(Player actor, Player target, String modeName, String actionDetails) {
        String formattedModeName = modeName.replace("_", " ").toUpperCase();
        String logMessage = String.format("%s used BanMace (%s mode) on %s. Details: %s", actor.getName(), formattedModeName, target.getName(), actionDetails);
        this.log(logMessage);
        if (this.plugin.getConfig().getBoolean("logging.discord.enabled", false) && this.discordWebhook != null) {
            DiscordWebhook.EmbedObject embed = new DiscordWebhook.EmbedObject();
            embed.setAuthor(actor.getName() + " (" + String.valueOf(actor.getUniqueId()) + ")", "https://cravatar.eu/helmavatar/" + String.valueOf(actor.getUniqueId()) + "/64.png");
            embed.setTitle("BanMace Action: " + formattedModeName);
            String description = String.format("**Target:** %s\n**Action:** %s\n**Location:** %s at (X: %d, Y: %d, Z: %d)", target.getName(), actionDetails, target.getWorld().getName(), target.getLocation().getBlockX(), target.getLocation().getBlockY(), target.getLocation().getBlockZ());
            embed.setDescription(description);
            Color awtColor = switch (modeName.toUpperCase()) {
                case "BAN", "KICK" -> Color.RED;
                case "FREEZE" -> new Color(0, 255, 255);
                case "SPAWN", "BED", "TELEPORT_TO" -> Color.YELLOW;
                default -> Color.GRAY;
            };
            embed.setColor(awtColor.getRGB() & 0xFFFFFF);
            embed.setFooter("BanMace v" + this.plugin.getDescription().getVersion());
            this.discordWebhook.sendEmbed(embed);
        }
    }
}

