/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import java.util.Map;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.nakolotnik.banMace.BanMace;

public class ModeSwitcher
implements Listener {
    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        if (!BanMace.isHoldingBanMace(player)) {
            return;
        }
        this.switchMode(player);
        this.playSwitchEffects(player);
    }

    private void switchMode(Player player) {
        BanMace plugin = BanMace.getInstance();
        Enum currentModeEnum = null;
        for (BanMace.BanMaceMode mode : BanMace.BanMaceMode.values()) {
            if (!BanMace.getCurrentMode().getClass().equals(mode.getHandler().getClass())) continue;
            currentModeEnum = mode;
            break;
        }
        BanMace.BanMaceMode nextModeEnum = currentModeEnum == null ? BanMace.BanMaceMode.SPAWN : BanMace.BanMaceMode.values()[(currentModeEnum.ordinal() + 1) % BanMace.BanMaceMode.values().length];
        BanMace.setMode(player, nextModeEnum.getHandler());
        String modeNameKey = "mode_" + nextModeEnum.name().toLowerCase();
        String translatedModeName = plugin.getMessage(modeNameKey);
        String message = plugin.getMessage("mode_switched", Map.of("mode", translatedModeName));
        plugin.displayMessage(player, message);
    }

    private void playSwitchEffects(Player player) {
        BanMace plugin = BanMace.getInstance();
        String soundName = plugin.getConfig().getString("additional_effects.mode_switch_sound", "block.note_block.pling");
        String particleName = plugin.getConfig().getString("additional_effects.mode_switch_particle", "witch");
        Sound sound = plugin.getSoundFromString(soundName);
        if (sound != null) {
            player.getWorld().playSound(player.getLocation(), sound, 1.0f, 1.5f);
        } else {
            plugin.getLogger().warning("Invalid mode_switch_sound in config: " + soundName);
        }
        Particle particle = plugin.getParticleFromString(particleName);
        if (particle != null) {
            player.getWorld().spawnParticle(particle, player.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
        } else {
            plugin.getLogger().warning("Invalid mode_switch_particle in config: " + particleName);
        }
    }
}

