/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.nakolotnik.banMace.BanMace;

public class RadialMenuManager
implements Listener {
    private final BanMace plugin;
    private final Map<UUID, List<Entity>> activeMenus = new HashMap<UUID, List<Entity>>();
    private final Map<UUID, BanMace.BanMaceMode> selectedModes = new HashMap<UUID, BanMace.BanMaceMode>();
    private final Map<UUID, BukkitTask> menuUpdateTasks = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Location> menuCenters = new HashMap<UUID, Location>();
    private final Map<UUID, Integer> animationTicks = new HashMap<UUID, Integer>();
    private final Map<UUID, Boolean> isAnimating = new HashMap<UUID, Boolean>();
    private final Map<UUID, Integer> spawnOrder = new HashMap<UUID, Integer>();
    private final Set<Material> iconMaterials;

    public RadialMenuManager(BanMace plugin) {
        this.plugin = plugin;
        this.iconMaterials = Arrays.stream(BanMace.BanMaceMode.values()).map(this::getIconForMode).collect(Collectors.toSet());
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSwapHand(PlayerSwapHandItemsEvent event) {
        Player player = event.getPlayer();
        if (!BanMace.isHoldingBanMace(player)) {
            return;
        }
        event.setCancelled(true);
        if (!this.canUseRadialMenu(player)) {
            player.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
            player.getInventory().remove(player.getInventory().getItemInMainHand());
            return;
        }
        if (this.activeMenus.containsKey(player.getUniqueId())) {
            this.closeMenu(player, true);
        } else {
            this.openMenu(player);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.closeMenu(event.getPlayer(), false);
    }

    private void openMenu(final Player player) {
        if (!this.canUseRadialMenu(player)) {
            player.sendMessage(this.plugin.getMessage("item_removed_no_permission"));
            player.getInventory().remove(player.getInventory().getItemInMainHand());
            return;
        }
        final List<BanMace.BanMaceMode> modes = Arrays.asList(BanMace.BanMaceMode.values());
        if (modes.isEmpty()) {
            return;
        }
        Location center = player.getEyeLocation().add(player.getEyeLocation().getDirection().multiply(4.0));
        this.menuCenters.put(player.getUniqueId(), center);
        ArrayList spawnedEntities = new ArrayList();
        this.activeMenus.put(player.getUniqueId(), spawnedEntities);
        this.animationTicks.put(player.getUniqueId(), 0);
        this.isAnimating.put(player.getUniqueId(), true);
        this.spawnOrder.put(player.getUniqueId(), 0);
        player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.5f);
        BukkitTask task = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() || !RadialMenuManager.this.activeMenus.containsKey(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                if (!RadialMenuManager.this.canUseRadialMenu(player)) {
                    RadialMenuManager.this.closeMenu(player, false);
                    player.sendMessage(RadialMenuManager.this.plugin.getMessage("item_removed_no_permission"));
                    player.getInventory().remove(player.getInventory().getItemInMainHand());
                    this.cancel();
                    return;
                }
                if (RadialMenuManager.this.isAnimating.get(player.getUniqueId()).booleanValue()) {
                    RadialMenuManager.this.animateSpawn(player, modes);
                } else {
                    RadialMenuManager.this.updateSelection(player);
                    RadialMenuManager.this.animateMenu(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.menuUpdateTasks.put(player.getUniqueId(), task);
    }

    private void animateSpawn(Player player, List<BanMace.BanMaceMode> modes) {
        UUID uuid = player.getUniqueId();
        int currentOrder = this.spawnOrder.get(uuid);
        int tick = this.animationTicks.get(uuid);
        if (tick % 4 == 0 && currentOrder < modes.size()) {
            this.spawnMenuItem(player, modes.get(currentOrder), currentOrder, modes.size());
            this.spawnOrder.put(uuid, currentOrder + 1);
            player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.7f, 1.2f + (float)currentOrder * 0.1f);
        }
        if (currentOrder >= modes.size()) {
            this.isAnimating.put(uuid, false);
            player.playSound(player.getLocation(), Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 1.5f);
        }
        this.animationTicks.put(uuid, tick + 1);
    }

    private void spawnMenuItem(final Player player, BanMace.BanMaceMode mode, int index, int totalModes) {
        UUID uuid = player.getUniqueId();
        Location center = this.menuCenters.get(uuid);
        if (center == null) {
            return;
        }
        Vector direction = player.getEyeLocation().getDirection().normalize();
        Vector sideVector = new Vector(0, 1, 0).crossProduct(direction).normalize();
        Vector upVector = direction.crossProduct(sideVector).normalize();
        double angle = Math.PI * 2 / (double)totalModes * (double)index - 1.5707963267948966;
        double radius = 2.2;
        Vector offset = sideVector.clone().multiply(radius * Math.cos(angle)).add(upVector.clone().multiply(radius * Math.sin(angle)));
        Location iconLocation = center.clone().add(offset);
        Material iconMaterial = this.getIconForMode(mode);
        ItemStack iconStack = new ItemStack(iconMaterial);
        String modeDisplayName = this.plugin.getMessage("mode_" + mode.name().toLowerCase());
        final ItemDisplay iconDisplay = (ItemDisplay)iconLocation.getWorld().spawn(iconLocation, ItemDisplay.class, display -> {
            display.setItemStack(iconStack);
            Transformation transformation = display.getTransformation();
            transformation.getScale().set(0.1f, 0.1f, 0.1f);
            display.setTransformation(transformation);
        });
        final ArmorStand labelStand = (ArmorStand)iconLocation.getWorld().spawn(iconLocation.clone().add(0.0, 0.5, 0.0), ArmorStand.class, as -> {
            as.setGravity(false);
            as.setVisible(false);
            as.setMarker(true);
            as.setCustomName(String.valueOf(ChatColor.WHITE) + modeDisplayName);
            as.setCustomNameVisible(false);
            as.addPassenger((Entity)iconDisplay);
        });
        List<Entity> spawnedEntities = this.activeMenus.get(uuid);
        spawnedEntities.add((Entity)iconDisplay);
        spawnedEntities.add((Entity)labelStand);
        iconLocation.getWorld().spawnParticle(Particle.POOF, iconLocation, 8, 0.2, 0.2, 0.2, 0.1);
        iconLocation.getWorld().spawnParticle(Particle.ENCHANT, iconLocation, 5, 0.3, 0.3, 0.3, 0.05);
        new BukkitRunnable(this){
            private int animTicks = 0;
            private final int maxTicks = 10;

            public void run() {
                float scale;
                if (!iconDisplay.isValid() || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                ++this.animTicks;
                float progress = (float)this.animTicks / 10.0f;
                if (progress <= 0.7f) {
                    scale = 0.1f + 0.8f * progress / 0.7f;
                } else {
                    float bounceProgress = (progress - 0.7f) / 0.3f;
                    scale = 0.9f - 0.3f * bounceProgress;
                }
                Transformation t = iconDisplay.getTransformation();
                t.getScale().set(scale, scale, scale);
                iconDisplay.setTransformation(t);
                if (this.animTicks >= 10) {
                    labelStand.setCustomNameVisible(true);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private void animateMenu(Player player) {
        UUID uuid = player.getUniqueId();
        int ticks = this.animationTicks.getOrDefault(uuid, 0);
        Location center = this.menuCenters.get(uuid);
        if (center == null) {
            return;
        }
        if (ticks % 6 == 0) {
            center.getWorld().spawnParticle(Particle.ENCHANT, center, 5, 0.3, 0.3, 0.3, 0.05);
        }
        if (ticks % 8 == 0) {
            double angle = (double)ticks * 0.1 % (Math.PI * 2);
            Vector offset = new Vector(Math.cos(angle) * 0.5, 0.0, Math.sin(angle) * 0.5);
            center.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, center.clone().add(offset), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.animationTicks.put(uuid, ticks + 1);
    }

    private void updateSelection(Player player) {
        ArmorStand closestStand = null;
        double minAngle = Double.MAX_VALUE;
        List<Entity> menuEntities = this.activeMenus.get(player.getUniqueId());
        if (menuEntities == null) {
            return;
        }
        for (Entity entity : menuEntities) {
            if (!(entity instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)entity;
            Vector toStand = stand.getEyeLocation().toVector().subtract(player.getEyeLocation().toVector());
            double angle = player.getEyeLocation().getDirection().angle(toStand);
            if (!(angle < minAngle)) continue;
            minAngle = angle;
            closestStand = stand;
        }
        this.unhighlightAll(player);
        double selectionThreshold = 0.3;
        if (closestStand != null && minAngle < selectionThreshold) {
            this.highlight(closestStand, player);
            String customName = ChatColor.stripColor((String)closestStand.getCustomName());
            for (BanMace.BanMaceMode mode : BanMace.BanMaceMode.values()) {
                if (!customName.equals(this.plugin.getMessage("mode_" + mode.name().toLowerCase()))) continue;
                if (this.selectedModes.get(player.getUniqueId()) != mode) {
                    player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.5f);
                }
                this.selectedModes.put(player.getUniqueId(), mode);
                break;
            }
        } else {
            this.selectedModes.remove(player.getUniqueId());
        }
    }

    private void highlight(ArmorStand stand, Player player) {
        stand.setCustomName(String.valueOf(ChatColor.YELLOW) + String.valueOf(ChatColor.BOLD) + ChatColor.stripColor((String)stand.getCustomName()));
        stand.getPassengers().stream().filter(e -> e instanceof ItemDisplay).map(e -> (ItemDisplay)e).findFirst().ifPresent(iconDisplay -> {
            Transformation t = iconDisplay.getTransformation();
            t.getScale().set(0.9f, 0.9f, 0.9f);
            iconDisplay.setTransformation(t);
            iconDisplay.setGlowing(true);
            Location loc = iconDisplay.getLocation();
            loc.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, loc, 3, 0.2, 0.2, 0.2, 0.0);
        });
    }

    private void unhighlightAll(Player player) {
        List<Entity> menuEntities = this.activeMenus.get(player.getUniqueId());
        if (menuEntities == null) {
            return;
        }
        for (Entity entity : menuEntities) {
            ItemDisplay display;
            if (entity instanceof ArmorStand) {
                ArmorStand stand = (ArmorStand)entity;
                stand.setCustomName(String.valueOf(ChatColor.WHITE) + ChatColor.stripColor((String)stand.getCustomName()));
                continue;
            }
            if (!(entity instanceof ItemDisplay) || !this.iconMaterials.contains((display = (ItemDisplay)entity).getItemStack().getType())) continue;
            Transformation t = display.getTransformation();
            t.getScale().set(0.6f, 0.6f, 0.6f);
            display.setTransformation(t);
            display.setGlowing(false);
        }
    }

    public void closeMenu(Player player, boolean confirm) {
        BanMace.BanMaceMode selected;
        List<Entity> entities;
        Location center;
        UUID uuid = player.getUniqueId();
        if (!this.activeMenus.containsKey(uuid)) {
            return;
        }
        if (this.menuUpdateTasks.containsKey(uuid)) {
            this.menuUpdateTasks.get(uuid).cancel();
            this.menuUpdateTasks.remove(uuid);
        }
        if ((center = this.menuCenters.get(uuid)) != null) {
            center.getWorld().spawnParticle(Particle.EXPLOSION, center, 1, 0.0, 0.0, 0.0, 0.0);
            center.getWorld().spawnParticle(Particle.POOF, center, 15, 0.5, 0.5, 0.5, 0.1);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.2f);
        }
        if ((entities = this.activeMenus.get(uuid)) != null) {
            for (Entity entity : entities) {
                if (entity instanceof ItemDisplay) {
                    final ItemDisplay display = (ItemDisplay)entity;
                    new BukkitRunnable(this){
                        private int ticks = 0;

                        public void run() {
                            if (!display.isValid() || this.ticks >= 5) {
                                display.remove();
                                this.cancel();
                                return;
                            }
                            Transformation t = display.getTransformation();
                            float scale = 0.6f * (1.0f - (float)this.ticks / 5.0f);
                            t.getScale().set(scale, scale, scale);
                            display.setTransformation(t);
                            ++this.ticks;
                        }
                    }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
                    continue;
                }
                entity.remove();
            }
        }
        this.activeMenus.remove(uuid);
        this.menuCenters.remove(uuid);
        this.animationTicks.remove(uuid);
        this.isAnimating.remove(uuid);
        this.spawnOrder.remove(uuid);
        if (confirm && (selected = this.selectedModes.get(uuid)) != null) {
            BanMace.setMode(player, selected.getHandler());
            String modeName = this.plugin.getMessage("mode_" + selected.name().toLowerCase());
            String message = this.plugin.getMessage("mode_switched", Map.of("mode", modeName));
            this.plugin.displayMessage(player, message);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
        }
        this.selectedModes.remove(uuid);
    }

    private Material getIconForMode(BanMace.BanMaceMode mode) {
        return switch (mode) {
            case BanMace.BanMaceMode.SPAWN -> Material.COMPASS;
            case BanMace.BanMaceMode.BED -> Material.RED_BED;
            case BanMace.BanMaceMode.BAN -> Material.TNT;
            case BanMace.BanMaceMode.KICK -> Material.IRON_DOOR;
            case BanMace.BanMaceMode.FREEZE -> Material.ICE;
            case BanMace.BanMaceMode.TELEPORT_TO -> Material.ENDER_PEARL;
            case BanMace.BanMaceMode.BALLOON -> Material.STRING;
            default -> Material.BARRIER;
        };
    }

    private boolean canUseRadialMenu(Player player) {
        if (player.isOp()) {
            return true;
        }
        if (this.plugin.getConfig().getBoolean("whitelist.enabled")) {
            return this.plugin.getConfig().getStringList("whitelist.players").contains(player.getName());
        }
        return false;
    }
}

