/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.nakolotnik.banMace.BanMace;
import org.nakolotnik.banMace.utils.LanguageManager;

public class SettingsGUI
implements Listener {
    private final BanMace plugin;
    private final Map<UUID, PlayerSession> playerSessions = new ConcurrentHashMap<UUID, PlayerSession>();
    private final Map<UUID, String> playerInputMap = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, BukkitRunnable> pendingAnimations = new ConcurrentHashMap<UUID, BukkitRunnable>();
    private final List<Material> ALLOWED_MATERIALS;
    private final List<Particle> particleList;
    private final List<Sound> soundList;
    private static final int[] BORDER_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 17, 18, 26, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53};

    private String getMainGuiTitle() {
        return this.plugin.getMessage("gui.title.main");
    }

    private String getParticleGuiTitle() {
        return this.plugin.getMessage("gui.title.particle");
    }

    private String getSoundGuiTitle() {
        return this.plugin.getMessage("gui.title.sound");
    }

    private String getItemGuiTitle() {
        return this.plugin.getMessage("gui.title.item");
    }

    private String getConfirmGuiTitle() {
        return this.plugin.getMessage("gui.title.confirm");
    }

    public SettingsGUI(BanMace plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.ALLOWED_MATERIALS = Arrays.stream(Material.values()).filter(this::isAllowedMaterial).sorted(Comparator.comparing(m -> {
            NamespacedKey key = Registry.MATERIAL.getKey((Keyed)m);
            return key != null ? key.value() : "zzz";
        })).collect(Collectors.toList());
        this.particleList = Registry.PARTICLE_TYPE.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.soundList = Registry.SOUNDS.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean isAllowedMaterial(Material material) {
        NamespacedKey key = Registry.MATERIAL.getKey((Keyed)material);
        if (key == null || !material.isItem()) {
            return false;
        }
        String keyStr = key.value();
        return (keyStr.endsWith("_sword") || keyStr.endsWith("_axe") || keyStr.endsWith("_pickaxe") || keyStr.endsWith("_shovel") || keyStr.endsWith("_hoe") || material == Material.MACE || material == Material.TRIDENT || material == Material.STICK || material == Material.BLAZE_ROD) && !keyStr.startsWith("wooden_axe");
    }

    private PlayerSession getOrCreateSession(UUID uuid) {
        return this.playerSessions.computeIfAbsent(uuid, k -> new PlayerSession());
    }

    public void open(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)this.getMainGuiTitle());
        this.initializeMainItems(gui, player);
        player.openInventory(gui);
        this.startInventoryAnimation(player, gui);
    }

    private void startInventoryAnimation(final Player player, final Inventory gui) {
        BukkitRunnable animation = new BukkitRunnable(){
            private int ticks = 0;

            public void run() {
                if (this.ticks > 20 || !player.getOpenInventory().getTopInventory().equals((Object)gui)) {
                    this.cancel();
                    return;
                }
                if (this.ticks % 10 == 0) {
                    ItemStack animBorder = SettingsGUI.this.createGuiItem(this.ticks % 20 == 0 ? Material.ORANGE_STAINED_GLASS_PANE : Material.YELLOW_STAINED_GLASS_PANE, "\u00a78", new String[0]);
                    gui.setItem(0, animBorder);
                    gui.setItem(8, animBorder);
                    gui.setItem(45, animBorder);
                    gui.setItem(53, animBorder);
                }
                ++this.ticks;
            }
        };
        animation.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        this.pendingAnimations.put(player.getUniqueId(), animation);
    }

    private void initializeMainItems(Inventory gui, Player player) {
        gui.clear();
        this.fillBorders(gui);
        String currentLang = this.plugin.getLanguageManager().getCurrentLanguage();
        String currentView = this.plugin.getConfig().getString("message_display_mode", "chat");
        boolean whitelistOn = this.plugin.getConfig().getBoolean("whitelist.enabled");
        boolean updatesOn = this.plugin.getConfig().getBoolean("check_for_updates");
        String currentParticle = this.plugin.getConfig().getString("teleport_effect.particle", "portal");
        String currentSound = this.plugin.getConfig().getString("teleport_sound", "entity.enderman.teleport");
        String webhookUrl = this.plugin.getConfig().getString("logging.discord.webhook_url", "");
        boolean discordLogOn = this.plugin.getConfig().getBoolean("logging.discord.enabled");
        String statusEnabled = this.plugin.getMessage("gui.status.enabled");
        String statusDisabled = this.plugin.getMessage("gui.status.disabled");
        String webhookConfigured = this.plugin.getMessage("gui.webhook.configured");
        String webhookNotConfigured = this.plugin.getMessage("gui.webhook.not_configured");
        List<String> availableLangs = this.plugin.getLanguageManager().getAvailableLanguages();
        String formattedLangs = availableLangs.stream().map(lang -> (lang.equals(currentLang) ? "\u00a7b\u00a7l" : "\u00a7b") + lang.toUpperCase()).collect(Collectors.joining(" \u00a78| "));
        gui.setItem(10, this.createGuiItem(Material.ENCHANTED_BOOK, this.plugin.getMessage("gui.main.language.title"), this.plugin.getMessage("gui.main.lore.current", Map.of("value", currentLang.toUpperCase())), this.plugin.getMessage("gui.main.language.lore_1"), this.plugin.getMessage("gui.main.language.lore_available_title"), this.plugin.getMessage("gui.main.language.lore_languages_format", Map.of("languages", formattedLangs)), this.plugin.getMessage("gui.main.language.lore_4"), "", this.plugin.getMessage("gui.main.lore.click_to_cycle")));
        gui.setItem(11, this.createGuiItem(Material.OAK_SIGN, this.plugin.getMessage("gui.main.display_mode.title"), this.plugin.getMessage("gui.main.lore.current", Map.of("value", currentView.toUpperCase())), this.plugin.getMessage("gui.main.display_mode.lore_1"), this.plugin.getMessage("gui.main.display_mode.lore_2"), this.plugin.getMessage("gui.main.display_mode.lore_3"), this.plugin.getMessage("gui.main.display_mode.lore_4"), this.plugin.getMessage("gui.main.display_mode.lore_5"), "", this.plugin.getMessage("gui.main.lore.click_to_cycle")));
        gui.setItem(12, this.createGuiItem(whitelistOn ? Material.LIME_WOOL : Material.RED_WOOL, this.plugin.getMessage("gui.main.whitelist.title"), this.plugin.getMessage("gui.main.lore.status", Map.of("status", whitelistOn ? statusEnabled : statusDisabled)), "", this.plugin.getMessage("gui.main.whitelist.lore_1"), this.plugin.getMessage("gui.main.whitelist.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_toggle")));
        gui.setItem(13, this.createGuiItem(updatesOn ? Material.LIME_DYE : Material.GRAY_DYE, this.plugin.getMessage("gui.main.update_checker.title"), this.plugin.getMessage("gui.main.lore.status", Map.of("status", updatesOn ? statusEnabled : statusDisabled)), "", this.plugin.getMessage("gui.main.update_checker.lore_1"), this.plugin.getMessage("gui.main.update_checker.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_toggle")));
        gui.setItem(15, this.createGuiItem(BanMace.getBanMaceMaterial(), this.plugin.getMessage("gui.main.mace_item.title"), this.plugin.getMessage("gui.main.lore.current", Map.of("value", this.formatMaterialName(BanMace.getBanMaceMaterial()))), "", this.plugin.getMessage("gui.main.mace_item.lore_1"), this.plugin.getMessage("gui.main.mace_item.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_open")));
        gui.setItem(16, this.createGuiItem(Material.NETHER_STAR, this.plugin.getMessage("gui.main.teleport_effects.title"), this.plugin.getMessage("gui.main.lore.particle", Map.of("value", this.formatEnumName(currentParticle))), "", this.plugin.getMessage("gui.main.teleport_effects.lore_1"), this.plugin.getMessage("gui.main.teleport_effects.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_browse"), this.plugin.getMessage("gui.main.lore.right_click_preview")));
        gui.setItem(19, this.createGuiItem(Material.NOTE_BLOCK, this.plugin.getMessage("gui.main.sound_effects.title"), this.plugin.getMessage("gui.main.lore.sound", Map.of("value", this.formatEnumName(currentSound))), "", this.plugin.getMessage("gui.main.sound_effects.lore_1"), this.plugin.getMessage("gui.main.sound_effects.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_browse"), this.plugin.getMessage("gui.main.lore.right_click_preview")));
        gui.setItem(20, this.createGuiItem(Material.WRITABLE_BOOK, this.plugin.getMessage("gui.main.discord_integration.title"), this.plugin.getMessage("gui.main.lore.webhook", Map.of("status", webhookUrl.isEmpty() ? webhookNotConfigured : webhookConfigured)), "", this.plugin.getMessage("gui.main.discord_integration.lore_1"), this.plugin.getMessage("gui.main.discord_integration.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_configure")));
        gui.setItem(21, this.createGuiItem(discordLogOn ? Material.LIME_DYE : Material.GRAY_DYE, this.plugin.getMessage("gui.main.discord_logging.title"), this.plugin.getMessage("gui.main.lore.status", Map.of("status", discordLogOn ? statusEnabled : statusDisabled)), "", this.plugin.getMessage("gui.main.discord_logging.lore_1"), this.plugin.getMessage("gui.main.discord_logging.lore_2"), "", this.plugin.getMessage("gui.main.lore.click_to_toggle")));
        gui.setItem(49, this.createGuiItem(Material.BARRIER, this.plugin.getMessage("gui.main.close.title"), this.plugin.getMessage("gui.main.close.lore_1"), "", this.plugin.getMessage("gui.main.lore.click_to_close")));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String title = event.getView().getTitle();
        if (!(title.equals(this.getMainGuiTitle()) || title.equals(this.getParticleGuiTitle()) || title.equals(this.getSoundGuiTitle()) || title.equals(this.getItemGuiTitle()) || title.equals(this.getConfirmGuiTitle()))) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        PlayerSession session = this.getOrCreateSession(player.getUniqueId());
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 0.5f, 1.0f);
        if (title.equals(this.getMainGuiTitle())) {
            this.handleMainGUIClick(event, player, session);
        } else if (title.equals(this.getParticleGuiTitle())) {
            this.handleParticleGUIClick(event, player, session);
        } else if (title.equals(this.getSoundGuiTitle())) {
            this.handleSoundGUIClick(event, player, session);
        } else if (title.equals(this.getItemGuiTitle())) {
            this.handleItemGUIClick(event, player, session);
        } else if (title.equals(this.getConfirmGuiTitle())) {
            this.handleConfirmationGUIClick(event, player, session);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        BukkitRunnable animation = this.pendingAnimations.remove(uuid);
        if (animation != null) {
            animation.cancel();
        }
    }

    private void handleMainGUIClick(InventoryClickEvent event, Player player, PlayerSession session) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        switch (slot) {
            case 10: {
                this.cycleLanguage(player);
                return;
            }
            case 11: {
                this.cycleDisplayMode(player);
                break;
            }
            case 12: {
                session.confirmAction = "toggle_whitelist";
                this.openConfirmationGUI(player, "toggle_whitelist", this.plugin.getMessage("gui.main.whitelist.title"));
                return;
            }
            case 13: {
                this.toggleBoolean(player, "check_for_updates", this.plugin.getMessage("gui.main.update_checker.title"));
                break;
            }
            case 15: {
                this.openItemMenu(player, session, 0);
                return;
            }
            case 16: {
                if (event.isRightClick()) {
                    this.previewCurrentParticle(player);
                } else {
                    this.openParticleMenu(player, session, 0);
                }
                return;
            }
            case 19: {
                if (event.isRightClick()) {
                    this.previewCurrentSound(player);
                } else {
                    this.openSoundMenu(player, session, 0);
                }
                return;
            }
            case 20: {
                session.confirmAction = "edit_webhook";
                this.openConfirmationGUI(player, "edit_webhook", this.plugin.getMessage("gui.main.discord_integration.title"));
                return;
            }
            case 21: {
                this.toggleBoolean(player, "logging.discord.enabled", this.plugin.getMessage("gui.main.discord_logging.title"));
                break;
            }
            case 49: {
                player.closeInventory();
                player.sendMessage(this.plugin.getMessage("gui.message.settings_saved"));
                return;
            }
            default: {
                return;
            }
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (player.getOpenInventory().getTitle().equals(this.getMainGuiTitle())) {
                this.initializeMainItems(event.getInventory(), player);
            }
        });
    }

    private void cycleLanguage(Player player) {
        LanguageManager langManager = this.plugin.getLanguageManager();
        List<String> languages = langManager.getAvailableLanguages();
        if (languages.isEmpty()) {
            player.sendMessage(this.plugin.getMessage("no_languages_available"));
            return;
        }
        String currentLang = langManager.getCurrentLanguage();
        int currentIndex = languages.indexOf(currentLang);
        String newLang = languages.get((currentIndex + 1) % languages.size());
        this.plugin.getConfig().set("language", (Object)newLang);
        this.plugin.saveConfig();
        langManager.loadMessages(newLang);
        player.sendMessage(this.plugin.getMessage("gui.message.language_changed", Map.of("language", newLang.toUpperCase())));
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.3f);
        this.open(player);
    }

    private void previewCurrentParticle(Player player) {
        String particleKey = this.plugin.getConfig().getString("teleport_effect.particle", "portal");
        Particle particle = (Particle)Registry.PARTICLE_TYPE.get(NamespacedKey.fromString((String)particleKey));
        if (particle != null) {
            this.spawnParticleSafely(player, particle, player.getLocation().add(0.0, 1.0, 0.0));
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.2f);
            player.sendMessage(this.plugin.getMessage("gui.message.preview_particle", Map.of("particle", this.formatEnumName(particleKey))));
        }
    }

    private void previewCurrentSound(Player player) {
        String soundKey = this.plugin.getConfig().getString("teleport_sound", "entity.enderman.teleport");
        Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)soundKey));
        if (sound != null) {
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            player.sendMessage(this.plugin.getMessage("gui.message.preview_sound", Map.of("sound", this.formatEnumName(soundKey))));
        }
    }

    private void spawnParticleSafely(Player player, Particle particle, Location location) {
        try {
            if (particle.getDataType() == Void.class) {
                player.getWorld().spawnParticle(particle, location, 30, 0.5, 0.5, 0.5, 0.1);
            } else if (particle.getDataType() == Particle.DustOptions.class) {
                Particle.DustOptions dustOptions = new Particle.DustOptions(Color.RED, 1.0f);
                player.getWorld().spawnParticle(particle, location, 30, 0.5, 0.5, 0.5, (Object)dustOptions);
            } else if (particle.getDataType() == Particle.DustTransition.class) {
                Particle.DustTransition dustTransition = new Particle.DustTransition(Color.RED, Color.YELLOW, 1.0f);
                player.getWorld().spawnParticle(particle, location, 30, 0.5, 0.5, 0.5, (Object)dustTransition);
            } else if (particle.getDataType() == ItemStack.class) {
                player.getWorld().spawnParticle(particle, location, 30, 0.5, 0.5, 0.5, (Object)new ItemStack(Material.STONE));
            } else {
                player.getWorld().spawnParticle(particle, location, 30, 0.5, 0.5, 0.5, 0.1);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Could not spawn preview for particle " + particle.name() + ": " + e.getMessage());
            player.sendMessage(this.plugin.getMessage("gui.message.preview_failed", Map.of("particle", particle.name())));
        }
    }

    private void openItemMenu(Player player, PlayerSession session, int page) {
        session.itemPage = page;
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)this.getItemGuiTitle());
        int itemsPerPage = 36;
        int startIndex = page * itemsPerPage;
        this.fillSelectionBorders(gui);
        int slot = 9;
        for (int i = 0; i < itemsPerPage && startIndex + i < this.ALLOWED_MATERIALS.size(); ++i) {
            Material material = this.ALLOWED_MATERIALS.get(startIndex + i);
            gui.setItem(slot++, this.createGuiItem(material, "\u00a7c\ud83d\udd28 " + this.formatMaterialName(material), "\u00a77Click to select this item."));
        }
        this.addNavigationButtons(gui, page, this.ALLOWED_MATERIALS.size(), itemsPerPage);
        player.openInventory(gui);
    }

    private ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            if (material == Material.ENCHANTED_BOOK || material == Material.NETHER_STAR || material == Material.LIME_WOOL || material == Material.LIME_DYE) {
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_ATTRIBUTES});
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private void fillBorders(Inventory gui) {
        ItemStack borderItem = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, "\u00a78", new String[0]);
        ItemStack accentItem = this.createGuiItem(Material.ORANGE_STAINED_GLASS_PANE, "\u00a78", new String[0]);
        for (int slot : BORDER_SLOTS) {
            gui.setItem(slot, slot == 0 || slot == 8 || slot == 45 || slot == 53 ? accentItem : borderItem);
        }
    }

    private void fillSelectionBorders(Inventory gui) {
        int i;
        ItemStack borderItem = this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a78", new String[0]);
        for (i = 0; i < 9; ++i) {
            gui.setItem(i, borderItem);
        }
        for (i = 45; i < 54; ++i) {
            gui.setItem(i, borderItem);
        }
    }

    private void handleParticleGUIClick(InventoryClickEvent event, Player player, PlayerSession session) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        if (clickedItem.getType() == Material.ARROW) {
            if (displayName.equals(this.plugin.getMessage("gui.selection.page_next"))) {
                this.openParticleMenu(player, session, session.particlePage + 1);
            } else if (displayName.equals(this.plugin.getMessage("gui.selection.page_prev"))) {
                this.openParticleMenu(player, session, session.particlePage - 1);
            }
        } else if (clickedItem.getType() == Material.BARRIER) {
            this.open(player);
        } else if (clickedItem.getType() == Material.GLOWSTONE_DUST || clickedItem.getType() == Material.GLOWSTONE) {
            Particle particle;
            String particleKey = ChatColor.stripColor((String)displayName).replace("\u2728 ", "").trim();
            if (event.isLeftClick()) {
                this.plugin.getConfig().set("teleport_effect.particle", (Object)particleKey);
                this.plugin.saveConfig();
                player.sendMessage(this.plugin.getMessage("gui.message.particle_set", Map.of("particle", this.formatEnumName(particleKey))));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 1.5f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.open(player), 20L);
            } else if (event.isRightClick() && (particle = (Particle)Registry.PARTICLE_TYPE.get(NamespacedKey.fromString((String)particleKey))) != null) {
                this.spawnParticleSafely(player, particle, player.getLocation().add(0.0, 1.0, 0.0));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.2f);
                player.sendMessage(this.plugin.getMessage("gui.message.preview_particle", Map.of("particle", this.formatEnumName(particleKey))));
            }
        }
    }

    private void handleSoundGUIClick(InventoryClickEvent event, Player player, PlayerSession session) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        if (clickedItem.getType() == Material.ARROW) {
            if (displayName.equals(this.plugin.getMessage("gui.selection.page_next"))) {
                this.openSoundMenu(player, session, session.soundPage + 1);
            } else if (displayName.equals(this.plugin.getMessage("gui.selection.page_prev"))) {
                this.openSoundMenu(player, session, session.soundPage - 1);
            }
        } else if (clickedItem.getType() == Material.BARRIER) {
            this.open(player);
        } else if (clickedItem.getType() == Material.NOTE_BLOCK || clickedItem.getType() == Material.JUKEBOX) {
            String soundKey = ChatColor.stripColor((String)displayName).replace("\ud83d\udd0a ", "").trim();
            Sound sound = (Sound)Registry.SOUNDS.get(NamespacedKey.fromString((String)soundKey));
            if (sound == null) {
                return;
            }
            if (event.isLeftClick()) {
                this.plugin.getConfig().set("teleport_sound", (Object)soundKey);
                this.plugin.saveConfig();
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
                player.sendMessage(this.plugin.getMessage("gui.message.sound_set", Map.of("sound", this.formatEnumName(soundKey))));
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.open(player), 20L);
            } else if (event.isRightClick()) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
                player.sendMessage(this.plugin.getMessage("gui.message.preview_sound", Map.of("sound", this.formatEnumName(soundKey))));
            }
        }
    }

    private void handleItemGUIClick(InventoryClickEvent event, Player player, PlayerSession session) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = clickedItem.getItemMeta();
        if (meta == null) {
            return;
        }
        String displayName = meta.getDisplayName();
        if (clickedItem.getType() == Material.ARROW) {
            if (displayName.equals(this.plugin.getMessage("gui.selection.page_next"))) {
                this.openItemMenu(player, session, session.itemPage + 1);
            } else if (displayName.equals(this.plugin.getMessage("gui.selection.page_prev"))) {
                this.openItemMenu(player, session, session.itemPage - 1);
            }
        } else if (clickedItem.getType() == Material.BARRIER) {
            this.open(player);
        } else if (this.ALLOWED_MATERIALS.contains(clickedItem.getType())) {
            Material selectedMaterial = clickedItem.getType();
            Material oldMaterial = BanMace.getBanMaceMaterial();
            if (oldMaterial == selectedMaterial) {
                player.sendMessage(this.plugin.getMessage("gui.message.item_already_set"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, 0.8f);
                return;
            }
            NamespacedKey key = Registry.MATERIAL.getKey((Keyed)selectedMaterial);
            if (key != null) {
                this.plugin.getConfig().set("item_customization.item_material", (Object)key.value());
                this.plugin.saveConfig();
                this.plugin.reloadBanMaceMaterial();
                int updatedCount = this.replaceExistingMaces(oldMaterial, selectedMaterial);
                player.sendMessage(this.plugin.getMessage("gui.message.item_set", Map.of("item", this.formatMaterialName(selectedMaterial))));
                if (updatedCount > 0) {
                    player.sendMessage(this.plugin.getMessage("gui.message.maces_updated_globally", Map.of("count", String.valueOf(updatedCount))));
                }
                player.playSound(player.getLocation(), Sound.BLOCK_ANVIL_USE, 0.7f, 1.2f);
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.open(player), 20L);
            }
        }
    }

    private int replaceExistingMaces(Material oldMaterial, Material newMaterial) {
        int updatedCount = 0;
        NamespacedKey maceKey = new NamespacedKey((Plugin)this.plugin, "ban_mace");
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            PlayerInventory inventory = onlinePlayer.getInventory();
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemMeta meta;
                ItemStack item = inventory.getItem(i);
                if (item == null || item.getType() != oldMaterial || !item.hasItemMeta() || !(meta = item.getItemMeta()).getPersistentDataContainer().has(maceKey, PersistentDataType.STRING)) continue;
                ItemStack newMace = new ItemStack(newMaterial);
                newMace.setItemMeta(meta);
                inventory.setItem(i, newMace);
                ++updatedCount;
                onlinePlayer.sendMessage(this.plugin.getMessage("gui.message.mace_updated"));
                onlinePlayer.playSound(onlinePlayer.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.7f, 1.5f);
            }
        }
        return updatedCount;
    }

    private void handleConfirmationGUIClick(InventoryClickEvent event, Player player, PlayerSession session) {
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        String actionKey = session.confirmAction;
        if (actionKey == null) {
            this.open(player);
            return;
        }
        if (clickedItem.getType() == Material.LIME_WOOL) {
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 1.5f);
            switch (actionKey) {
                case "toggle_whitelist": {
                    this.toggleBoolean(player, "whitelist.enabled", this.plugin.getMessage("gui.main.whitelist.title"));
                    this.open(player);
                    break;
                }
                case "edit_webhook": {
                    this.promptForInput(player, "edit_webhook", this.plugin.getMessage("gui.prompt.webhook"));
                    break;
                }
                default: {
                    player.sendMessage(this.plugin.getMessage("unknown_action", Map.of("action", actionKey)));
                    this.open(player);
                    break;
                }
            }
        } else if (clickedItem.getType() == Material.RED_WOOL) {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, 0.8f);
            player.sendMessage(this.plugin.getMessage("gui.message.operation_cancelled"));
            this.open(player);
        }
        session.confirmAction = null;
    }

    private void cycleDisplayMode(Player player) {
        List<String> modes = Arrays.asList("chat", "actionbar", "title");
        String currentMode = this.plugin.getConfig().getString("message_display_mode", "chat");
        int currentIndex = modes.indexOf(currentMode);
        String newMode = modes.get((currentIndex + 1) % modes.size());
        this.plugin.getConfig().set("message_display_mode", (Object)newMode);
        this.plugin.saveConfig();
        player.sendMessage(this.plugin.getMessage("gui.message.display_mode_changed", Map.of("mode", newMode)));
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.7f, 1.3f);
        switch (newMode) {
            case "actionbar": {
                player.sendActionBar(this.plugin.getMessage("gui.message.example_actionbar"));
                break;
            }
            case "title": {
                player.sendTitle(this.plugin.getMessage("gui.message.example_title_main"), this.plugin.getMessage("gui.message.example_title_sub"), 10, 40, 10);
                break;
            }
            case "chat": {
                player.sendMessage(this.plugin.getMessage("gui.message.example_chat"));
            }
        }
    }

    private void openConfirmationGUI(Player player, String actionKey, String actionName) {
        PlayerSession session = this.getOrCreateSession(player.getUniqueId());
        session.confirmAction = actionKey;
        Inventory gui = Bukkit.createInventory(null, (int)27, (String)this.getConfirmGuiTitle());
        gui.setItem(13, this.createGuiItem(Material.PAPER, this.plugin.getMessage("gui.confirm.title"), this.plugin.getMessage("gui.confirm.action", Map.of("action", actionName)), "", this.plugin.getMessage("gui.confirm.question"), this.plugin.getMessage("gui.confirm.warning"), "", this.plugin.getMessage("gui.confirm.choose")));
        gui.setItem(11, this.createGuiItem(Material.LIME_WOOL, this.plugin.getMessage("gui.confirm.button_yes_title"), this.plugin.getMessage("gui.confirm.button_yes_lore", Map.of("action", actionName))));
        gui.setItem(15, this.createGuiItem(Material.RED_WOOL, this.plugin.getMessage("gui.confirm.button_no_title"), this.plugin.getMessage("gui.confirm.button_no_lore")));
        this.fillConfirmationBorders(gui);
        player.openInventory(gui);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.8f, 1.2f);
    }

    private void fillConfirmationBorders(Inventory gui) {
        ItemStack borderItem = this.createGuiItem(Material.YELLOW_STAINED_GLASS_PANE, "\u00a78", new String[0]);
        for (int i = 0; i < 9; ++i) {
            gui.setItem(i, borderItem);
            gui.setItem(i + 18, borderItem);
        }
        gui.setItem(9, borderItem);
        gui.setItem(17, borderItem);
    }

    private void toggleBoolean(Player player, String configPath, String settingName) {
        String webhookUrl;
        boolean currentValue = this.plugin.getConfig().getBoolean(configPath);
        boolean newValue = !currentValue;
        this.plugin.getConfig().set(configPath, (Object)newValue);
        this.plugin.saveConfig();
        String status = newValue ? this.plugin.getMessage("gui.status.enabled") : this.plugin.getMessage("gui.status.disabled");
        player.sendMessage(this.plugin.getMessage("gui.message.setting_toggled", Map.of("setting", settingName, "status", status)));
        player.playSound(player.getLocation(), newValue ? Sound.ENTITY_EXPERIENCE_ORB_PICKUP : Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, newValue ? 1.5f : 0.8f);
        if (configPath.equals("logging.discord.enabled") && newValue && (webhookUrl = this.plugin.getConfig().getString("logging.discord.webhook_url", "")).isEmpty()) {
            player.sendMessage(this.plugin.getMessage("gui.message.webhook_not_set_warning"));
        }
    }

    private void openParticleMenu(Player player, PlayerSession session, int page) {
        session.particlePage = Math.max(0, Math.min(page, (this.particleList.size() - 1) / 36));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)this.getParticleGuiTitle());
        int itemsPerPage = 36;
        int startIndex = session.particlePage * itemsPerPage;
        this.fillSelectionBorders(gui);
        int slot = 9;
        for (int i = 0; i < itemsPerPage && startIndex + i < this.particleList.size(); ++i) {
            Particle particle = this.particleList.get(startIndex + i);
            NamespacedKey particleKey = Registry.PARTICLE_TYPE.getKey((Keyed)particle);
            if (particleKey == null) continue;
            String particleName = particleKey.value();
            String currentParticle = this.plugin.getConfig().getString("teleport_effect.particle", "portal");
            boolean isSelected = particleName.equals(currentParticle);
            gui.setItem(slot++, this.createGuiItem(isSelected ? Material.GLOWSTONE : Material.GLOWSTONE_DUST, (isSelected ? "\u00a7a\u00a7l\u2713 " : "\u00a7d") + "\u2728 " + particleName, isSelected ? this.plugin.getMessage("gui.selection.currently_selected") : this.plugin.getMessage("gui.selection.click_to_select"), this.plugin.getMessage("gui.main.lore.right_click_preview")));
        }
        this.addNavigationButtons(gui, session.particlePage, this.particleList.size(), itemsPerPage);
        player.openInventory(gui);
    }

    private void openSoundMenu(Player player, PlayerSession session, int page) {
        session.soundPage = Math.max(0, Math.min(page, (this.soundList.size() - 1) / 36));
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)this.getSoundGuiTitle());
        int itemsPerPage = 36;
        int startIndex = session.soundPage * itemsPerPage;
        this.fillSelectionBorders(gui);
        int slot = 9;
        for (int i = 0; i < itemsPerPage && startIndex + i < this.soundList.size(); ++i) {
            Sound sound = this.soundList.get(startIndex + i);
            NamespacedKey soundKey = Registry.SOUNDS.getKey((Keyed)sound);
            if (soundKey == null) continue;
            String soundName = soundKey.value();
            String currentSound = this.plugin.getConfig().getString("teleport_sound", "entity.enderman.teleport");
            boolean isSelected = soundName.equals(currentSound);
            gui.setItem(slot++, this.createGuiItem(isSelected ? Material.JUKEBOX : Material.NOTE_BLOCK, (isSelected ? "\u00a7a\u00a7l\u2713 " : "\u00a7b") + "\ud83d\udd0a " + soundName, isSelected ? this.plugin.getMessage("gui.selection.currently_selected") : this.plugin.getMessage("gui.selection.click_to_select"), this.plugin.getMessage("gui.main.lore.right_click_preview")));
        }
        this.addNavigationButtons(gui, session.soundPage, this.soundList.size(), itemsPerPage);
        player.openInventory(gui);
    }

    private void addNavigationButtons(Inventory gui, int page, int totalItems, int itemsPerPage) {
        int maxPages = (int)Math.ceil((double)totalItems / (double)itemsPerPage);
        if (page > 0) {
            gui.setItem(45, this.createGuiItem(Material.ARROW, this.plugin.getMessage("gui.selection.page_prev"), new String[0]));
        }
        if ((page + 1) * itemsPerPage < totalItems) {
            gui.setItem(53, this.createGuiItem(Material.ARROW, this.plugin.getMessage("gui.selection.page_next"), new String[0]));
        }
        gui.setItem(49, this.createGuiItem(Material.PAPER, this.plugin.getMessage("gui.selection.page_info_title"), this.plugin.getMessage("gui.selection.page_info_current", Map.of("current", String.valueOf(page + 1))), this.plugin.getMessage("gui.selection.page_info_total", Map.of("total", String.valueOf(maxPages))), this.plugin.getMessage("gui.selection.page_info_items", Map.of("items", String.valueOf(totalItems)))));
        gui.setItem(46, this.createGuiItem(Material.BARRIER, this.plugin.getMessage("gui.selection.back_button"), new String[0]));
    }

    private void promptForInput(Player player, String key, String prompt) {
        this.playerInputMap.put(player.getUniqueId(), key);
        player.closeInventory();
        String border = "\u00a78" + "=".repeat(50);
        player.sendMessage(border);
        player.sendMessage(prompt);
        player.sendMessage(border);
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 0.8f, 1.2f);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.playerInputMap.containsKey(uuid)) {
            return;
        }
        event.setCancelled(true);
        String input = event.getMessage().trim();
        String settingKey = this.playerInputMap.remove(uuid);
        if (input.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.plugin.getMessage("gui.message.operation_cancelled"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, 0.8f);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.open(player));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if ("edit_webhook".equals(settingKey)) {
                this.handleWebhookInput(player, input);
            } else {
                player.sendMessage(this.plugin.getMessage("unknown_input_type", Map.of("type", settingKey)));
            }
            this.open(player);
        });
    }

    private void handleWebhookInput(Player player, String input) {
        if (input.startsWith("https://discord.com/api/webhooks/") || input.startsWith("https://discordapp.com/api/webhooks/")) {
            if (input.split("/").length >= 7) {
                this.plugin.getConfig().set("logging.discord.webhook_url", (Object)input);
                this.plugin.saveConfig();
                if (this.plugin.getLoggerService() != null) {
                    this.plugin.getLoggerService().reloadWebhook();
                }
                player.sendMessage(this.plugin.getMessage("gui.message.webhook_success"));
                player.sendMessage(this.plugin.getMessage("gui.message.webhook_url_display", Map.of("url", input.length() > 50 ? input.substring(0, 50) + "..." : input)));
                player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.8f, 1.5f);
            } else {
                player.sendMessage(this.plugin.getMessage("gui.message.webhook_invalid_format"));
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, 0.8f);
            }
        } else {
            player.sendMessage(this.plugin.getMessage("gui.message.webhook_invalid_url"));
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 0.8f, 0.8f);
        }
    }

    private String formatMaterialName(Material material) {
        NamespacedKey key = Registry.MATERIAL.getKey((Keyed)material);
        if (key == null) {
            return "Unknown Material";
        }
        String[] words = key.value().replace("minecraft:", "").replace("_", " ").split(" ");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            builder.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1).toLowerCase()).append(" ");
        }
        return builder.toString().trim();
    }

    private String formatEnumName(String enumName) {
        return enumName.toLowerCase(Locale.ROOT).replace("_", " ").replace(".", " ");
    }

    private static class PlayerSession {
        private int particlePage = 0;
        private int soundPage = 0;
        private int itemPage = 0;
        private String confirmAction = null;

        private PlayerSession() {
        }
    }
}

