/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.nakolotnik.banMace.BanMace;

public class UpdateChecker
implements Listener {
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/ban-mace/version";
    private final BanMace plugin;
    private String latestVersion;
    private boolean updateAvailable = false;
    private String updateMessage;
    private boolean alreadyLogged = false;

    public UpdateChecker(BanMace plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.checkForUpdates();
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                String line;
                HttpURLConnection connection = (HttpURLConnection)new URL(MODRINTH_API_URL).openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "BanMace Plugin Update Checker/" + this.plugin.getDescription().getVersion());
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                connection.disconnect();
                this.latestVersion = this.parseLatestVersion(response.toString());
                String currentVersion = this.plugin.getDescription().getVersion();
                if (this.latestVersion != null && this.isNewerVersion(this.latestVersion, currentVersion)) {
                    this.updateAvailable = true;
                    this.updateMessage = "\u00a76[BanMace] A new version is available: \u00a7e" + this.latestVersion + "\u00a76. You are on \u00a7c" + currentVersion + "\u00a76. Download it here: https://modrinth.com/plugin/ban-mace";
                    if (!this.alreadyLogged) {
                        this.plugin.getLogger().warning(this.updateMessage);
                        this.alreadyLogged = true;
                    }
                } else {
                    this.plugin.getLogger().info("You are using the latest version of BanMace (" + currentVersion + ").");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private String parseLatestVersion(String jsonResponse) {
        try {
            Pattern pattern = Pattern.compile("\"version_number\"\\s*:\\s*\"([^\"]+)\"");
            Matcher matcher = pattern.matcher(jsonResponse);
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to parse version response: " + e.getMessage());
        }
        return null;
    }

    private boolean isNewerVersion(String latestVersionStr, String currentVersionStr) {
        latestVersionStr = latestVersionStr.replaceAll("[^0-9.]", "");
        currentVersionStr = currentVersionStr.replaceAll("[^0-9.]", "");
        String[] latestParts = latestVersionStr.split("\\.");
        String[] currentParts = currentVersionStr.split("\\.");
        int maxLength = Math.max(latestParts.length, currentParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int currentPart;
            int latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
            int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
            if (latestPart > currentPart) {
                return true;
            }
            if (latestPart >= currentPart) continue;
            return false;
        }
        return false;
    }

    @EventHandler
    public void onAdminJoin(PlayerJoinEvent event) {
        if (!this.updateAvailable || !this.plugin.getConfig().getBoolean("update_notify_in_game", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isOp() || player.hasPermission("banmace.update.notify")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.isOnline()) {
                    player.sendMessage(this.updateMessage);
                }
            }, 40L);
        }
    }
}

