/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils.mods;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;
import org.nakolotnik.banMace.BanMace;
import org.nakolotnik.banMace.ModeHandler;

public class BalloonMod
implements ModeHandler,
Listener {
    private final Map<UUID, List<Entity>> activeBalloons = new ConcurrentHashMap<UUID, List<Entity>>();
    private final Map<UUID, BukkitTask> balloonUpdaters = new ConcurrentHashMap<UUID, BukkitTask>();
    private final Map<Entity, Double> balloonRandomYOffsets = new ConcurrentHashMap<Entity, Double>();
    private final Map<Entity, Boolean> balloonSizes = new ConcurrentHashMap<Entity, Boolean>();
    private final Set<UUID> protectedEntities = ConcurrentHashMap.newKeySet();

    @Override
    public String getModeName() {
        return "Balloon";
    }

    @Override
    public void execute(Player damager, final Player target) {
        BanMace plugin = BanMace.getInstance();
        if (this.activeBalloons.containsKey(target.getUniqueId())) {
            damager.sendMessage("\u00a7cThis player is already flying on balloons.");
            return;
        }
        int levitationDuration = 100;
        int levitationAmplifier = 4;
        int slowFallDuration = 300;
        target.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, levitationDuration, levitationAmplifier));
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, levitationDuration + slowFallDuration, 0, false, false), true);
        this.attachVisualBalloons(target);
        new BukkitRunnable(){

            public void run() {
                BalloonMod.this.removeVisualBalloons(target.getUniqueId());
            }
        }.runTaskLater((Plugin)plugin, (long)(levitationDuration + slowFallDuration));
        damager.sendMessage(plugin.getMessage("balloon_applied", Map.of("target", target.getName())));
        target.sendMessage(plugin.getMessage("balloon_received"));
        String actionDetails = "Launched into the air for " + levitationDuration / 20 + " seconds.";
        plugin.getLoggerService().logMaceAction(damager, target, this.getModeName(), actionDetails);
    }

    private void attachVisualBalloons(final Player target) {
        ArrayList<Object> balloonEntities = new ArrayList<Object>();
        final UUID targetId = target.getUniqueId();
        BanMace plugin = BanMace.getInstance();
        Material[] colors = new Material[]{Material.RED_WOOL, Material.YELLOW_WOOL, Material.BLUE_WOOL};
        Random random = new Random();
        for (Material color : colors) {
            boolean isSmall = random.nextBoolean();
            Parrot parrot = (Parrot)target.getWorld().spawn(target.getLocation().add(0.0, 3.0, 0.0), Parrot.class, p -> {
                p.setInvisible(true);
                p.setSilent(true);
                p.setInvulnerable(true);
                p.setLeashHolder((Entity)target);
                p.setAgeLock(true);
                p.setAI(false);
                p.setGravity(false);
                p.setCollidable(false);
                p.setRemoveWhenFarAway(false);
            });
            this.protectedEntities.add(parrot.getUniqueId());
            double randomYOffset = 2.0 + random.nextDouble() * 1.5;
            this.balloonRandomYOffsets.put((Entity)parrot, randomYOffset);
            this.balloonSizes.put((Entity)parrot, isSmall);
            double armorStandOffset = isSmall ? -0.75 : -1.3;
            ArmorStand as = (ArmorStand)target.getWorld().spawn(parrot.getLocation().add(0.0, armorStandOffset, 0.0), ArmorStand.class, a -> {
                a.setInvisible(true);
                a.setGravity(false);
                a.setMarker(true);
                a.setInvulnerable(true);
                a.getEquipment().setHelmet(new ItemStack(color));
                a.setSmall(isSmall);
                a.setCollidable(false);
                a.setRemoveWhenFarAway(false);
            });
            this.protectedEntities.add(as.getUniqueId());
            balloonEntities.add(parrot);
            balloonEntities.add(as);
        }
        this.activeBalloons.put(targetId, balloonEntities);
        BukkitTask updaterTask = new BukkitRunnable(){

            public void run() {
                if (!target.isOnline() || !BalloonMod.this.activeBalloons.containsKey(targetId)) {
                    BalloonMod.this.removeVisualBalloons(targetId);
                    this.cancel();
                    return;
                }
                List<Entity> entities = BalloonMod.this.activeBalloons.get(targetId);
                Location targetHeadLocation = target.getEyeLocation();
                for (int i = 0; i < entities.size(); i += 2) {
                    Parrot parrot = (Parrot)entities.get(i);
                    ArmorStand as = (ArmorStand)entities.get(i + 1);
                    if (!parrot.isValid() || !as.isValid()) {
                        BalloonMod.this.removeVisualBalloons(targetId);
                        this.cancel();
                        return;
                    }
                    if (!parrot.isLeashed() || parrot.getLeashHolder() != target) {
                        parrot.setLeashHolder((Entity)target);
                    }
                    Vector playerDirection = target.getLocation().getDirection().setY(0).normalize();
                    Vector sideDirection = playerDirection.clone().crossProduct(new Vector(0, 1, 0));
                    double angle = Math.PI * 2 / ((double)entities.size() / 2.0) * ((double)i / 2.0) + (double)System.currentTimeMillis() / 2000.0;
                    double radius = 1.3;
                    double sideOffset = Math.cos(angle) * radius;
                    double fwdOffset = Math.sin(angle) * radius;
                    Vector finalOffset = sideDirection.multiply(sideOffset).add(playerDirection.multiply(fwdOffset));
                    double baseOffsetY = BalloonMod.this.balloonRandomYOffsets.getOrDefault(parrot, 2.5);
                    double bobbing = Math.sin((double)System.currentTimeMillis() / 400.0 + (double)(i * 2)) * 0.2;
                    double finalOffsetY = baseOffsetY + bobbing;
                    Location balloonTargetPos = targetHeadLocation.clone().add(finalOffset).add(0.0, finalOffsetY, 0.0);
                    parrot.teleport(balloonTargetPos);
                    boolean isSmall = BalloonMod.this.balloonSizes.getOrDefault(parrot, false);
                    double armorStandOffset = isSmall ? -0.75 : -1.3;
                    as.teleport(parrot.getLocation().add(0.0, armorStandOffset, 0.0));
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, 1L);
        this.balloonUpdaters.put(targetId, updaterTask);
    }

    private void removeVisualBalloons(UUID targetId) {
        List<Entity> entities;
        BukkitTask updater = this.balloonUpdaters.remove(targetId);
        if (updater != null) {
            updater.cancel();
        }
        if ((entities = this.activeBalloons.remove(targetId)) != null) {
            for (Entity entity : entities) {
                Parrot parrot;
                this.balloonRandomYOffsets.remove(entity);
                this.balloonSizes.remove(entity);
                this.protectedEntities.remove(entity.getUniqueId());
                if (!entity.isValid()) continue;
                if (entity instanceof Parrot && (parrot = (Parrot)entity).isLeashed()) {
                    parrot.setLeashHolder(null);
                }
                entity.remove();
            }
        }
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity;
        block6: {
            block5: {
                entity = event.getDamager();
                if (!(entity instanceof Player)) break block5;
                damager = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof Player) break block6;
            }
            return;
        }
        Player target = (Player)entity;
        if (BanMace.isHoldingBanMace(damager) && BanMace.getCurrentMode() instanceof BalloonMod) {
            event.setCancelled(true);
            if (target.hasPermission("banmace.bypass")) {
                damager.sendMessage(BanMace.getInstance().getMessage("cannot_use_on_player", Map.of("player", target.getName())));
                return;
            }
            this.execute(damager, target);
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        if (this.protectedEntities.contains(event.getEntity().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.removeVisualBalloons(event.getPlayer().getUniqueId());
    }

    public void cleanup() {
        for (UUID playerId : new HashSet<UUID>(this.activeBalloons.keySet())) {
            this.removeVisualBalloons(playerId);
        }
        this.activeBalloons.clear();
        this.balloonUpdaters.clear();
        this.balloonRandomYOffsets.clear();
        this.balloonSizes.clear();
        this.protectedEntities.clear();
    }
}

