/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils.mods;

import java.util.Date;
import java.util.Map;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.nakolotnik.banMace.BanMace;
import org.nakolotnik.banMace.ModeHandler;

public class BanMode
implements ModeHandler,
Listener {
    @Override
    public void execute(Player damager, Player target) {
        BanMace plugin = BanMace.getInstance();
        String defaultDuration = plugin.getConfig().getString("ban_mode.default_duration", "1h");
        long banDurationSeconds = this.parseDuration(defaultDuration);
        String targetName = target.getName();
        String damagerName = damager.getName();
        String formattedDuration = this.formatDuration(banDurationSeconds);
        Date expiryDate = banDurationSeconds > 0L ? new Date(System.currentTimeMillis() + banDurationSeconds * 1000L) : null;
        Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(targetName, plugin.getMessage("ban_reason"), expiryDate, damagerName);
        target.kickPlayer(plugin.getMessage("banned_message", Map.of("duration", formattedDuration)));
        damager.sendMessage(plugin.getMessage("ban_applied", Map.of("player", targetName, "duration", formattedDuration)));
        String actionDetails = "Duration: " + formattedDuration;
        plugin.getLoggerService().logMaceAction(damager, target, this.getModeName(), actionDetails);
    }

    @Override
    public String getModeName() {
        return "Ban";
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity;
        block6: {
            block5: {
                entity = event.getDamager();
                if (!(entity instanceof Player)) break block5;
                damager = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof Player) break block6;
            }
            return;
        }
        Player target = (Player)entity;
        if (BanMace.isHoldingBanMace(damager) && BanMace.getCurrentMode() instanceof BanMode) {
            if (target.hasPermission("banmace.bypass")) {
                damager.sendMessage(BanMace.getInstance().getMessage("cannot_use_on_player", Map.of("player", target.getName())));
                return;
            }
            this.execute(damager, target);
            event.setCancelled(true);
        }
    }

    private long parseDuration(String duration) {
        if (duration == null || duration.isEmpty()) {
            return 3600L;
        }
        if (duration.equalsIgnoreCase("permanent") || duration.equalsIgnoreCase("perm")) {
            return -1L;
        }
        try {
            long value = Long.parseLong(duration.substring(0, duration.length() - 1));
            char unit = duration.toLowerCase().charAt(duration.length() - 1);
            return switch (unit) {
                case 's' -> value;
                case 'm' -> value * 60L;
                case 'h' -> value * 3600L;
                case 'd' -> value * 86400L;
                case 'w' -> value * 604800L;
                case 'y' -> value * 31536000L;
                default -> 3600L;
            };
        }
        catch (Exception e) {
            BanMace.getInstance().getLogger().warning("[BanMace] Invalid duration format in config: '" + duration + "'. Defaulting to 1 hour.");
            return 3600L;
        }
    }

    private String formatDuration(long seconds) {
        if (seconds <= 0L) {
            return "Permanent";
        }
        long years = seconds / 31536000L;
        long weeks = (seconds %= 31536000L) / 604800L;
        long days = (seconds %= 604800L) / 86400L;
        long hours = (seconds %= 86400L) / 3600L;
        long minutes = (seconds %= 3600L) / 60L;
        long remainingSeconds = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(years).append(" year(s) ");
        }
        if (weeks > 0L) {
            sb.append(weeks).append(" week(s) ");
        }
        if (days > 0L) {
            sb.append(days).append(" day(s) ");
        }
        if (hours > 0L) {
            sb.append(hours).append(" hour(s) ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append(" minute(s) ");
        }
        if (remainingSeconds > 0L) {
            sb.append(remainingSeconds).append(" second(s) ");
        }
        return sb.toString().trim();
    }
}

