/*
 * Decompiled with CFR 0.152.
 */
package org.nakolotnik.banMace.utils.mods;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.joml.AxisAngle4f;
import org.joml.Vector3f;
import org.nakolotnik.banMace.BanMace;
import org.nakolotnik.banMace.ModeHandler;

public class FreezeMode
implements ModeHandler,
Listener {
    private final Map<UUID, Set<BlockDisplay>> frozenPlayerIceBlocks = new ConcurrentHashMap<UUID, Set<BlockDisplay>>();
    private final Map<UUID, BukkitRunnable> frozenPlayerTasks = new ConcurrentHashMap<UUID, BukkitRunnable>();
    private final int freezeDuration = 20;

    @Override
    public void execute(Player damager, Player target) {
        BanMace plugin = BanMace.getInstance();
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 400, 9));
        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 400, 0));
        this.createIceEffect(target);
        damager.sendMessage(plugin.getMessage("freeze_applied", Map.of("target", target.getName())));
        target.sendMessage(plugin.getMessage("freeze_received"));
        String actionDetails = "Duration: 20 seconds.";
        plugin.getLoggerService().logMaceAction(damager, target, this.getModeName(), actionDetails);
        this.scheduleIceRemoval(target);
    }

    private void createIceEffect(Player player) {
        UUID playerId = player.getUniqueId();
        this.removeIceEffect(playerId);
        Location playerLoc = player.getLocation();
        HashSet<BlockDisplay> iceBlocks = new HashSet<BlockDisplay>();
        double radius = 2.0;
        int blockCount = 16;
        for (int i = 0; i < blockCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)blockCount;
            double x = playerLoc.getX() + Math.cos(angle) * radius;
            double y = playerLoc.getY() - 0.5;
            double z = playerLoc.getZ() + Math.sin(angle) * radius;
            iceBlocks.add(this.createIceBlock(new Location(player.getWorld(), x, y, z), i));
        }
        iceBlocks.add(this.createCenterIceBlock(playerLoc.clone().add(0.0, -0.3, 0.0)));
        this.createDecorativeIce(player, iceBlocks);
        this.frozenPlayerIceBlocks.put(playerId, iceBlocks);
        player.getWorld().playSound(playerLoc, Sound.BLOCK_GLASS_BREAK, 1.0f, 0.5f);
        player.getWorld().playSound(playerLoc, Sound.ENTITY_PLAYER_HURT_FREEZE, 1.0f, 1.0f);
        this.spawnFreezeParticles(player);
    }

    private BlockDisplay createIceBlock(Location loc, int index) {
        BlockDisplay display = (BlockDisplay)loc.getWorld().spawn(loc, BlockDisplay.class);
        display.setBlock(Material.ICE.createBlockData());
        float scale = 0.8f + (float)(index % 3) * 0.2f;
        float rotationY = (float)Math.toRadians((double)index * 22.5);
        Transformation transformation = new Transformation(new Vector3f(), new AxisAngle4f(rotationY, 0.0f, 1.0f, 0.0f), new Vector3f(scale, 0.3f, scale), new AxisAngle4f());
        display.setTransformation(transformation);
        display.setInterpolationDuration(10);
        display.setBrightness(new Display.Brightness(15, 15));
        return display;
    }

    private BlockDisplay createCenterIceBlock(Location loc) {
        BlockDisplay display = (BlockDisplay)loc.getWorld().spawn(loc, BlockDisplay.class);
        display.setBlock(Material.PACKED_ICE.createBlockData());
        Transformation transformation = new Transformation(new Vector3f(), new AxisAngle4f(), new Vector3f(1.5f, 0.2f, 1.5f), new AxisAngle4f());
        display.setTransformation(transformation);
        display.setInterpolationDuration(15);
        display.setBrightness(new Display.Brightness(15, 15));
        return display;
    }

    private void createDecorativeIce(Player player, Set<BlockDisplay> iceBlocks) {
        Location playerLoc = player.getLocation();
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            double angle = random.nextDouble() * 2.0 * Math.PI;
            double distance = 1.0 + random.nextDouble() * 1.5;
            double height = random.nextDouble() * 0.5;
            Location crystalLoc = new Location(player.getWorld(), playerLoc.getX() + Math.cos(angle) * distance, playerLoc.getY() + height, playerLoc.getZ() + Math.sin(angle) * distance);
            BlockDisplay crystal = (BlockDisplay)crystalLoc.getWorld().spawn(crystalLoc, BlockDisplay.class);
            crystal.setBlock(Material.BLUE_ICE.createBlockData());
            float crystalScale = 0.3f + random.nextFloat() * 0.4f;
            Transformation transformation = new Transformation(new Vector3f(), new AxisAngle4f((float)Math.toRadians(random.nextInt(360)), 0.0f, 1.0f, 0.0f), new Vector3f(crystalScale, crystalScale * 2.0f, crystalScale), new AxisAngle4f());
            crystal.setTransformation(transformation);
            crystal.setInterpolationDelay(5 + i * 2);
            crystal.setInterpolationDuration(20);
            crystal.setBrightness(new Display.Brightness(15, 15));
            iceBlocks.add(crystal);
        }
    }

    private void spawnFreezeParticles(final Player player) {
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                if (this.ticks > 60 || !FreezeMode.this.frozenPlayerIceBlocks.containsKey(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                player.getWorld().spawnParticle(Particle.SNOWFLAKE, player.getLocation().add(0.0, 1.0, 0.0), 5, 0.5, 0.5, 0.5, 0.0);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)BanMace.getInstance(), 0L, 5L);
    }

    private void scheduleIceRemoval(Player player) {
        final UUID playerId = player.getUniqueId();
        if (this.frozenPlayerTasks.containsKey(playerId)) {
            this.frozenPlayerTasks.get(playerId).cancel();
        }
        BukkitRunnable task = new BukkitRunnable(){

            public void run() {
                FreezeMode.this.removeIceEffect(playerId);
                FreezeMode.this.frozenPlayerTasks.remove(playerId);
            }
        };
        this.frozenPlayerTasks.put(playerId, task);
        task.runTaskLater((Plugin)BanMace.getInstance(), 400L);
    }

    private void removeIceEffect(UUID playerId) {
        Set<BlockDisplay> iceBlocks = this.frozenPlayerIceBlocks.remove(playerId);
        if (iceBlocks != null) {
            for (final BlockDisplay block : iceBlocks) {
                if (block == null || block.isDead()) continue;
                Transformation shrink = new Transformation(block.getTransformation().getTranslation(), block.getTransformation().getLeftRotation(), new Vector3f(0.1f), block.getTransformation().getRightRotation());
                block.setInterpolationDuration(20);
                block.setTransformation(shrink);
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_GLASS_BREAK, 1.0f, 1.5f);
                new BukkitRunnable(this){

                    public void run() {
                        if (!block.isDead()) {
                            block.remove();
                        }
                    }
                }.runTaskLater((Plugin)BanMace.getInstance(), 20L);
            }
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.frozenPlayerIceBlocks.containsKey(event.getPlayer().getUniqueId()) && event.hasChangedPosition()) {
            event.setCancelled(true);
        }
    }

    @Override
    public String getModeName() {
        return "Freeze";
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        Player damager;
        Entity entity;
        block6: {
            block5: {
                entity = event.getDamager();
                if (!(entity instanceof Player)) break block5;
                damager = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof Player) break block6;
            }
            return;
        }
        Player target = (Player)entity;
        if (BanMace.isHoldingBanMace(damager) && BanMace.getCurrentMode() instanceof FreezeMode) {
            if (target.hasPermission("banmace.bypass")) {
                damager.sendMessage(BanMace.getInstance().getMessage("cannot_use_on_player", Map.of("player", target.getName())));
                return;
            }
            this.execute(damager, target);
            event.setCancelled(true);
        }
    }

    public void removeAllIceEffects() {
        for (UUID playerId : this.frozenPlayerIceBlocks.keySet()) {
            this.removeIceEffect(playerId);
        }
        this.frozenPlayerTasks.values().forEach(BukkitRunnable::cancel);
        this.frozenPlayerTasks.clear();
    }
}

