/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.StartupConfigs;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.component.prefix.ModPrefix;
import org.confluence.mod.common.data.fixer.RegistriesFixer;
import org.confluence.mod.common.init.ModAdvancements;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.common.init.ModCarvers;
import org.confluence.mod.common.init.ModChunkGenerators;
import org.confluence.mod.common.init.ModCommands;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModEnchantments;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModEquipmentSets;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.ModHookTypes;
import org.confluence.mod.common.init.ModLootTables;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModParticleTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.ModTabs;
import org.confluence.mod.common.init.ModVillagers;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.integration.heaven_destiny_moment.HDMEvents;
import org.confluence.mod.integration.terra_entity.TEEvents;
import org.confluence.mod.integration.terra_entity.init.ModTradeLockProviderTypes;
import org.confluence.mod.integration.waystones.WaystonesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="confluence")
public final class Confluence {
    public static final String MODID = "confluence";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Confluence");
    public static GameRules.Key<GameRules.IntegerValue> SPREADABLE_CHANCE;

    public Confluence(IEventBus eventBus, ModContainer container) {
        StartupConfigs.register(container);
        CommonConfigs.register(container);
        if (LibUtils.isPhysicalClient()) {
            ClientConfigs.register(container);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        TEEvents.register(eventBus);
        HDMEvents.register(eventBus);
        ModBlocks.register(eventBus);
        ModItems.register(eventBus);
        ModVillagers.register(eventBus);
        ModRecipes.register(eventBus);
        ModFeatures.register(eventBus);
        ModEnchantments.register(eventBus);
        WaystonesHelper.register(eventBus);
        ModAdvancements.register(eventBus);
        ModFluids.initialize();
        ModPrefix.initialize();
        RegistriesFixer.initialize();
        ModTabs.TABS.register(eventBus);
        ModEntities.ENTITIES.register(eventBus);
        ModDataComponentTypes.TYPES.register(eventBus);
        ModSoundEvents.EVENTS.register(eventBus);
        ModAttachmentTypes.TYPES.register(eventBus);
        ModEffects.EFFECTS.register(eventBus);
        ModMenuTypes.TYPES.register(eventBus);
        ModParticleTypes.TYPES.register(eventBus);
        ModChunkGenerators.GENERATORS.register(eventBus);
        ModCarvers.CARVERS.register(eventBus);
        ModStructures.TYPES.register(eventBus);
        ModEquipmentSets.SETS.register(eventBus);
        ModHookTypes.TYPES.register(eventBus);
        ModLootTables.ItemConditions.TYPES.register(eventBus);
        ModTradeLockProviderTypes.TYPES.register(eventBus);
        ModCommands.ARGUMENT_TYPE_INFOS.register(eventBus);
    }

    public static void registerGameRules() {
        if (SPREADABLE_CHANCE == null) {
            SPREADABLE_CHANCE = GameRules.register((String)"confluenceSpreadableChance", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.IntegerValue.create((int)10, (int)0, (int)100, (server, value) -> {}));
        }
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    public static String asPlainId(String path) {
        return "confluence:" + path;
    }

    public static <T> ResourceKey<T> asResourceKey(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return ResourceKey.create(registryKey, (ResourceLocation)Confluence.asResource(path));
    }

    public static <T> ResourceKey<Registry<T>> asResourceKey(String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)Confluence.asResource(path));
    }

    public static <T> TagKey<T> asTagKey(ResourceKey<Registry<T>> registryKey, String path) {
        return TagKey.create(registryKey, (ResourceLocation)Confluence.asResource(path));
    }
}

