/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.mod.client.gui.hud.TerraStyleArmorHud;
import org.confluence.mod.client.gui.hud.TerraStyleFoodHud;
import org.confluence.mod.client.gui.hud.TerraStyleHealthHud;
import org.confluence.mod.client.gui.hud.TerraStyleManaHud;
import org.confluence.mod.client.handler.StarPhaseHandler;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.terraentity.client.gui.container.TETradeScreen;
import org.jetbrains.annotations.NotNull;

public final class ClientConfigs {
    public static int showWindParticles = 90;
    public static boolean achievementToast = true;
    public static SellPriceDisplay sellPriceDisplay = SellPriceDisplay.EVERYWHERE;
    public static boolean terraStyleHealth = true;
    public static TerraStyleHealthHud.Health healthStyle = TerraStyleHealthHud.Health.OVERLAY;
    public static int healthOffsetX = 0;
    public static int healthOffsetY = 0;
    public static boolean terraStyleFood = true;
    public static TerraStyleFoodHud.Food foodStyle = TerraStyleFoodHud.Food.OVERLAY;
    public static TerraStyleManaHud.Mana manaStyle = TerraStyleManaHud.Mana.OVERLAY;
    public static int manaOffsetX = 0;
    public static int manaOffsetY = 0;
    public static boolean terraStyleArmor = true;
    public static TerraStyleArmorHud.Armor armorStyle = TerraStyleArmorHud.Armor.OVERLAY;
    public static boolean leftEffectIcon = true;
    public static int extraInventoryButtonOffsetX = 0;
    public static int extraInventoryButtonOffsetY = 0;
    public static boolean bloodyEffect = true;
    public static GoreEffect goreEffect = GoreEffect.CONFLUENCE_VANILLA;
    public static boolean damageIndicator = true;
    public static boolean healIndicator = true;
    private static ModConfigSpec.IntValue SHOW_WIND_PARTICLES;
    private static ModConfigSpec.BooleanValue ACHIEVEMENT_TOAST;
    private static ModConfigSpec.EnumValue<SellPriceDisplay> SELL_PRICE_DISPLAY;
    private static ModConfigSpec.BooleanValue TERRA_STYLE_HEALTH;
    private static ModConfigSpec.EnumValue<TerraStyleHealthHud.Health> HEALTH_STYLE;
    private static ModConfigSpec.IntValue HEALTH_OFFSET_X;
    private static ModConfigSpec.IntValue HEALTH_OFFSET_Y;
    private static ModConfigSpec.BooleanValue TERRA_STYLE_FOOD;
    private static ModConfigSpec.EnumValue<TerraStyleFoodHud.Food> FOOD_STYLE;
    private static ModConfigSpec.EnumValue<TerraStyleManaHud.Mana> MANA_STYLE;
    private static ModConfigSpec.IntValue MANA_OFFSET_X;
    private static ModConfigSpec.IntValue MANA_OFFSET_Y;
    private static ModConfigSpec.BooleanValue TERRA_STYLE_ARMOR;
    private static ModConfigSpec.EnumValue<TerraStyleArmorHud.Armor> ARMOR_STYLE;
    private static ModConfigSpec.BooleanValue LEFT_EFFECT_ICON;
    private static ModConfigSpec.IntValue EXTRA_INVENTORY_BUTTON_OFFSET_X;
    private static ModConfigSpec.IntValue EXTRA_INVENTORY_BUTTON_OFFSET_Y;
    private static ModConfigSpec.BooleanValue BLOODY_EFFECT;
    private static ModConfigSpec.EnumValue<GoreEffect> GORE_EFFECT;
    private static ModConfigSpec.BooleanValue DAMAGE_INDICATOR;
    private static ModConfigSpec.BooleanValue HEAL_INDICATOR;

    public static void onLoad() {
        showWindParticles = (Integer)SHOW_WIND_PARTICLES.get();
        achievementToast = (Boolean)ACHIEVEMENT_TOAST.get();
        sellPriceDisplay = (SellPriceDisplay)((Object)SELL_PRICE_DISPLAY.get());
        terraStyleHealth = (Boolean)TERRA_STYLE_HEALTH.get();
        healthStyle = (TerraStyleHealthHud.Health)((Object)HEALTH_STYLE.get());
        healthOffsetX = (Integer)HEALTH_OFFSET_X.get();
        healthOffsetY = (Integer)HEALTH_OFFSET_Y.get();
        foodStyle = (TerraStyleFoodHud.Food)((Object)FOOD_STYLE.get());
        manaStyle = (TerraStyleManaHud.Mana)((Object)MANA_STYLE.get());
        manaOffsetX = (Integer)MANA_OFFSET_X.get();
        manaOffsetY = (Integer)MANA_OFFSET_Y.get();
        terraStyleArmor = (Boolean)TERRA_STYLE_ARMOR.get();
        armorStyle = (TerraStyleArmorHud.Armor)((Object)ARMOR_STYLE.get());
        terraStyleFood = (Boolean)TERRA_STYLE_FOOD.get();
        leftEffectIcon = (Boolean)LEFT_EFFECT_ICON.get();
        extraInventoryButtonOffsetX = (Integer)EXTRA_INVENTORY_BUTTON_OFFSET_X.get();
        extraInventoryButtonOffsetY = (Integer)EXTRA_INVENTORY_BUTTON_OFFSET_Y.get();
        bloodyEffect = (Boolean)BLOODY_EFFECT.get();
        goreEffect = GORE_EFFECT != null ? (GoreEffect)((Object)GORE_EFFECT.get()) : GoreEffect.OFF;
        damageIndicator = (Boolean)DAMAGE_INDICATOR.get();
        healIndicator = (Boolean)HEAL_INDICATOR.get();
        StarPhaseHandler.enabled = (Boolean)CommonConfigs.STAR_PHASE.get();
    }

    public static void register(ModContainer container) {
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        SHOW_WIND_PARTICLES = BUILDER.defineInRange("showWindParticles", 90, 0, 100);
        ACHIEVEMENT_TOAST = BUILDER.define("achievementToast", true);
        SELL_PRICE_DISPLAY = BUILDER.defineEnum("sellPriceDisplay", (Enum)SellPriceDisplay.EVERYWHERE);
        BUILDER.push("HUD");
        BUILDER.push("Health");
        TERRA_STYLE_HEALTH = BUILDER.define("terraStyleHealth", true);
        HEALTH_STYLE = BUILDER.defineEnum("healthStyle", (Enum)TerraStyleHealthHud.Health.OVERLAY);
        HEALTH_OFFSET_X = BUILDER.defineInRange("healthOffsetX", 0, -256, 256);
        HEALTH_OFFSET_Y = BUILDER.defineInRange("healthOffsetY", 0, -256, 256);
        BUILDER.pop();
        BUILDER.push("Food");
        TERRA_STYLE_FOOD = BUILDER.define("terraStyleFood", true);
        FOOD_STYLE = BUILDER.defineEnum("foodStyle", (Enum)TerraStyleFoodHud.Food.OVERLAY);
        BUILDER.pop();
        BUILDER.push("Mana");
        MANA_STYLE = BUILDER.defineEnum("manaStyle", (Enum)TerraStyleManaHud.Mana.OVERLAY);
        MANA_OFFSET_X = BUILDER.defineInRange("manaOffsetX", 0, -256, 256);
        MANA_OFFSET_Y = BUILDER.defineInRange("manaOffsetY", 0, -256, 256);
        BUILDER.pop();
        BUILDER.push("Armor");
        TERRA_STYLE_ARMOR = BUILDER.define("terraStyleArmor", true);
        ARMOR_STYLE = BUILDER.defineEnum("armorStyle", (Enum)TerraStyleArmorHud.Armor.OVERLAY);
        BUILDER.pop();
        LEFT_EFFECT_ICON = BUILDER.define("leftEffectIcon", true);
        EXTRA_INVENTORY_BUTTON_OFFSET_X = BUILDER.defineInRange("extraInventoryButtonOffsetX", 0, -256, 256);
        EXTRA_INVENTORY_BUTTON_OFFSET_Y = BUILDER.defineInRange("extraInventoryButtonOffsetY", 0, -256, 256);
        BUILDER.pop();
        BUILDER.push("Entity");
        BLOODY_EFFECT = BUILDER.define("bloodyEffect", true);
        if (!ModList.get().isLoaded("yes_steve_model")) {
            GORE_EFFECT = BUILDER.defineEnum("goreEffect", (Enum)GoreEffect.CONFLUENCE_VANILLA);
        }
        DAMAGE_INDICATOR = BUILDER.define("damageIndicator", true);
        HEAL_INDICATOR = BUILDER.define("healIndicator", true);
        BUILDER.pop();
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BUILDER.build());
    }

    public static enum SellPriceDisplay implements TranslatableEnum
    {
        NEVER{

            @Override
            public boolean test() {
                return false;
            }
        }
        ,
        EVERYWHERE{

            @Override
            public boolean test() {
                return true;
            }
        }
        ,
        TRADE_SCREEN{

            @Override
            public boolean test() {
                return Minecraft.getInstance().screen instanceof TETradeScreen;
            }
        };


        public abstract boolean test();

        @NotNull
        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.sellPriceDisplay." + this.name().toLowerCase(Locale.ROOT)));
        }
    }

    public static enum GoreEffect implements TranslatableEnum
    {
        OFF,
        CONFLUENCE,
        CONFLUENCE_VANILLA,
        ALL;


        @NotNull
        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.goreEffect." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

