/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.confluence.mod.Confluence;

public final class ColoredGlintContext {
    public static final List<ColoredGlintContext> COLORED_GLINT_CONTEXTS = Lists.newArrayList();
    public static final RenderStateShard.TextureStateShard COLORED_GLINT_TEXTURE_STATE_SHARD = new RenderStateShard.TextureStateShard(Confluence.asResource("textures/misc/white_glint.png"), true, false);
    private final RenderType renderType;
    private final float[] glintColor;

    ColoredGlintContext(RenderType renderType, float[] glintColor) {
        this.renderType = renderType;
        this.glintColor = glintColor;
    }

    public static ColoredGlintContext create(String name, float red, float green, float blue) {
        float[] glintColor = new float[]{red, green, blue};
        ColoredGlintContext context = new ColoredGlintContext((RenderType)RenderType.create((String)("colored_glint_" + name), (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)COLORED_GLINT_TEXTURE_STATE_SHARD).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.NO_CULL).setDepthTestState(RenderStateShard.EQUAL_DEPTH_TEST).setTransparencyState(RenderStateShard.GLINT_TRANSPARENCY).setTexturingState(RenderStateShard.GLINT_TEXTURING).setColorLogicState(new RenderStateShard.ColorLogicStateShard("set_color", () -> RenderSystem.setShaderColor((float)glintColor[0], (float)glintColor[1], (float)glintColor[2], (float)1.0f), () -> RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f))).createCompositeState(false)), glintColor);
        COLORED_GLINT_CONTEXTS.add(context);
        return context;
    }

    public static ColoredGlintContext create(String name, int rgb) {
        return ColoredGlintContext.create(name, (float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f);
    }

    public void setGlintColor(float red, float green, float blue) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._setGlintColor(red, green, blue));
        } else {
            this._setGlintColor(red, green, blue);
        }
    }

    public void setGlintColor(int red, int green, int blue) {
        float r = (float)red / 255.0f;
        float g = (float)green / 255.0f;
        float b = (float)blue / 255.0f;
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this._setGlintColor(r, g, b));
        } else {
            this._setGlintColor(r, g, b);
        }
    }

    private void _setGlintColor(float red, float green, float blue) {
        this.glintColor[0] = red;
        this.glintColor[1] = green;
        this.glintColor[2] = blue;
    }

    public RenderType renderType() {
        return this.renderType;
    }
}

