/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect;

import com.mojang.blaze3d.shaders.FogShape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import org.confluence.mod.common.init.ModParticleTypes;
import org.confluence.mod.mixed.ILevelChunkSection;
import org.confluence.mod.util.DynamicBiomeUtils;
import software.bernie.geckolib.animation.EasingType;

@EventBusSubscriber(modid="confluence", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class EctoMistHelper {
    public static int effectiveTombstones = 0;
    private static float ectoMistStep = 1.0f;
    private static float originalNearFog = 0.0f;
    private static float originalFarFog = 0.0f;
    private static float lastStart = 4.0f;

    public static void tick(Minecraft minecraft, LocalPlayer player) {
        if (player.level().getGameTime() % 40L == 2L) {
            ILevelChunkSection iSection = DynamicBiomeUtils.getISection((LevelAccessor)player.level(), player.blockPosition());
            int n = effectiveTombstones = iSection == null ? 0 : iSection.confluence$getBlockCounts().tomb.get() - iSection.confluence$getBlockCounts().sunflower.get();
        }
        if (EctoMistHelper.isGraveyard() && !minecraft.isPaused() && player.getRandom().nextInt(10) == 0) {
            player.level().addParticle((ParticleOptions)ModParticleTypes.ECTO_MIST.get(), player.getX() + (player.getRandom().nextDouble() - 0.5) * 16.0, player.getY() + player.getRandom().nextDouble() * 4.0, player.getZ() + (player.getRandom().nextDouble() - 0.5) * 16.0, 0.0, 0.0, 0.0);
        }
    }

    public static void reset() {
        effectiveTombstones = 0;
    }

    public static boolean isGraveyard() {
        return effectiveTombstones >= 7;
    }

    @SubscribeEvent
    public static void fogColor(ViewportEvent.ComputeFogColor event) {
        if (EctoMistHelper.isGraveyard()) {
            if (ectoMistStep > 0.0f) {
                ectoMistStep -= 0.5f / (float)Minecraft.getInstance().getFps();
            }
            float exp = Mth.clamp((float)ectoMistStep, (float)0.5f, (float)1.0f);
            event.setRed(event.getRed() * exp);
            event.setGreen(event.getGreen() * exp);
            event.setBlue(event.getBlue() * exp);
        } else if (ectoMistStep < 1.0f) {
            float exp = Mth.clamp((float)(ectoMistStep += 0.5f / (float)Minecraft.getInstance().getFps()), (float)0.5f, (float)1.0f);
            event.setRed(event.getRed() * exp);
            event.setGreen(event.getGreen() * exp);
            event.setBlue(event.getBlue() * exp);
        } else {
            ectoMistStep = 1.0f;
        }
    }

    @SubscribeEvent
    public static void renderFog(ViewportEvent.RenderFog event) {
        if (EctoMistHelper.isGraveyard()) {
            float exp = (float)EasingType.exp((double)ectoMistStep);
            lastStart = 28.0f / (float)(effectiveTombstones - 6);
            event.setNearPlaneDistance(Mth.lerp((float)exp, (float)lastStart, (float)originalNearFog));
            event.setFarPlaneDistance(Mth.lerp((float)exp, (float)(lastStart + lastStart), (float)originalFarFog));
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        } else if (ectoMistStep < 1.0f) {
            float exp = (float)EasingType.exp((double)ectoMistStep);
            event.setNearPlaneDistance(Mth.lerp((float)exp, (float)lastStart, (float)(originalNearFog * 0.5f)));
            event.setFarPlaneDistance(Mth.lerp((float)exp, (float)(lastStart + lastStart), (float)(originalFarFog * 0.5f)));
            event.setFogShape(FogShape.SPHERE);
            event.setCanceled(true);
        } else {
            originalNearFog = event.getNearPlaneDistance();
            originalFarFog = event.getFarPlaneDistance();
        }
    }
}

