/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Slime;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;

public class GlowingHelper {
    public static final GlowingHelper INSTANCE = (GlowingHelper)Util.make((Object)new GlowingHelper(), helper -> {
        helper.addHunter(Slime.class, Color.MAGENTA, true);
        helper.addHunter(Animal.class, Color.green, false);
        helper.addDanger(BoulderEntity.class, Color.red, true);
    });
    public boolean alwaysShow = false;
    public Color defaultColor = Color.white;
    public Color neutralColor = Color.blue;
    public boolean alwaysShowNeutral = false;
    public Color angerColor = Color.red;
    public Color enemyColor = Color.orange;
    public Map<Class<? extends Entity>, Data> colorMap = new LinkedHashMap<Class<? extends Entity>, Data>();
    public List<Class<? extends Entity>> hunterCatalog = new ArrayList<Class<? extends Entity>>();
    public List<Class<? extends Entity>> dangerCatalog = new ArrayList<Class<? extends Entity>>();

    public void addHunter(Class<? extends Entity> clazz, Color color, boolean alwaysShow) {
        this.hunterCatalog.add(clazz);
        this.colorMap.put(clazz, new Data(color, alwaysShow));
    }

    public void addDanger(Class<? extends Entity> clazz, Color color, boolean alwaysShow) {
        this.dangerCatalog.add(clazz);
        this.colorMap.put(clazz, new Data(color, alwaysShow));
    }

    public record Data(Color color, boolean alwaysShow) {
    }
}

