/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.client.ModKeyBindings;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.phase_journey.common.phase.PhaseManager;
import org.confluence.terraentity.client.buffer.AbstractBufferManager;
import org.confluence.terraentity.client.util.ShaderUtil;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.lwjgl.opengl.GL11;

public class SpelunkerHelper
extends AbstractBufferManager {
    public int range = 30;
    public int textRange = 30;
    public float maxAlpha = 0.8f;
    public int textRenderType = 0;
    public int centerInternal = 50;
    private final Map<Block, Entry> targets = new HashMap<Block, Entry>();
    public Map<BlockPos, BlockPos> centerCache = new HashMap<BlockPos, BlockPos>();
    public Map<BlockPos, Block> centerCacheFrame = new HashMap<BlockPos, Block>();
    public Map<Block, ArrayList<BlockPos>> centers = new LinkedHashMap<Block, ArrayList<BlockPos>>();
    public Map<Block, List<BlockPos>> blockMap = new HashMap<Block, List<BlockPos>>();
    private static SpelunkerHelper blockGen;
    public static volatile boolean lock;
    int buildCount = 10;

    protected boolean shouldRefresh() {
        return System.currentTimeMillis() - this.lastRefreshTime > 100L;
    }

    public static SpelunkerHelper getSingleton() {
        if (blockGen == null) {
            blockGen = new SpelunkerHelper(100);
        }
        return blockGen;
    }

    public SpelunkerHelper(int refreshTime) {
        super(refreshTime);
        this.refreshBlocks();
        this.defaultBlocks();
    }

    public void defaultBlocks() {
        this.putTarget(Blocks.ANCIENT_DEBRIS, 6234112, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.DIAMOND_ORE, 12451583, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_DIAMOND_ORE, 12451583, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_DIAMOND_ORE.get(), 12451583, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_DIAMOND_ORE.get(), 12451583, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_DIAMOND_ORE.get(), 12451583, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_RUBY_ORE.get(), 0xA80000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_AMBER_ORE.get(), 11033600, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_TOPAZ_ORE.get(), 11043584, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.JADE_ORE.get(), 43131, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_JADE_ORE.get(), 43131, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_SAPPHIRE_ORE.get(), 21160, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_AMETHYST_ORE.get(), 8192168, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.EMERALD_ORE, 10747765, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_EMERALD_ORE, 10747765, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_EMERALD_ORE.get(), 10747765, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_EMERALD_ORE.get(), 10747765, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_EMERALD_ORE.get(), 10747765, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.IRON_ORE, 12562063, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_IRON_ORE, 12562063, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_IRON_ORE.get(), 12562063, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_IRON_ORE.get(), 12562063, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_IRON_ORE.get(), 12562063, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.GOLD_ORE, 13418016, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_GOLD_ORE, 13418016, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_GOLD_ORE.get(), 13418016, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_GOLD_ORE.get(), 13418016, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_GOLD_ORE.get(), 13418016, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.GILDED_BLACKSTONE, 13418016, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.NETHER_GOLD_ORE, 13418016, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.COAL_ORE, 0x555555, false, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_COAL_ORE, 0x555555, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_COAL_ORE.get(), 0x555555, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_COAL_ORE.get(), 0x555555, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_COAL_ORE.get(), 0x555555, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.COPPER_ORE, 9916461, false, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_COPPER_ORE, 9916461, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_COPPER_ORE.get(), 9916461, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_COPPER_ORE.get(), 9916461, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_COPPER_ORE.get(), 9916461, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.TIN_ORE.get(), 9867886, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_TIN_ORE.get(), 9867886, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_TIN_ORE.get(), 9867886, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_TIN_ORE.get(), 9867886, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_TIN_ORE.get(), 9867886, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.LEAD_ORE.get(), 3164515, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_LEAD_ORE.get(), 3164515, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_LEAD_ORE.get(), 3164515, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_LEAD_ORE.get(), 3164515, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_LEAD_ORE.get(), 3164515, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SILVER_ORE.get(), 6976380, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_SILVER_ORE.get(), 6976380, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_SILVER_ORE.get(), 6976380, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_SILVER_ORE.get(), 6976380, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_SILVER_ORE.get(), 6976380, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_TUNGSTEN_ORE.get(), 8830620, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_PLATINUM_ORE.get(), 8501725, true, ShowType.SPELUNKER);
        this.putTarget((Block)NatureBlocks.LIFE_CRYSTAL_BLOCK.get(), 15472446, true, ShowType.SPELUNKER);
        for (DeferredBlock<BaseChestBlock> normalChest : ChestBlocks.NORMAL_CHESTS) {
            this.putTarget((Block)normalChest.get(), 15254292, true, ShowType.SPELUNKER);
        }
        this.putTarget(Blocks.CHEST, 15254292, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.LAPIS_ORE, 6847487, false, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_LAPIS_ORE, 6847487, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_LAPIS_ORE.get(), 6847487, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_LAPIS_ORE.get(), 6847487, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_LAPIS_ORE.get(), 6847487, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.REDSTONE_ORE, 0x7D0000, false, ShowType.SPELUNKER);
        this.putTarget(Blocks.DEEPSLATE_REDSTONE_ORE, 0x7D0000, false, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CORRUPTION_REDSTONE_ORE.get(), 0x7D0000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.SANCTIFICATION_REDSTONE_ORE.get(), 0x7D0000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.FLESHIFICATION_REDSTONE_ORE.get(), 0x7D0000, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.COLD_CRYSTAL_ORE.get(), 4044720, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.GELSTONE_ORE.get(), 6469437, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.OPAL_ORE.get(), 4963583, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.HELLSTONE.get(), 15361294, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.ASH_HELLSTONE.get(), 15361294, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.NETHER_QUARTZ_ORE, 14863548, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_COBALT_ORE.get(), 24809, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_PALLADIUM_ORE.get(), 15299840, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_MYTHRIL_ORE.get(), 59822, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_ORICHALCUM_ORE.get(), 14876905, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_ADAMANTITE_ORE.get(), 15269974, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.DEEPSLATE_TITANIUM_ORE.get(), 16112895, true, ShowType.SPELUNKER);
        this.putTarget((Block)OreBlocks.CHLOROPHYTE_ORE.get(), 42011, true, ShowType.SPELUNKER);
        this.putTarget(Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.STONE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.STONE_PRESSURE_PLATE.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.SWITCH.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.DART_TRAP.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.DEEPSLATE_PRESSURE_PLATE.get(), 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.TNT, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.TRIPWIRE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.SCULK_SHRIEKER, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.SCULK_SENSOR, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.DETECTOR_RAIL, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.ACTIVATOR_RAIL, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.ACACIA_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.BAMBOO_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.HEAVY_WEIGHTED_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.BIRCH_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.CRIMSON_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.CHERRY_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.WARPED_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.SPRUCE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.DARK_OAK_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.OAK_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.JUNGLE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.LIGHT_WEIGHTED_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.MANGROVE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget(Blocks.POLISHED_BLACKSTONE_PRESSURE_PLATE, 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.PLAYER_PRESSURE_PLATE.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.NORMAL_BOULDER.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.OAK_LOG_BOULDER.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.FOLLOWER_BOULDER.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.EXPLODE_BOULDER.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.ROLLING_CACTUS_BOULDER.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.MECHANICAL_FRAGILE_SANDSTONE.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.MECHANICAL_FRAGILE_OBSIDIAN_BRICKS.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.SCULK_TRAP.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.SHIMMER_TRAP.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.GRAVITATION_TRAP.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.PNEUMATIC_TRAP.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)FunctionalBlocks.SPIKE.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)ChestBlocks.DEATH_GOLDEN_CHEST.get(), 16729600, true, ShowType.DANGER);
        this.putTarget((Block)ChestBlocks.DEATH_WOODEN_CHEST.get(), 16729600, true, ShowType.DANGER);
    }

    @Deprecated
    private void putTarget(Block block, Color color, boolean always, ShowType showType) {
        this.putTarget(block, color.getRGB(), always, showType);
    }

    private void putTarget(Block block, int rgb, boolean always, ShowType showType) {
        this.targets.put(block, new Entry(rgb, always, showType));
    }

    private void refreshBlocks() {
        for (Map.Entry<Block, List<BlockPos>> n : this.blockMap.entrySet()) {
            n.getValue().clear();
        }
        this.blockMap.clear();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Level level = player.level();
        BlockPos center = player.blockPosition();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = -this.range; i <= this.range; ++i) {
            pos.setX(center.getX() + i);
            for (int j = -this.range; j < this.range; ++j) {
                pos.setY(center.getY() + j);
                for (int k = -this.range; k < this.range; ++k) {
                    Block block;
                    pos.setZ(center.getZ() + k);
                    BlockState blockState = level.getBlockState((BlockPos)pos);
                    if (blockState.isAir() || !(this.targets.containsKey(block = (blockState = PhaseManager.BLOCK.replaceSourceIfPlayerNotReachedPhase((Player)player, blockState)).getBlock()) && (this.targets.get((Object)block).showType == ShowType.SPELUNKER && player.hasEffect(ModEffects.SPELUNKER) || this.targets.get((Object)block).showType == ShowType.DANGER && player.hasEffect(ModEffects.DANGER_SENSE))) && (!blockState.is(Tags.Blocks.ORES) || !player.hasEffect(ModEffects.SPELUNKER))) continue;
                    this.blockMap.computeIfAbsent(block, k1 -> new ArrayList()).add(pos.immutable());
                }
            }
        }
    }

    protected void buildBuffer(BufferBuilder buffer) {
        this.centers.clear();
        this.centerCacheFrame.clear();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (--this.buildCount <= 0) {
            this.buildCount = 10;
            this.refreshBlocks();
        }
        for (Map.Entry<Block, List<BlockPos>> n : this.blockMap.entrySet()) {
            this.centers.put(n.getKey(), new ArrayList());
            Entry target = SpelunkerHelper.blockGen.targets.get(n.getKey());
            int rgb = target != null ? target.color() : n.getKey().defaultBlockState().getMapColor((BlockGetter)player.level(), n.getValue().getFirst()).calculateRGBColor(MapColor.Brightness.HIGH);
            if (n.getValue() == null) {
                return;
            }
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            for (BlockPos blockProps : n.getValue()) {
                int a;
                if (blockProps == null) {
                    return;
                }
                float size = 1.0f;
                boolean ifNear = false;
                if (player.level().getBlockState(blockProps).is(Blocks.AIR)) {
                    this.centerCache.remove(blockProps);
                    ArrayList<BlockPos> list = this.centers.get(n.getKey());
                    if (list != null && !list.isEmpty()) {
                        list.removeIf(centerPos -> centerPos.distSqr((Vec3i)blockProps) < 25.0);
                    }
                }
                if (target != null && target.showType == ShowType.SPELUNKER || n.getKey().defaultBlockState().is(Tags.Blocks.ORES)) {
                    if (!player.hasEffect(ModEffects.SPELUNKER)) continue;
                    for (BlockPos centerPos2 : this.centers.get(n.getKey())) {
                        double distance = centerPos2.distSqr((Vec3i)blockProps);
                        if (!(distance < (double)SpelunkerHelper.blockGen.centerInternal)) continue;
                        this.centerCache.put(blockProps, centerPos2);
                        ifNear = true;
                        break;
                    }
                    if (ifNear) {
                        if (!((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown()) {
                            continue;
                        }
                    } else {
                        this.centers.get(n.getKey()).add(blockProps);
                        this.centerCacheFrame.put(blockProps, n.getKey());
                    }
                } else if (target != null && target.showType == ShowType.DANGER) {
                    if (!player.hasEffect(ModEffects.DANGER_SENSE)) continue;
                    this.centerCacheFrame.put(blockProps, n.getKey());
                }
                if ((a = (int)((255.0 - Math.min(player.distanceToSqr((double)blockProps.getX(), (double)blockProps.getY(), (double)blockProps.getZ()) / (double)(SpelunkerHelper.blockGen.range * SpelunkerHelper.blockGen.range) * 255.0, 255.0)) * (double)SpelunkerHelper.blockGen.maxAlpha)) <= 0) continue;
                ShaderUtil.renderDebugBlock((BufferBuilder)buffer, (BlockPos)blockProps, (float)1.0f, (int)r, (int)g, (int)b, (int)a);
            }
        }
    }

    protected void beforeRender() {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2848);
        GL11.glDisable((int)2929);
    }

    protected void afterRender(PoseStack poseStack) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
        poseStack.pushPose();
        Vec3 playerPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        poseStack.translate(-playerPos.x(), -playerPos.y(), -playerPos.z());
        Map<Block, Entry> map = SpelunkerHelper.blockGen.targets;
        int textRange = SpelunkerHelper.blockGen.textRange;
        AtomicInteger count = new AtomicInteger();
        float scale = 20.0f;
        int textDir = SpelunkerHelper.blockGen.textRenderType;
        for (Map.Entry<BlockPos, Block> n : this.centerCacheFrame.entrySet()) {
            Vec3 pf;
            double z;
            double y;
            double x;
            Vec3 dir;
            double angle;
            Entry entry;
            BlockPos pos = n.getKey();
            Block block = n.getValue();
            if (block.asItem() == Blocks.ANCIENT_DEBRIS.asItem()) {
                count.getAndIncrement();
            }
            if (!(playerPos.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) < (double)(textRange * textRange)) || !((KeyMapping)ModKeyBindings.SHOW_DETAIL_SPECULAR.get()).isDown() || (entry = map.get(block)) == null || !entry.showText() || !((angle = Math.acos((dir = playerPos.subtract(x = (double)pos.getX() + 0.5, y = (double)pos.getY() + 0.5, z = (double)pos.getZ() + 0.5).scale(-1.0)).dot(pf = player.getForward()) / dir.length() / pf.length())) < 1.0471975511965976)) continue;
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            poseStack.scale(-1.0f / scale, -1.0f / scale, -1.0f / scale);
            if (textDir == 0) {
                float[] fs = VectorUtils.dirToRot((Vec3)dir.scale(-1.0), (boolean)false);
                Matrix4f m = new Matrix4f().rotate((Quaternionfc)Axis.YP.rotation((float)Math.PI - fs[0])).rotate((Quaternionfc)Axis.XN.rotation(fs[1]));
                poseStack.mulPose(m);
            } else {
                Quaternionf q1 = new Quaternionf((Quaternionfc)Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
                poseStack.mulPose(q1);
            }
            Component component = block.asItem().getDefaultInstance().getDisplayName();
            poseStack.translate((double)(-component.getString().length()) / 5.0 * (double)scale, 0.7 * (double)scale, 0.0);
            Minecraft.getInstance().font.renderText(Component.literal((String)component.getString()).withColor(entry.color()).getVisualOrderText(), -5.0f, -5.0f, entry.color(), false, poseStack.last().pose(), (MultiBufferSource)Minecraft.getInstance().renderBuffers().bufferSource(), Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
            poseStack.popPose();
        }
        poseStack.popPose();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2848);
    }

    public static void renderLevel(RenderLevelStageEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || player == null) {
            return;
        }
        SpelunkerHelper blockGen = SpelunkerHelper.getSingleton();
        if (!player.hasEffect(ModEffects.SPELUNKER) && !player.hasEffect(ModEffects.DANGER_SENSE)) {
            blockGen.centerCache.clear();
            blockGen.centers.clear();
            blockGen.blockMap.clear();
            blockGen.centerCacheFrame.clear();
            return;
        }
        lock = true;
        blockGen.render(event);
        lock = false;
    }

    static {
        lock = true;
    }

    private static enum ShowType implements StringRepresentable
    {
        SPELUNKER,
        DANGER;

        private static final Codec<ShowType> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(ShowType::values);
        }
    }

    private record Entry(int color, boolean showText, ShowType showType) {
        private static final Codec<Entry> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("color").forGetter(Entry::color), (App)Codec.BOOL.fieldOf("showText").forGetter(Entry::showText), (App)ShowType.CODEC.fieldOf("showType").forGetter(Entry::showType)).apply((Applicative)builder, Entry::new));
        private static final MapCodec<Map<Block, Entry>> BLOCK_MAP_CODEC = Codec.unboundedMap((Codec)BuiltInRegistries.BLOCK.byNameCodec(), CODEC).fieldOf("targets").fieldOf("values");
    }
}

