/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect.connected;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.confluence.mod.client.effect.connected.CustomBlockModels;

public class ModelSwapper {
    protected CustomBlockModels customBlockModels = new CustomBlockModels();

    public CustomBlockModels getCustomBlockModels() {
        return this.customBlockModels;
    }

    public void onModelBake(Map<ModelResourceLocation, BakedModel> modelRegistry) {
        this.customBlockModels.forEach((block, modelFunc) -> ModelSwapper.swapModels(modelRegistry, ModelSwapper.getAllBlockStateModelLocations(BuiltInRegistries.BLOCK.getKey(block), block), modelFunc));
    }

    public static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, List<ModelResourceLocation> locations, Function<BakedModel, T> factory) {
        locations.forEach(location -> ModelSwapper.swapModels(modelRegistry, location, factory));
    }

    public static <T extends BakedModel> void swapModels(Map<ModelResourceLocation, BakedModel> modelRegistry, ModelResourceLocation location, Function<BakedModel, T> factory) {
        modelRegistry.put(location, (BakedModel)factory.apply(modelRegistry.get(location)));
    }

    public static List<ModelResourceLocation> getAllBlockStateModelLocations(ResourceLocation id, Block block) {
        ImmutableList possibleStates = block.getStateDefinition().getPossibleStates();
        int arraySize = possibleStates.size();
        ArrayList<ModelResourceLocation> models = new ArrayList<ModelResourceLocation>(5 + arraySize + arraySize / 10);
        possibleStates.forEach(state -> models.add(BlockModelShaper.stateToModelLocation((ResourceLocation)id, (BlockState)state)));
        return models;
    }
}

