/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.effect.textures;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.confluence.mod.client.effect.connected.BakedModelWrapperWithData;
import org.confluence.mod.client.effect.connected.BakedQuadHelper;
import org.confluence.mod.client.effect.textures.GraySpriteShifterEntry;
import org.confluence.mod.client.effect.textures.LocalBrushData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrayBlockModelSwapper
extends BakedModelWrapperWithData {
    protected static final ModelProperty<int[]> COLOR_PROPERTY = new ModelProperty();

    public GrayBlockModelSwapper(BakedModel originalModel) {
        super(originalModel);
    }

    @Override
    protected ModelData.Builder gatherModelData(ModelData.Builder builder, BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData blockEntityData) {
        int @Nullable [] colors = LocalBrushData.getColors(pos);
        if (colors != null) {
            return builder.with(COLOR_PROPERTY, (Object)colors);
        }
        return builder;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        ArrayList<BakedQuad> quads = super.getQuads(state, side, rand, extraData, renderType);
        int[] colors = (int[])extraData.get(COLOR_PROPERTY);
        if (colors == null) {
            return quads;
        }
        int color = colors[(side == null ? Direction.WEST : side).get3DDataValue()];
        if (color == -1 || color == -4 || color == -5) {
            return quads;
        }
        quads = new ArrayList<BakedQuad>(quads);
        for (int i = 0; i < quads.size(); ++i) {
            BakedQuad quad = (BakedQuad)quads.get(i);
            GraySpriteShifterEntry entry = GraySpriteShifterEntry.ALL.get(quad.getSprite().contents().name());
            if (entry == null) continue;
            TextureAtlasSprite sprite = color == -3 ? entry.negative() : entry.gray();
            BakedQuad bakedQuad = BakedQuadHelper.clone(quad);
            int[] vertexData = bakedQuad.getVertices();
            for (int vertex = 0; vertex < 4; ++vertex) {
                float u = BakedQuadHelper.getU(vertexData, vertex);
                float v = BakedQuadHelper.getV(vertexData, vertex);
                BakedQuadHelper.setU(vertexData, vertex, entry.getTargetU(sprite, u));
                BakedQuadHelper.setV(vertexData, vertex, entry.getTargetV(sprite, v));
            }
            quads.set(i, bakedQuad);
        }
        return quads;
    }
}

