/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.event;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientMobEffectExtensions;
import org.confluence.lib.color.IntegerRGB;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.effect.ColoredGlintContext;
import org.confluence.mod.client.handler.MeteorLandingHandler;
import org.confluence.mod.client.renderer.item.CustomLightItemExtension;
import org.confluence.mod.client.renderer.item.EntityDisplayItemRenderer;
import org.confluence.mod.client.renderer.item.MutableRenderTypeItemExtension;
import org.confluence.mod.common.init.ModArmPoses;
import org.confluence.mod.common.init.ModFluids;
import org.confluence.mod.common.init.block.DecorativeBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.init.block.ModBlocks;
import org.confluence.mod.common.init.item.AccessoryItems;
import org.confluence.mod.common.init.item.BowItems;
import org.confluence.mod.common.init.item.FishingPoleItems;
import org.confluence.mod.common.init.item.ToolItems;
import org.confluence.mod.common.item.accessory.GuideVooDooDollItem;
import org.confluence.mod.common.item.bow.ShortBowItem;
import org.confluence.mod.integration.waystones.PylonBlock;
import org.confluence.mod.integration.waystones.PylonModel;
import org.confluence.mod.integration.waystones.WaystonesHelper;
import org.confluence.mod.mixed.IPlayer;
import org.confluence.mod.util.ClientUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ModClientSetups {
    public static final WidgetSprites EXTRA_INVENTORY_BUTTON = new WidgetSprites(Confluence.asResource("widget/extra_inventory_button"), Confluence.asResource("widget/extra_inventory_button_highlighted"));
    public static final ResourceLocation BLOOM_TEXTURE = Confluence.asResource("textures/misc/bloom.png");
    static final IClientFluidTypeExtensions HONEY_CLIENT_EXTENSIONS = new IClientFluidTypeExtensions(){
        private static final ResourceLocation STILL = Confluence.asResource("block/fluid/honey_still");
        private static final ResourceLocation FLOWING = Confluence.asResource("block/fluid/honey_flowing");
        private static final Vector3f FOG_COLOR = new Vector3f(1.0f, 1.0f, 0.0f);

        public ResourceLocation getStillTexture() {
            return STILL;
        }

        public ResourceLocation getFlowingTexture() {
            return FLOWING;
        }

        public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
            return FOG_COLOR;
        }

        public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
            RenderSystem.setShaderFogStart((float)0.125f);
            RenderSystem.setShaderFogEnd((float)5.0f);
        }
    };
    static final IClientFluidTypeExtensions SHIMMER_CLIENT_EXTENSIONS = new IClientFluidTypeExtensions(){
        private static final ResourceLocation STILL = Confluence.asResource("block/fluid/shimmer_still");
        private static final ResourceLocation FLOWING = Confluence.asResource("block/fluid/shimmer_flowing");
        private static final Vector3f FOG_COLOR = new Vector3f(1.0f, 0.5882f, 1.0f);

        public ResourceLocation getStillTexture() {
            return STILL;
        }

        public ResourceLocation getFlowingTexture() {
            return FLOWING;
        }

        public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
            return FOG_COLOR;
        }

        public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
            RenderSystem.setShaderFogStart((float)0.125f);
            RenderSystem.setShaderFogEnd((float)10.0f);
        }
    };
    static final IClientBlockExtensions NO_HIT_EFFECTS = new IClientBlockExtensions(){

        public boolean addHitEffects(BlockState state, Level level, HitResult target, ParticleEngine manager) {
            return true;
        }
    };
    static final IClientItemExtensions ENTITY_DISPLAY = new IClientItemExtensions(){
        private EntityDisplayItemRenderer renderer;

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            if (this.renderer == null) {
                this.renderer = new EntityDisplayItemRenderer();
            }
            return this.renderer;
        }
    };
    static final IClientItemExtensions BREATHING_REED = ModClientSetups.simpleArmPose(() -> ModArmPoses.BREATHING_REED.getValue());
    static final IClientItemExtensions SPEAR = ModClientSetups.simpleArmPose(() -> ModArmPoses.SPEAR.getValue());
    static final IClientItemExtensions UMBRELLA = ModClientSetups.simpleArmPose(() -> ModArmPoses.UMBRELLA.getValue());
    static final IClientItemExtensions DRILL_O_CHAINSAW = ModClientSetups.simpleArmPose(() -> ModArmPoses.DRILL_O_CHAINSAW.getValue());
    static final IClientItemExtensions LANCE = ModClientSetups.simpleArmPose(() -> ModArmPoses.LANCE.getValue());
    static final IClientItemExtensions NOOP_ITEM = new IClientItemExtensions(){
        private BlockEntityWithoutLevelRenderer renderer;

        public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
            return true;
        }

        public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
            return HumanoidModel.ArmPose.EMPTY;
        }

        public BlockEntityWithoutLevelRenderer getCustomRenderer() {
            if (this.renderer == null) {
                Minecraft minecraft = Minecraft.getInstance();
                this.renderer = new BlockEntityWithoutLevelRenderer(this, minecraft.getBlockEntityRenderDispatcher(), minecraft.getEntityModels()){

                    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
                    }
                };
            }
            return this.renderer;
        }
    };
    static final IClientItemExtensions GUIDE_VOODOO_DOLL = new MutableRenderTypeItemExtension(stack -> GuideVooDooDollItem.isWall(LibUtils.getItemStackNbtIfPresent((ItemStack)stack)) ? GLINT_FF0000.renderType() : RenderType.glint());
    static final IClientItemExtensions GLINT_RAINBOW_EXTENSIONS = new MutableRenderTypeItemExtension(stack -> GLINT_RAINBOW.renderType());
    static final IClientItemExtensions FULL_LIGHT = new CustomLightItemExtension(15);
    static final IClientMobEffectExtensions TRANSLUCENT_EFFECT_ICON = new IClientMobEffectExtensions(){

        public boolean renderInventoryIcon(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
            RenderSystem.enableBlend();
            Holder holder = instance.getEffect();
            TextureAtlasSprite textureAtlasSprite = screen.getMinecraft().getMobEffectTextures().get(holder);
            guiGraphics.blit(x, y + 7, blitOffset, 18, 18, textureAtlasSprite);
            RenderSystem.disableBlend();
            return true;
        }
    };
    static final BlockColor HALLOW_LEAVES_COLOR = new BlockColor(){

        public int getColor(BlockState state, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, int tintIndex) {
            if (pos == null) {
                return -1;
            }
            IntegerRGB x = 8.hallowMixture(Math.abs(pos.getX()) % 12);
            IntegerRGB y = 8.hallowMixture(Math.abs(pos.getY()) % 12);
            IntegerRGB z = 8.hallowMixture(Math.abs(pos.getZ()) % 12);
            return x.mixture(y, 0.5f).mixture(z, 0.5f).get();
        }

        private static IntegerRGB hallowMixture(int m) {
            if (m <= 4) {
                return IntegerRGB.HALLOW_A.mixture(IntegerRGB.HALLOW_B, (float)m * 0.25f);
            }
            if (m <= 8) {
                return IntegerRGB.HALLOW_B.mixture(IntegerRGB.HALLOW_C, (float)(m - 4) * 0.25f);
            }
            return IntegerRGB.HALLOW_C.mixture(IntegerRGB.HALLOW_A, (float)(m - 8) * 0.25f);
        }
    };
    static final IItemDecorator FISHING_POLE_DECORATOR = (guiGraphics, font, itemStack, x, y) -> {
        ItemStack bait;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getInventory().getSelected() == itemStack && !(bait = IPlayer.of((Player)player).confluence$getCurrentBait()).isEmpty()) {
            ClientUtils.renderBait(guiGraphics, bait, x, y);
        }
        return false;
    };
    static boolean guideCheckedJEI = ModList.get().isLoaded("jei") || ModList.get().isLoaded("emi");
    public static final boolean SHOULD_NOT_GENERATE_BLOCK_GRAY_TEXTURE = ModList.get().isLoaded("ctm") || ModList.get().isLoaded("fusion") || ModList.get().isLoaded("continuity");
    public static final RenderType TERRA_SWORD_RENDER_TYPE = RenderType.create((String)"entity_translucent_emissive", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENTITY_TRANSLUCENT_EMISSIVE_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(Confluence.asResource("textures/mask/sword.png"), true, false)).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setCullState(RenderStateShard.NO_CULL).setOverlayState(RenderStateShard.OVERLAY).createCompositeState(false));
    public static final ColoredGlintContext GLINT_FF0000 = ColoredGlintContext.create("FF0000", 0xFF0000);
    public static final ColoredGlintContext GLINT_RAINBOW = ColoredGlintContext.create("rainbow", 0.0f, 0.0f, 0.0f);

    private static IClientItemExtensions simpleArmPose(final Supplier<HumanoidModel.ArmPose> supplier) {
        return new IClientItemExtensions(){

            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return (HumanoidModel.ArmPose)supplier.get();
            }
        };
    }

    static void setRenderLayers() {
        RenderType translucent = RenderType.translucent();
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.SHIMMER.fluid().get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.SHIMMER.flowing().get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.WHITE_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.LIGHT_GRAY_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.GRAY_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.BLACK_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.BROWN_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.RED_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.ORANGE_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.YELLOW_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.LIME_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.GREEN_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.CYAN_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.LIGHT_BLUE_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.BLUE_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.PURPLE_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.MAGENTA_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.PINK_PURE_GLASS.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.PACKED_ICE_BRICKS.get()), (RenderType)translucent);
        RenderType cutout = RenderType.cutout();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)FunctionalBlocks.EVER_POWERED_RAIL.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DecorativeBlocks.PURE_GLASS.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)FunctionalBlocks.ECHO_BLOCK.get()), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ModBlocks.CURSED_FLAME_BLOCK.get()), (RenderType)cutout);
    }

    static void registerItemProperties() {
        ResourceLocation enable = Confluence.asResource("enable");
        ItemProperties.register((Item)((Item)AccessoryItems.SPECTRE_GOGGLES.get()), (ResourceLocation)enable, (ItemPropertyFunction)LibClientUtils.COULD_ENABLE_PROPERTY_FUNCTION);
        ItemProperties.register((Item)((Item)AccessoryItems.MECHANICAL_LENS.get()), (ResourceLocation)enable, (ItemPropertyFunction)LibClientUtils.COULD_ENABLE_PROPERTY_FUNCTION);
        ItemProperties.register((Item)((Item)ToolItems.ENCUMBERING_STONE.get()), (ResourceLocation)enable, (ItemPropertyFunction)LibClientUtils.COULD_ENABLE_PROPERTY_FUNCTION);
        ItemProperties.register((Item)((Item)ToolItems.METEOR_COMPASS.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((level, stack, entity) -> MeteorLandingHandler.getGlobalPos()));
    }

    static void eventBus(Consumer<IEventBus> consumer) {
        ModList.get().getModContainerById("confluence").ifPresent(container -> {
            IEventBus eventBus = container.getEventBus();
            if (eventBus != null) {
                consumer.accept(eventBus);
            }
        });
    }

    public static void registerBowProperties() {
        ResourceLocation pull = ResourceLocation.withDefaultNamespace((String)"pull");
        ClampedItemPropertyFunction shortBowPull = (itemStack, clientLevel, living, speed) -> living != null && living.getUseItem() == itemStack ? (float)(itemStack.getUseDuration(living) - living.getUseItemRemainingTicks()) / 8.0f : 0.0f;
        ClampedItemPropertyFunction bowPull = (itemStack, clientLevel, living, speed) -> living != null && living.getUseItem() == itemStack ? (float)(itemStack.getUseDuration(living) - living.getUseItemRemainingTicks()) / 20.0f : 0.0f;
        ResourceLocation pulling = ResourceLocation.withDefaultNamespace((String)"pulling");
        ClampedItemPropertyFunction bowPulling = (itemStack, clientLevel, living, speed) -> living != null && living.isUsingItem() && living.getUseItem() == itemStack ? 1.0f : 0.0f;
        BowItems.ITEMS.getEntries().forEach(item -> {
            if (item.get() instanceof ShortBowItem) {
                ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)pull, (ItemPropertyFunction)shortBowPull);
            } else {
                ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)pull, (ItemPropertyFunction)bowPull);
            }
            ItemProperties.register((Item)((Item)item.get()), (ResourceLocation)pulling, (ItemPropertyFunction)bowPulling);
        });
    }

    public static void registerFishingPoleProperties() {
        ResourceLocation cast = ResourceLocation.withDefaultNamespace((String)"cast");
        ClampedItemPropertyFunction function = (itemStack, level, living, speed) -> {
            boolean flag1;
            if (living == null) {
                return 0.0f;
            }
            boolean flag = living.getMainHandItem() == itemStack;
            boolean bl = flag1 = living.getOffhandItem() == itemStack;
            if (living.getMainHandItem().getItem() instanceof FishingRodItem) {
                flag1 = false;
            }
            return (flag || flag1) && living instanceof Player && ((Player)living).fishing != null ? 1.0f : 0.0f;
        };
        FishingPoleItems.ITEMS.getEntries().forEach(pole -> ItemProperties.register((Item)((Item)pole.get()), (ResourceLocation)cast, (ItemPropertyFunction)function));
    }

    public static void registerWaystoneRenderers(EntityRenderersEvent.RegisterRenderers event) {
        if (!WaystonesHelper.IS_LOADED) {
            return;
        }
        event.registerBlockEntityRenderer(WaystonesHelper.PYLON_ENTITY.get(), context -> new GeoBlockRenderer<PylonBlock.BEntity>((GeoModel)new PylonModel()){

            public void defaultRender(PoseStack poseStack, PylonBlock.BEntity animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
                if (animatable.isBase) {
                    super.defaultRender(poseStack, (GeoAnimatable)animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
                }
            }
        });
    }
}

