/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.gui.ClickableArea;
import org.confluence.mod.client.gui.GuiSprite;
import org.confluence.mod.client.handler.bestiary.ClientBestiary;
import org.confluence.mod.client.handler.bestiary.ClientBestiaryEntry;
import org.confluence.mod.client.handler.bestiary.FilterEntry;
import org.confluence.mod.integration.jei.JeiHelper;
import org.jetbrains.annotations.Nullable;

public class BestiaryScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = Confluence.asResource("bestiary/background");
    private static final ResourceLocation FILTERS = Confluence.asResource("bestiary/filters");
    private static final int textureW = 512;
    private static final int textureH = 256;
    private static final int imageWidth = 220;
    private static final int imageHeight = 230;
    private static final int renderedEntryX = 8;
    private static final int renderedEntryY = 10;
    private final ClientBestiary bestiary;
    private int topPos;
    private int leftPos;
    private int maxPage;
    private int page;
    private Iterable<ClientBestiaryEntry> renderedEntries = List.of();
    private Collection<ClientBestiaryEntry> entries = List.of();
    @Nullable
    private ClientBestiaryEntry showedEntry;
    private GuiSprite slider;
    private boolean searchBoxOpened = false;
    private GuiSprite closedSearchBox;
    private GuiSprite openedSearchBox;
    private ClickableArea editBoxArea;
    private ClickableArea searchButtonArea;
    private ClickableArea closeSearchBoxArea;
    private EditBox editBox;
    private boolean filterOpened = false;
    private int filterMaxPage;
    private int filterPage;
    private Iterable<FilterEntry> renderedFilters = List.of();
    private GuiSprite closedFilter;
    private GuiSprite openedFilter;
    private ClickableArea closeFilterArea;
    private boolean sortOpened = false;
    private GuiSprite closedSort;
    private GuiSprite openedSortTop;
    private ClickableArea closeSortArea;
    private ClickableArea reverseSortArea;
    private GuiSprite incSort;
    private GuiSprite decSort;
    private EnumMap<ClientBestiary.SortType, GuiSprite> sortSelections;
    private GuiSprite selectedSort;
    private GuiSprite openedSortBottom;
    private int descPage = 0;
    private Iterable<FormattedCharSequence> renderedDescs = List.of();
    private boolean showingName;

    public BestiaryScreen() {
        super((Component)Component.empty());
        this.bestiary = ClientBestiary.getInstance();
    }

    protected void init() {
        this.leftPos = (this.width - 220) / 2;
        this.topPos = (this.height - 230) / 2;
        this.entries = this.bestiary.getSortedEntries();
        for (ClientBestiaryEntry entry : this.entries) {
            entry.updateUnlockedProgress((Level)this.getMinecraft().level);
        }
        this.updateRenderedEntries(0);
        this.slider = new GuiSprite(BACKGROUND, 512, 256, 221, 37, 7, 15).setX(this.leftPos + 153);
        int searchBoxX = this.leftPos + 220;
        int searchBoxY = this.topPos;
        this.closedSearchBox = new GuiSprite(BACKGROUND, 512, 256, 257, 0, 13, 16).setPos(searchBoxX, searchBoxY).setHovered(new GuiSprite(BACKGROUND, 512, 256, 257, 34, 13, 16).setPos(searchBoxX, searchBoxY));
        this.openedSearchBox = new GuiSprite(BACKGROUND, 512, 256, 285, 0, 72, 16).setPos(searchBoxX, searchBoxY);
        this.editBoxArea = new ClickableArea(49, 16).setPos(searchBoxX, searchBoxY);
        this.searchButtonArea = new ClickableArea(13, 16).setPos(this.editBoxArea.getEndX(), searchBoxY).setHovered(new GuiSprite(BACKGROUND, 512, 256, 358, 0, 13, 16).setPos(this.editBoxArea.getEndX(), searchBoxY));
        this.closeSearchBoxArea = new ClickableArea(9, 16).setPos(this.searchButtonArea.getEndX(), searchBoxY).setHovered(new GuiSprite(BACKGROUND, 512, 256, 372, 0, 10, 16).setPos(this.searchButtonArea.getEndX(), searchBoxY));
        this.editBox = new EditBox(this.font, searchBoxX + 1, searchBoxY + 2, 48, 9, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.editBox);
        this.editBox.setBordered(false);
        int filterX = this.leftPos + 220;
        int filterY = this.topPos + 17;
        this.filterMaxPage = this.bestiary.getFilterEntries().size() / 28;
        this.filterPage = 0;
        this.renderedFilters = Iterables.limit(this.bestiary.getFilterEntries(), (int)28);
        this.closedFilter = new GuiSprite(BACKGROUND, 512, 256, 257, 17, 13, 16).setPos(filterX, filterY);
        this.closedFilter.setHovered(new GuiSprite(BACKGROUND, 512, 256, 257, 51, 13, 16).setPos(this.closedFilter.getX(), this.closedFilter.getY()));
        this.openedFilter = new GuiSprite(BACKGROUND, 512, 256, 285, 17, 72, 136).setPos(filterX, filterY);
        this.closeFilterArea = new ClickableArea(10, 13);
        this.closeFilterArea.setPos(this.openedFilter.getEndX() - this.closeFilterArea.getW(), this.openedFilter.getY());
        this.closeFilterArea.setHovered(new GuiSprite(BACKGROUND, 512, 256, 358, 17, 10, 14).setPos(this.closeFilterArea.getX(), this.closeFilterArea.getY()));
        this.closedSort = new GuiSprite(BACKGROUND, 512, 256, 271, 0, 13, 16);
        this.closedSort.setPos(this.leftPos - this.closedSort.getW(), this.topPos).setHovered(new GuiSprite(BACKGROUND, 512, 256, 271, 34, 13, 16).setPos(this.closedSort.getX(), this.closedSort.getY()));
        int sortWidth = 72;
        this.openedSortTop = new GuiSprite(BACKGROUND, 512, 256, 285, 202, sortWidth, 12).setPos(this.leftPos - sortWidth, this.topPos);
        this.closeSortArea = new ClickableArea(10, 12).setPos(this.openedSortTop.getX(), this.openedSortTop.getY());
        this.closeSortArea.setHovered(new GuiSprite(BACKGROUND, 512, 256, 248, 202, 10, 12).setPos(this.closeSortArea.getX(), this.closeSortArea.getY()));
        this.reverseSortArea = new ClickableArea(12, 12).setPos(this.closeSortArea.getEndX(), this.openedSortTop.getY());
        this.incSort = new GuiSprite(BACKGROUND, 512, 256, 272, 202, 12, 12).setPos(this.reverseSortArea.getX(), this.reverseSortArea.getY());
        this.incSort.setHovered(new GuiSprite(BACKGROUND, 512, 256, 259, 202, 12, 12).setPos(this.incSort.getX(), this.incSort.getY()));
        this.decSort = new GuiSprite(BACKGROUND, 512, 256, 272, 215, 12, 12).setPos(this.reverseSortArea.getX(), this.reverseSortArea.getY());
        this.decSort.setHovered(new GuiSprite(BACKGROUND, 512, 256, 259, 215, 12, 12).setPos(this.decSort.getX(), this.decSort.getY()));
        this.sortSelections = new EnumMap(ClientBestiary.SortType.class);
        int selectionY = this.openedSortTop.getEndY();
        for (ClientBestiary.SortType sortType : ClientBestiary.SortType.values()) {
            GuiSprite sprite = new GuiSprite(BACKGROUND, 512, 256, 285, 215, sortWidth, 13).setPos(this.openedSortTop.getX(), selectionY);
            this.sortSelections.put(sortType, sprite);
            selectionY += sprite.getH();
        }
        this.selectedSort = new GuiSprite(BACKGROUND, 512, 256, 285, 239, sortWidth, 13);
        this.openedSortBottom = new GuiSprite(BACKGROUND, 512, 256, 285, 229, sortWidth, 9).setPos(this.openedSortTop.getX(), selectionY);
    }

    protected void rebuildWidgets() {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (mouseX >= (double)(this.leftPos + 8) && mouseX < (double)(this.leftPos + 141 + 8) && mouseY >= (double)(this.topPos + 10) && mouseY < (double)(this.topPos + 211 + 10)) {
            int lastPage = this.page;
            this.updateRenderedEntries(this.page + Mth.sign((double)(-scrollY)));
            return lastPage != this.page;
        }
        if (this.openedFilter.isHovered(mouseX, mouseY)) {
            int lastPage = this.filterPage;
            this.filterPage = Mth.clamp((int)(this.filterPage + Mth.sign((double)(-scrollY))), (int)0, (int)this.filterMaxPage);
            if (lastPage != this.filterPage) {
                this.renderedFilters = this.filterPage == 0 ? Iterables.limit(this.bestiary.getFilterEntries(), (int)28) : Iterables.limit((Iterable)Iterables.skip(this.bestiary.getFilterEntries(), (int)(this.filterPage * 28)), (int)28);
                return true;
            }
        } else if (this.showedEntry != null && mouseX >= (double)(this.leftPos + 164) && mouseX < (double)(this.leftPos + 212) && mouseY >= (double)(this.topPos + 116) && mouseY < (double)(this.topPos + 221)) {
            int lastPage = this.descPage;
            Component desc = this.showedEntry.getDescription();
            if (this.font.width((FormattedText)desc) > 48) {
                List split = this.font.split((FormattedText)desc, 48);
                int filters = this.showedEntry.getFilters().size();
                int filterLines = filters % 3 == 0 ? filters / 16 : filters / 16 + 1;
                Objects.requireNonNull(this.font);
                int limitSize = (105 - filterLines * 16) / 9;
                this.descPage = Mth.clamp((int)(this.descPage + Mth.sign((double)(-scrollY))), (int)0, (int)Math.max(split.size() - limitSize, 0));
                this.renderedDescs = this.descPage == 0 ? Iterables.limit((Iterable)split, (int)limitSize) : Iterables.limit((Iterable)Iterables.skip((Iterable)split, (int)this.descPage), (int)limitSize);
            } else {
                this.descPage = 0;
                this.renderedDescs = List.of(desc.getVisualOrderText());
            }
            return lastPage != this.descPage;
        }
        return false;
    }

    private void updateRenderedEntries(int setPage) {
        if (this.entries.size() > 24) {
            this.maxPage = this.entries.size() / 24;
            this.page = Mth.clamp((int)setPage, (int)0, (int)this.maxPage);
            this.renderedEntries = this.page == 0 ? Iterables.limit(this.entries, (int)24) : Iterables.limit((Iterable)Iterables.skip(this.entries, (int)(this.page * 24)), (int)24);
        } else {
            this.maxPage = 0;
            this.page = 0;
            this.renderedEntries = Iterables.limit(this.entries, (int)24);
        }
    }

    private void resetRenderedEntries() {
        this.entries = this.bestiary.getSortedEntries();
        this.updateRenderedEntries(0);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = this.leftPos + 8;
        int y = this.topPos + 10;
        for (ClientBestiaryEntry clientBestiaryEntry : this.renderedEntries) {
            if (mouseX >= (double)x && mouseX < (double)(x + 36) && mouseY >= (double)y && mouseY < (double)(y + 36)) {
                if (clientBestiaryEntry.isLocked()) {
                    return false;
                }
                this.showedEntry = clientBestiaryEntry;
                this.descPage = 0;
                Component desc = clientBestiaryEntry.getDescription();
                if (this.font.width((FormattedText)desc) > 48) {
                    int filters = this.showedEntry.getFilters().size();
                    int filterLines = filters % 3 == 0 ? filters / 16 : filters / 16 + 1;
                    Objects.requireNonNull(this.font);
                    int limitSize = (105 - filterLines * 16) / 9;
                    this.renderedDescs = Iterables.limit((Iterable)this.font.split((FormattedText)desc, 48), (int)limitSize);
                } else {
                    this.renderedDescs = List.of(desc.getVisualOrderText());
                }
                return true;
            }
            if ((x += 36) < this.leftPos + 8 + 144) continue;
            x = this.leftPos + 8;
            y += 36;
        }
        if (this.searchBoxOpened) {
            if (this.editBoxArea.isHovered(mouseX, mouseY)) {
                this.setFocused((GuiEventListener)this.editBox);
                return true;
            }
            if (this.searchButtonArea.isHovered(mouseX, mouseY)) {
                this.entries = this.bestiary.search(this.editBox.getValue().trim());
                this.updateRenderedEntries(0);
                return true;
            }
            if (this.closeSearchBoxArea.isHovered(mouseX, mouseY)) {
                this.searchBoxOpened = false;
                this.editBox.setVisible(false);
                return true;
            }
        } else if (this.closedSearchBox.isHovered(mouseX, mouseY)) {
            this.searchBoxOpened = true;
            this.editBox.setVisible(true);
            return true;
        }
        if (this.editBox.isFocused()) {
            this.setFocused(null);
            if (this.editBox.getValue().trim().isEmpty()) {
                this.resetRenderedEntries();
            }
        }
        if (this.filterOpened) {
            if (this.closeFilterArea.isHovered(mouseX, mouseY)) {
                this.filterOpened = false;
                return true;
            }
            x = this.openedFilter.getX();
            y = this.openedFilter.getY() + 15;
            for (FilterEntry filterEntry : this.renderedFilters) {
                if (mouseX >= (double)x && mouseX < (double)(x + 16) && mouseY >= (double)y && mouseY < (double)(y + 16)) {
                    this.bestiary.toggleFilter(filterEntry);
                    this.resetRenderedEntries();
                    return true;
                }
                if ((x += 16) < this.openedFilter.getX() + 64) continue;
                x = this.openedFilter.getX();
                y += 16;
            }
        } else if (this.closedFilter.isHovered(mouseX, mouseY)) {
            this.filterOpened = true;
            return true;
        }
        if (this.sortOpened) {
            if (this.closeSortArea.isHovered(mouseX, mouseY)) {
                this.sortOpened = false;
                return true;
            }
            if (this.reverseSortArea.isHovered(mouseX, mouseY)) {
                this.bestiary.setSortType(this.bestiary.getSortType(), !this.bestiary.isSortReversed());
                this.resetRenderedEntries();
                return true;
            }
            for (Map.Entry entry : this.sortSelections.entrySet()) {
                if (!((GuiSprite)entry.getValue()).isHovered(mouseX, mouseY)) continue;
                this.bestiary.setSortType((ClientBestiary.SortType)((Object)entry.getKey()), this.bestiary.isSortReversed());
                this.resetRenderedEntries();
                return true;
            }
        } else if (this.closedSort.isHovered(mouseX, mouseY)) {
            this.sortOpened = true;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.showingName && this.showedEntry != null && JeiHelper.handleShowUses(keyCode, scanCode, this.showedEntry.getRenderedEntity((Level)this.getMinecraft().level).getPickResult())) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blitSprite(BACKGROUND, 512, 256, 0, 0, this.leftPos, this.topPos, 220, 230);
        int x1 = this.leftPos + 8;
        int y1 = this.topPos + 10;
        for (ClientBestiaryEntry clientBestiaryEntry : this.renderedEntries) {
            guiGraphics.blitSprite(BACKGROUND, 512, 256, 220, 0, x1, y1, 36, 36);
            if (clientBestiaryEntry.isLocked()) {
                this.renderFilter(guiGraphics, FilterEntry.UNKNOWN, x1, y1, 36, 36);
            } else {
                LivingEntity living = clientBestiaryEntry.getRenderedEntity((Level)this.getMinecraft().level);
                float size = (float)Math.max(living.getBoundingBox().getXsize(), living.getBoundingBox().getYsize());
                float factor = 2.0f / size;
                int scale = Mth.ceil((float)(10.0f * factor));
                float yOffset = 0.3f / factor;
                InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)x1, (int)y1, (int)(x1 + 36), (int)(y1 + 36), (int)scale, (float)yOffset, (float)mouseX, (float)mouseY, (LivingEntity)living);
            }
            if ((x1 += 35) < this.leftPos + 8 + 140) continue;
            x1 = this.leftPos + 8;
            y1 += 35;
        }
        if (this.maxPage > 0) {
            this.slider.setY(this.topPos + Mth.lerpInt((float)((float)this.page / (float)this.maxPage), (int)6, (int)(222 - this.slider.getH())));
            this.slider.render(guiGraphics);
        }
        if (this.searchBoxOpened) {
            this.openedSearchBox.render(guiGraphics);
            this.searchButtonArea.renderHovered(guiGraphics, mouseX, mouseY);
            this.closeSearchBoxArea.renderHovered(guiGraphics, mouseX, mouseY);
        } else {
            this.closedSearchBox.renderSelfAndHovered(guiGraphics, mouseX, mouseY);
        }
        if (this.filterOpened) {
            this.openedFilter.render(guiGraphics);
            this.closeFilterArea.renderHovered(guiGraphics, mouseX, mouseY);
            x1 = this.openedFilter.getX();
            y1 = this.openedFilter.getY() + 15;
            for (FilterEntry filterEntry : this.renderedFilters) {
                boolean enabled = this.bestiary.isFilterEnabled(filterEntry);
                if (!enabled) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                }
                this.renderFilter(guiGraphics, filterEntry, x1, y1, 16, 16);
                if (!enabled) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                if ((x1 += 16) < this.openedFilter.getX() + 64) continue;
                x1 = this.openedFilter.getX();
                y1 += 16;
            }
        } else {
            this.closedFilter.renderSelfAndHovered(guiGraphics, mouseX, mouseY);
        }
        if (this.sortOpened) {
            this.openedSortTop.render(guiGraphics);
            this.closeSortArea.renderHovered(guiGraphics, mouseX, mouseY);
            if (this.bestiary.isSortReversed()) {
                this.decSort.renderSelfAndHovered(guiGraphics, mouseX, mouseY);
            } else {
                this.incSort.renderSelfAndHovered(guiGraphics, mouseX, mouseY);
            }
            for (Map.Entry entry : this.sortSelections.entrySet()) {
                GuiSprite sprite = (GuiSprite)entry.getValue();
                if (entry.getKey() == this.bestiary.getSortType()) {
                    this.selectedSort.setPos(sprite.getX(), sprite.getY()).render(guiGraphics);
                } else {
                    sprite.render(guiGraphics);
                }
                Component name = ((ClientBestiary.SortType)((Object)entry.getKey())).getTranslatedName();
                int n = sprite.getX() + 6 + (sprite.getW() - 6 - this.font.width((FormattedText)name)) / 2;
                int n2 = sprite.getY();
                int n3 = sprite.getH();
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, name, n, n2 + (n3 - 9) / 2, 0xFFFFFF);
            }
            this.openedSortBottom.render(guiGraphics);
        } else {
            this.closedSort.renderSelfAndHovered(guiGraphics, mouseX, mouseY);
        }
        if (this.showedEntry != null) {
            float progress = this.showedEntry.getUnlockedProgress();
            PoseStack poseStack = guiGraphics.pose();
            x1 = this.leftPos + 164;
            y1 = this.topPos + 10;
            guiGraphics.blitSprite(this.showedEntry.getBackground(), 48, 48, 0, 0, x1, y1, 48, 48);
            LivingEntity living = this.showedEntry.getRenderedEntity((Level)this.getMinecraft().level);
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)x1, (int)y1, (int)(x1 + 48), (int)(y1 + 48), (int)20, (float)0.3f, (float)mouseX, (float)mouseY, (LivingEntity)living);
            poseStack.pushPose();
            poseStack.translate(0.0f, 0.0f, 180.0f);
            guiGraphics.blitSprite(BACKGROUND, 512, 256, 221, 53, x1, y1, 23, 7);
            for (int i = 0; i < this.showedEntry.getRarity(); ++i) {
                if (i == 0) {
                    guiGraphics.blitSprite(BACKGROUND, 512, 256, 222, 61, x1 + 1, y1 + 1, 5, 5);
                    continue;
                }
                guiGraphics.blitSprite(BACKGROUND, 512, 256, 227, 61, x1 + 2 + i * 4, y1 + 1, 4, 5);
            }
            poseStack.popPose();
            boolean bl = this.showingName = mouseX >= x1 && mouseX < x1 + 48 && mouseY >= y1 && mouseY < y1 + 48;
            if (this.showingName) {
                guiGraphics.renderTooltip(this.font, this.showedEntry.getDisplayName(), mouseX, mouseY);
            }
            Objects.requireNonNull(this.font);
            float lineHeight = 9.0f * 0.8f;
            this.renderScaledString(guiGraphics, poseStack, Integer.toString(this.showedEntry.killedByCount), this.leftPos + 212 - 1, this.topPos + 73, lineHeight);
            boolean p20 = progress >= 0.2f;
            x1 = this.leftPos + 187 - 1;
            y1 = this.topPos + 84 - 1;
            int x2 = this.leftPos + 212 - 1;
            int y2 = this.topPos + 95 - 1;
            this.renderScaledString(guiGraphics, poseStack, p20 ? ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.showedEntry.maxHealth) : "?", x1, y1, lineHeight);
            this.renderScaledString(guiGraphics, poseStack, p20 ? ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.showedEntry.knockbackResistance) : "?", x2, y1, lineHeight);
            this.renderScaledString(guiGraphics, poseStack, p20 ? ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.showedEntry.attackDamage) : "?", x1, y2, lineHeight);
            this.renderScaledString(guiGraphics, poseStack, p20 ? ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(this.showedEntry.armor) : "?", x2, y2, lineHeight);
            x1 = this.leftPos + 174 - 1;
            y1 = this.topPos + 109;
            for (Integer count : this.showedEntry.getCoins().platinum2Copper()) {
                this.renderScaledString(guiGraphics, poseStack, p20 ? count.toString() : "?", x1, y1, lineHeight);
                x1 += 13;
            }
            x1 = this.leftPos + 164;
            y1 = this.topPos + 116;
            x2 = x1 + 48;
            for (FilterEntry filter : this.showedEntry.getFilters()) {
                this.renderFilter(guiGraphics, filter, x1, y1, 16, 16);
                if (mouseX >= x1 && mouseX < x1 + 16 && mouseY >= y1 && mouseY < y1 + 16) {
                    guiGraphics.renderTooltip(this.font, filter.tooltip(), Optional.empty(), mouseX, mouseY);
                }
                if ((x1 += 16) < x2) continue;
                x1 = this.leftPos + 164;
                y1 += 16;
            }
            if (p20) {
                x1 = this.leftPos + 164;
                if (!this.showedEntry.getFilters().isEmpty()) {
                    y1 += 16;
                }
                for (FormattedCharSequence desc : this.renderedDescs) {
                    guiGraphics.drawString(this.font, desc, x1, y1, 0xFFFFFF);
                    Objects.requireNonNull(this.font);
                    y1 += 9;
                }
            }
        }
    }

    private void renderFilter(GuiGraphics guiGraphics, FilterEntry filter, int x, int y, int alignX, int alignY) {
        RenderSystem.enableBlend();
        ResourceLocation sprite = filter.sprite == null ? FILTERS : filter.sprite;
        guiGraphics.blitSprite(sprite, 256, 256, filter.u(), filter.v(), x + (alignX - filter.w()) / 2, y + (alignY - filter.h()) / 2, filter.w(), filter.h());
        RenderSystem.disableBlend();
    }

    private void renderScaledString(GuiGraphics guiGraphics, PoseStack pose, String text, int x, int y, float lineHeight) {
        float scale = text.length() <= 2 ? 0.8f : (1.0f - (float)(text.length() - 2) * 0.1f) * 0.8f;
        pose.pushPose();
        pose.translate((float)x - (float)this.font.width(text) * scale, (float)y - lineHeight, 0.0f);
        pose.scale(scale, scale, 1.0f);
        guiGraphics.drawString(this.font, text, 0, 0, 0xFFFFFF);
        pose.popPose();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

