/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.confluence.mod.network.c2s.ApplySelectionPacketC2S;
import org.confluence.mod.network.s2c.OpenSelectionsScreenPacketS2C;
import org.jetbrains.annotations.NotNull;

public class SelectionsScreen
extends Screen {
    private static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));
    private static final int INTERVAL = 8;
    private final Component[] selections;
    private final boolean[] enables;
    private int buttonWidth;
    private int buttonHeight;
    private int top;
    private int left;

    public SelectionsScreen(Component[] selections, boolean[] enables) {
        super((Component)Component.empty());
        this.selections = selections;
        this.enables = enables;
    }

    protected void init() {
        this.buttonWidth = 200;
        this.buttonHeight = 20;
        this.top = (this.height - ((this.selections.length - 1) * (this.buttonHeight + 8) + this.buttonHeight)) / 2;
        this.left = (this.width - this.buttonWidth) / 2;
        int localTop = this.top;
        for (int i = 0; i < this.enables.length; ++i) {
            int y = localTop + i * this.buttonHeight;
            int index = i;
            ImageButton widget = new ImageButton(this.left, y, this.buttonWidth, this.buttonHeight, SPRITES, button -> {
                ApplySelectionPacketC2S.sendToServer((byte)index);
                Minecraft.getInstance().setScreen(null);
            });
            widget.active = this.enables[i];
            this.addRenderableWidget((GuiEventListener)widget);
            localTop += 8;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int localTop = this.top;
        for (int i = 0; i < this.selections.length; ++i) {
            int y = localTop + i * this.buttonHeight;
            AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)this.font, (Component)this.selections[i], (int)this.left, (int)y, (int)(this.left + this.buttonWidth), (int)(y + this.buttonHeight), (int)0xFFFFFF);
            localTop += 8;
        }
    }

    public void renderBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public static void handlePacket(OpenSelectionsScreenPacketS2C packet) {
        Minecraft.getInstance().setScreen((Screen)new SelectionsScreen(packet.selections(), packet.enables()));
    }
}

