/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.container;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.TriState;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.item.PaintItems;
import org.confluence.mod.common.init.item.VanityArmorItems;
import org.confluence.mod.common.item.common.BaseDyeItem;
import org.confluence.mod.common.item.paint.PaintItem;
import org.confluence.mod.common.menu.DyeMixMenu;
import org.confluence.mod.network.c2s.DyeMixPacketC2S;
import org.confluence.mod.network.c2s.OpenMenuPacketC2S;

public class DyeMixScreen
extends AbstractContainerScreen<DyeMixMenu> {
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/container/dye_mix.png");
    private EditBox editBox;
    private int rgb = 0;
    private TriState isDye = TriState.DEFAULT;
    private ItemStack stack = ItemStack.EMPTY;

    public DyeMixScreen(DyeMixMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        ((DyeMixMenu)this.menu).registerUpdateListener(() -> {
            ItemStack red = ((DyeMixMenu)this.menu).getSlot(0).getItem();
            ItemStack green = ((DyeMixMenu)this.menu).getSlot(1).getItem();
            ItemStack blue = ((DyeMixMenu)this.menu).getSlot(2).getItem();
            this.isDye = red.getItem().getClass() == green.getItem().getClass() && green.getItem().getClass() == blue.getItem().getClass() ? (red.getItem() instanceof BaseDyeItem ? TriState.TRUE : TriState.FALSE) : TriState.DEFAULT;
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"button.confluence.dye_vat"), button -> {
            LocalPlayer player = this.minecraft.player;
            if (player != null) {
                ItemStack stack = player.containerMenu.getCarried();
                player.containerMenu.setCarried(ItemStack.EMPTY);
                OpenMenuPacketC2S.sendToServer((byte)3, stack);
            }
        }).width(48).pos(this.leftPos + 109, this.topPos + 58).build());
        this.editBox = new EditBox(this.minecraft.font, this.leftPos + 64, this.topPos + 24, 44, 10, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.editBox);
        this.editBox.setMaxLength(6);
        this.editBox.setFilter(value -> {
            if (value.isEmpty()) {
                this.rgb = 0;
                return true;
            }
            try {
                this.rgb = FastColor.ARGB32.opaque((int)Integer.parseInt(value, 16));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        });
        this.editBox.setResponder(value -> {
            if (this.isDye.isTrue()) {
                this.stack = VanityArmorItems.DYE.toStack();
                BaseDyeItem.setRGB(this.stack, this.rgb);
            } else if (this.isDye.isFalse()) {
                this.stack = PaintItems.PAINT.toStack();
                PaintItem.setRGB(this.stack, this.rgb);
            } else {
                this.stack = ItemStack.EMPTY;
            }
        });
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (!this.stack.isEmpty()) {
            int x = this.leftPos + 125;
            int y = this.topPos + 35;
            guiGraphics.renderFakeItem(this.stack, x, y);
            int count = Math.min(Math.min(((DyeMixMenu)this.menu).getSlot(0).getItem().getCount(), ((DyeMixMenu)this.menu).getSlot(1).getItem().getCount()), ((DyeMixMenu)this.menu).getSlot(2).getItem().getCount());
            guiGraphics.renderItemDecorations(this.minecraft.font, this.stack, x, y, Integer.toString(count));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.editBox.isFocused()) {
            this.editBox.keyPressed(keyCode, scanCode, modifiers);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.editBox.isHovered()) {
            this.editBox.setFocused(false);
        }
        if (mouseX > (double)(this.leftPos + 125) && mouseX < (double)(this.leftPos + 141) && mouseY > (double)(this.topPos + 35) && mouseY < (double)(this.topPos + 51)) {
            ItemStack carried = ((DyeMixMenu)this.menu).getCarried();
            if (!this.stack.isEmpty() && (carried.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)carried, (ItemStack)this.stack) && carried.getCount() < carried.getMaxStackSize())) {
                DyeMixPacketC2S.sendToServer(this.stack);
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }
}

