/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.container;

import com.google.common.collect.EvictingQueue;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.prefix.PrefixComponent;
import org.confluence.mod.common.component.prefix.PrefixType;
import org.confluence.mod.common.menu.NPCReforgeMenu;
import org.confluence.mod.util.Coins;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;
import org.confluence.terraentity.entity.ai.keyframe.animation.KeyframeAnimation;

public class NPCReforgeScreen
extends AbstractContainerScreen<NPCReforgeMenu> {
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/container/reforge.png");
    private boolean buttonClicked = false;
    private final EvictingQueue<Component> prefixBefore = EvictingQueue.create((int)5);
    int clickTime = 500;
    KeyframeAnimation interpolator;

    public NPCReforgeScreen(NPCReforgeMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND, this.leftPos, this.topPos + 19, 0, 0, this.imageWidth, this.imageHeight);
        int cost = ((NPCReforgeMenu)this.menu).getCost();
        if (cost < 0x3F3F3F3F) {
            Coins coins = PlayerUtils.decodeCoin(cost);
            int x = this.leftPos + 52;
            int y = this.topPos + 1;
            for (Object2IntMap.Entry entry : coins.platinum2CopperEntries()) {
                ItemStack stack = new ItemStack((ItemLike)entry.getKey(), entry.getIntValue());
                guiGraphics.renderItem(stack, x, y);
                guiGraphics.renderItemDecorations(this.font, stack, x, y);
                x += 18;
            }
        }
        if (this.buttonClicked) {
            guiGraphics.blit(BACKGROUND, this.leftPos + 120, this.topPos + 43, 177, 0, 18, 18);
        }
        int x = this.leftPos + 61;
        int y = this.topPos + 21;
        for (Component component : this.prefixBefore) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, component, x, y += 9, -1);
        }
    }

    protected void containerTick() {
        ++this.clickTime;
    }

    protected void init() {
        super.init();
        this.interpolator = KeyframeAnimation.builder().addKeyframe(0.0, 0.0).addKeyframe(15.0, 55.0).addKeyframe(20.0, 60.0).addKeyframe(40.0, 60.0).addKeyframe(45.0, 65.0).addKeyframe(60.0, 100.0).build();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        PrefixComponent prefix;
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
        ItemStack itemStack = ((NPCReforgeMenu)this.menu).getReforgeItem();
        if (!itemStack.isEmpty() && (prefix = PrefixUtils.getPrefix(itemStack)) != null && this.clickTime > 0 && this.clickTime < 60) {
            double v = this.interpolator.cal((double)((float)this.clickTime + pPartialTick));
            pGuiGraphics.pose().pushPose();
            MutableComponent component = prefix.getName().append(" ").append((Component)Component.translatable((String)itemStack.getItem().getDescriptionId()));
            ModRarity rarity = ModRarity.getRarity((ItemStack)itemStack);
            if (rarity != null) {
                component.withColor(rarity.color());
            }
            pGuiGraphics.pose().translate(0.0, -v * 0.5, 0.0);
            float f = (float)this.clickTime / 60.0f;
            f = f * (1.0f - f) * 4.0f;
            f = Math.min(1.0f, f);
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, f);
            pGuiGraphics.drawString(this.font, (Component)component, this.leftPos + 12, this.topPos + 40, -1);
            pGuiGraphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            pGuiGraphics.pose().popPose();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX >= (double)(this.leftPos + 120) && mouseX <= (double)(this.leftPos + 138) && mouseY >= (double)(this.topPos + 43) && mouseY <= (double)(this.topPos + 62) && ((NPCReforgeMenu)this.menu).clickMenuButton((Player)this.minecraft.player, 0)) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.SMITHING_TABLE_USE, (float)(this.minecraft.level.random.nextFloat() * 0.1f + 0.9f)));
            this.minecraft.gameMode.handleInventoryButtonClick(((NPCReforgeMenu)this.menu).containerId, 0);
            ItemStack itemStack = ((NPCReforgeMenu)this.menu).getReforgeItem();
            PrefixComponent prefix = PrefixUtils.getPrefix(itemStack);
            if (prefix != null && prefix.type() != PrefixType.UNKNOWN) {
                MutableComponent component = prefix.getName();
                ModRarity rarity = ModRarity.getRarity((ItemStack)itemStack);
                if (rarity != null) {
                    component.withColor(rarity.color());
                }
                this.prefixBefore.add((Object)component);
            }
            this.buttonClicked = true;
            this.clickTime = 0;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.buttonClicked = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }
}

