/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.gui.hud;

import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.common.TranslatableEnum;
import org.confluence.lib.util.LibClientUtils;
import org.confluence.mod.client.ClientConfigs;
import org.confluence.mod.common.item.common.EverBeneficialItem;
import org.confluence.mod.util.ClientUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TerraStyleHealthHud
implements LayeredDraw.Layer {
    private static final int[] HEALTH = new int[]{11219230, 6099386, 4303290, 3654712, 15652150};
    private static final int[] HEALTH_LOW = new int[]{11214685, 10306732, 1243101, 2075519, 16233995};
    private static final int[] HEALTH_HIGH = new int[]{0xFFB5B5, 14084075, 12439248, 14085805, 15725774};

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (!ClientConfigs.terraStyleHealth) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.options.hideGui || !LibClientUtils.shouldDrawSurvivalElements((Minecraft)minecraft)) {
            return;
        }
        LibClientUtils.setupOverlayRenderState((boolean)true, (boolean)false);
        minecraft.getProfiler().push("terra_style_hud");
        ClientConfigs.healthStyle.render(guiGraphics, minecraft);
        minecraft.getProfiler().pop();
    }

    public static enum Health implements TranslatableEnum
    {
        LEGACY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                int widthHealth = guiGraphics.guiWidth() - 128 + ClientConfigs.healthOffsetX;
                int heightHealth = 4 + ClientConfigs.healthOffsetY;
                float maxHealth = 0.0f;
                float currentHealth = 0.0f;
                int heartBuff = 0;
                int lifeFruitHealth = 0;
                float absorptionHealth = 0.0f;
                LocalPlayer player = minecraft.player;
                if (player != null) {
                    heartBuff = player.getTicksFrozen() >= 140 ? 1 : heartBuff;
                    heartBuff = player.hasEffect(MobEffects.WITHER) ? 2 : heartBuff;
                    heartBuff = player.hasEffect(MobEffects.POISON) ? 3 : heartBuff;
                    absorptionHealth = player.getAbsorptionAmount();
                    maxHealth = player.getMaxHealth();
                    currentHealth = player.getHealth();
                    AttributeModifier modifier = player.getAttribute(Attributes.MAX_HEALTH).getModifier(EverBeneficialItem.LIFE_FRUITS.id());
                    if (modifier != null) {
                        lifeFruitHealth = (int)modifier.amount();
                    }
                }
                int countHeart = (int)((maxHealth - (float)lifeFruitHealth) / 4.0f);
                int countHeartAbsorptionHealth = (int)(absorptionHealth / 4.0f) + ((int)absorptionHealth % 4 == 0 ? 0 : 1);
                int yLine = 4 + (int)(6.0f / (float)((countHeart - 1) / 20 + (countHeartAbsorptionHealth - 1) / 20 + 1));
                int heightToAbsorption = 1.blit(heartBuff, maxHealth, currentHealth, lifeFruitHealth, guiGraphics, widthHealth, heightHealth, 0, yLine);
                1.blit(0, countHeartAbsorptionHealth * 4, absorptionHealth, 0, guiGraphics, widthHealth, heightToAbsorption, 1, yLine);
            }

            private static void blitHeart(GuiGraphics guiGraphics, int type, int typeHeart, float num, int x, int y, int heartBuff) {
                float heartNum = type == 1 ? 5.0f : 4.0f;
                heartBuff = typeHeart == 0 ? heartBuff : 0;
                int heightUV = typeHeart * 17;
                if (num == heartNum) {
                    guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, (type == 1 ? 54 : 44) + heartBuff, heightUV, x, y, 9, 16);
                } else if (num > 0.0f) {
                    float ts = num / heartNum;
                    guiGraphics.pose().pushPose();
                    guiGraphics.pose().translate((float)x + 4.5f * (1.0f - ts), (float)y + 9.0f * (1.0f - ts), 0.0f);
                    guiGraphics.pose().scale(ts, ts, 1.0f);
                    guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, (type == 1 ? 54 : 44) + heartBuff, heightUV, 0, 0, 9, 16);
                    guiGraphics.pose().popPose();
                }
            }

            private static int blit(int heartBuff, float maxHealth, float currentHealth, int lifeFruitHealth, GuiGraphics guiGraphics, int width, int height, int typeHeart, int yLine) {
                heartBuff *= 20;
                int heightUV = typeHeart * 17;
                int countHeart = (int)((maxHealth - (float)lifeFruitHealth) / 4.0f);
                int blitY = 0;
                FloatArrayList heartNumList = 1.getHeartNumList(currentHealth, lifeFruitHealth, countHeart);
                for (int countToBlit = 0; countToBlit < countHeart; ++countToBlit) {
                    int blitXFirst;
                    int countLine = countToBlit / 10;
                    blitY = yLine * countLine;
                    int blitX = countToBlit * 10 - countLine * 100;
                    int n = blitXFirst = countHeart / 10 == 0 ? 100 - (countHeart - countHeart / 10 * 10) * 10 : 0;
                    if (countToBlit % 10 == 0) {
                        guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 0, heightUV, width + blitX - 1 + blitXFirst, height + blitY, 1, 16);
                        if (countToBlit + 1 == countHeart) {
                            guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 13, heightUV, width + blitX - 3 + blitXFirst, height + blitY, 17, 16);
                        } else {
                            guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 2, heightUV, width + blitX + blitXFirst, height + blitY, 10, 16);
                        }
                    } else if (countToBlit + 1 == countHeart) {
                        guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 13, heightUV, width + blitX - 3 + blitXFirst, height + blitY, 17, 16);
                    } else if ((countToBlit + 1) % 10 == 0) {
                        guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 31, heightUV, width + blitX + blitXFirst, height + blitY, 12, 16);
                    } else {
                        guiGraphics.blitSprite(ClientUtils.LEGACY_TEXTURE, 128, 128, 2, heightUV, width + blitX + blitXFirst, height + blitY, 10, 16);
                    }
                    int type = countToBlit < lifeFruitHealth ? 1 : 0;
                    1.blitHeart(guiGraphics, type, typeHeart, heartNumList.getFloat(countToBlit), width + blitX + blitXFirst + 1, height + blitY, heartBuff);
                }
                return height + blitY + yLine;
            }

            private static FloatArrayList getHeartNumList(float currentHealth, int lifeFruitHealth, int countHeart) {
                FloatArrayList heartNumList = new FloatArrayList();
                float currentHealthToType = currentHealth;
                for (int i = 0; i < countHeart; ++i) {
                    boolean ifLifeFruit = i < lifeFruitHealth;
                    float heartNum = ifLifeFruit ? 5.0f : 4.0f;
                    if ((currentHealthToType -= heartNum) >= 0.0f) {
                        heartNumList.add(heartNum);
                        continue;
                    }
                    if (currentHealthToType + heartNum >= 0.0f) {
                        heartNumList.add(currentHealthToType + heartNum);
                        continue;
                    }
                    heartNumList.add(0.0f);
                }
                return heartNumList;
            }
        }
        ,
        OVERLAY{

            @Override
            public void render(GuiGraphics guiGraphics, Minecraft minecraft) {
                float maxHealth = 0.0f;
                float currentHealth = 0.0f;
                float absorptionHealth = 0.0f;
                LocalPlayer player = minecraft.player;
                if (player != null) {
                    maxHealth = player.getMaxHealth();
                    currentHealth = player.getHealth();
                    absorptionHealth = player.getAbsorptionAmount();
                }
                int widthHealth = guiGraphics.guiWidth() / 2 - 91 + ClientConfigs.healthOffsetX;
                int heightHealth = guiGraphics.guiHeight() - minecraft.gui.leftHeight + ClientConfigs.healthOffsetY;
                String abHealth = String.format("%.1f", Float.valueOf(absorptionHealth));
                minecraft.gui.leftHeight += 10;
                RandomSource random = RandomSource.create((long)114514L);
                ClientUtils.colorDraw(guiGraphics, minecraft, random, ClientUtils.OVERLAY_TEXTURE, HEALTH, HEALTH_HIGH, HEALTH_LOW, maxHealth, currentHealth, widthHealth, heightHealth, 128, 0, true);
                if (absorptionHealth > 0.0f) {
                    guiGraphics.blitSprite(ClientUtils.ICON_0, 128, 16, 0, 0, widthHealth, heightHealth, 81, 9);
                    ClientUtils.drawString(guiGraphics, minecraft.font, abHealth, (float)widthHealth + 41.0f - (float)minecraft.font.width((FormattedText)Component.literal((String)abHealth)) / 2.0f, heightHealth + 1, 6225912);
                }
            }
        };


        public abstract void render(GuiGraphics var1, Minecraft var2);

        public Component getTranslatedName() {
            return Component.translatable((String)("confluence.configuration.healthStyle." + this.name().toLowerCase(Locale.ROOT)));
        }
    }
}

