/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.registries.DeferredItem;
import org.confluence.mod.common.init.item.BowItems;
import org.confluence.mod.common.item.bow.ShortBowItem;
import org.confluence.mod.common.item.bow.TerraBowItem;

public final class ArrowInBowHandler {
    private static final Map<DeferredItem<? extends TerraBowItem>, Vec3> offsets = new HashMap<DeferredItem<? extends TerraBowItem>, Vec3>();

    public static void initAdaptionMap() {
        offsets.put(BowItems.DAEDALUS_STORM_BOW, new Vec3((double)0.365f, (double)0.2f, 0.0));
        offsets.put(BowItems.PLATINUM_SHORT_BOW, new Vec3((double)0.08f, 0.0, 0.0));
    }

    private static float getOffset(float charge, Vec3 off, Item item) {
        float a = 0.0f;
        float b = 0.0f;
        float c = 0.0f;
        if (item instanceof ShortBowItem) {
            return off == null ? a : (float)off.x + a;
        }
        float offset = off == null ? (charge < 0.65f ? 0.23f + a : (charge < 0.9f ? 0.62f + b : 1.0f + c)) : (float)(charge < 0.65f ? (double)0.23f + off.x + (double)a : (charge < 0.9f ? (double)0.62f + off.y + (double)b : 1.0 + off.z + (double)c));
        return offset;
    }

    public static void transform(ItemStack bow, PoseStack poseStack, float charge, ItemDisplayContext displayContext) {
        if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
            Holder it = bow.getItemHolder();
            Vec3 off = offsets.get(it);
            float offset = ArrowInBowHandler.getOffset(charge, off, (Item)it.value());
            poseStack.translate(0.0, 0.2, 0.0);
            if (it.value() instanceof ShortBowItem) {
                poseStack.translate(0.0f, 0.0f, offset);
            } else {
                poseStack.translate(0.0, (double)(-offset) * 0.04, (double)offset * 0.13);
            }
            if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                poseStack.mulPose(Axis.XN.rotationDegrees(90.0f));
            } else {
                poseStack.translate(0.0, -0.12, -0.25);
            }
            poseStack.scale(1.01f, 1.01f, 1.01f);
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND) {
            poseStack.mulPose(Axis.YN.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(20.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(10.0f));
            poseStack.translate(0.1, -0.25, -0.15);
        } else if (displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND) {
            poseStack.mulPose(Axis.YN.rotationDegrees(-90.0f));
            poseStack.mulPose(Axis.ZN.rotationDegrees(20.0f));
            poseStack.mulPose(Axis.XN.rotationDegrees(0.0f));
            poseStack.translate(0.1, -0.3, 0.0);
        }
    }
}

