/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.mixed.IDeathScreen;
import org.confluence.mod.network.s2c.FishingPowerInfoPacketS2C;
import org.confluence.mod.network.s2c.ManaPacketS2C;
import org.confluence.mod.network.s2c.PlayerDeathInfoPacketS2C;
import org.confluence.mod.network.s2c.SecretFlagSyncPacketS2C;
import org.confluence.mod.util.ClientUtils;
import org.confluence.phase_journey.mixed.ILevelRenderer;

public final class ClientPacketHandler {
    private static int maxMana = 20;
    private static float currentMana = 20.0f;
    private static float fishingPower = 0.0f;
    private static boolean echoVisible = false;
    private static long secretFlag = 0L;
    private static boolean sprintable = false;
    private static boolean showSignal = false;

    public static float getCurrentMana() {
        return currentMana;
    }

    public static int getMaxMana() {
        return maxMana;
    }

    public static float getFishingPower() {
        return fishingPower;
    }

    public static boolean hasEchoVisible() {
        return echoVisible;
    }

    public static long getSecretFlag() {
        return secretFlag;
    }

    public static boolean isSprintable() {
        return sprintable;
    }

    public static boolean isShowSignal() {
        return showSignal;
    }

    public static void reset() {
        maxMana = 20;
        currentMana = 20.0f;
        fishingPower = 0.0f;
        echoVisible = false;
        secretFlag = 0L;
        sprintable = false;
        showSignal = false;
    }

    public static void handleMana(ManaPacketS2C packet, Player player) {
        maxMana = packet.maxMana();
        currentMana = packet.currentMana();
        if (currentMana >= (float)maxMana) {
            player.playSound((SoundEvent)ModSoundEvents.COOLDOWN_RECOVERY.get());
        }
    }

    public static void handleFishingPower(FishingPowerInfoPacketS2C packet) {
        fishingPower = packet.value();
    }

    public static void handleVisibility(byte mask, boolean visible) {
        if ((mask & 2) != 0 && echoVisible != visible) {
            ((ILevelRenderer)Minecraft.getInstance().levelRenderer).phase_journey$rebuildAllChunks();
            echoVisible = visible;
        }
        if ((mask & 4) != 0) {
            ClientUtils.postTheConstantEffect(visible);
        }
        if ((mask & 8) != 0) {
            showSignal = visible;
        }
    }

    public static void handleSecretFlag(SecretFlagSyncPacketS2C packet) {
        secretFlag = packet.flag();
        if ((secretFlag & 4L) != 0L) {
            ((ILevelRenderer)Minecraft.getInstance().levelRenderer).phase_journey$rebuildAllChunks();
        }
    }

    public static void handleDeathInfo(PlayerDeathInfoPacketS2C packet, Player player) {
        Screen screen;
        ((LocalPlayer)player).connection.handlePlayerCombatKill(new ClientboundPlayerCombatKillPacket(player.getId(), packet.deathMessage()));
        if (!player.isCreative() && (screen = Minecraft.getInstance().screen) instanceof IDeathScreen) {
            IDeathScreen deathScreen = (IDeathScreen)screen;
            deathScreen.confluence$setDelayTicker(0);
            deathScreen.confluence$setRespawnWaitTime(packet.respawnTime() * 20);
            if (packet.platinum() != 0 || packet.gold() != 0 || packet.silver() != 0 || packet.copper() != 0) {
                MutableComponent component = Component.translatable((String)"info.confluence.drops_money");
                if (packet.platinum() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.platinum", (Object[])new Object[]{packet.platinum()}));
                }
                if (packet.gold() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.gold", (Object[])new Object[]{packet.gold()}));
                }
                if (packet.silver() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.silver", (Object[])new Object[]{packet.silver()}));
                }
                if (packet.copper() > 0) {
                    component.append((Component)Component.translatable((String)"info.confluence.drops_money.copper", (Object[])new Object[]{packet.copper()}));
                }
                deathScreen.confluence$setDropsMoney(component);
            }
        }
    }

    public static void handleSprintable(boolean able) {
        sprintable = able;
    }
}

