/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler;

import java.util.Iterator;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.client.ModKeyBindings;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;
import org.confluence.mod.common.init.item.HookItems;
import org.confluence.mod.network.c2s.HookThrowingPacketC2S;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;
import org.confluence.terra_curio.network.c2s.PlayerJumpPacketC2S;

public final class HookThrowingHandler {
    public static void handle(LocalPlayer player) {
        if (Minecraft.getInstance().isPaused()) {
            return;
        }
        boolean isDown = false;
        while (((KeyMapping)ModKeyBindings.HOOK.get()).consumeClick()) {
            isDown = true;
        }
        if (isDown) {
            HookThrowingPacketC2S.push();
        }
        if (player.isCrouching()) {
            return;
        }
        ItemStack itemStack = ExtraInventory.of((LivingEntity)player).getHook(false);
        CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)itemStack);
        if (tag == null) {
            return;
        }
        ListTag list = tag.getList("hooks", 10);
        Iterator iterator = list.iterator();
        Level level = player.level();
        boolean shouldSync = false;
        while (iterator.hasNext()) {
            int id = ((CompoundTag)iterator.next()).getInt("id");
            Entity entity = level.getEntity(id);
            if (!(entity instanceof AbstractHookEntity)) {
                iterator.remove();
                continue;
            }
            AbstractHookEntity hookEntity = (AbstractHookEntity)entity;
            if (hookEntity.getHookState() != AbstractHookEntity.HookState.HOOKED) continue;
            Input input = player.input;
            if (input.jumping || player.vehicle != null) {
                HookThrowingPacketC2S.pop(id);
                PlayerJumpHandler.multiJump((LocalPlayer)player, (float)1.25f);
                return;
            }
            if (itemStack.getItem() == HookItems.ANTI_GRAVITY_HOOK.get()) {
                double vz;
                double vy;
                float sin;
                double mz;
                double mx = input.leftImpulse;
                float ry = player.getYRot() * ((float)Math.PI / 180);
                float cos = Mth.cos((float)ry);
                double vx = mx * (double)cos + (mz = (double)input.forwardImpulse) * (double)(-(sin = Mth.sin((float)ry)));
                double dist = Math.sqrt(vx * vx + (vy = (double)(-Mth.sin((float)(player.getXRot() * ((float)Math.PI / 180)))) * mz) * vy + (vz = mx * (double)sin + mz * (double)cos) * vz);
                if (dist == 0.0) {
                    player.setDeltaMovement(Vec3.ZERO);
                } else {
                    player.setDeltaMovement(vx / dist * 0.5, vy / dist * 0.5, vz / dist * 0.5);
                }
            } else {
                Vec3 subtract = hookEntity.position().subtract(player.position());
                if (subtract.lengthSqr() < 1.0) {
                    Vec3 motion = player.getDeltaMovement().scale(0.05);
                    player.setDeltaMovement(motion.x, 0.0, motion.z);
                } else {
                    Vec3 motion = subtract.normalize().scale(hookEntity.getPullVelocity());
                    player.setDeltaMovement(player.getDeltaMovement().scale(0.96).add(motion));
                }
            }
            shouldSync = true;
        }
        if (shouldSync) {
            PlayerJumpHandler.reset((boolean)true);
            PacketDistributor.sendToServer((CustomPacketPayload)new PlayerJumpPacketC2S(2, (float)player.getDeltaMovement().y), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

