/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.handler.bestiary;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.xiaohunao.enemybanner.BannerConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.util.LibCodecUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.api.event.bestiary.RegisterCustomBestiaryEntryRendererEvent;
import org.confluence.mod.client.handler.bestiary.FilterEntry;
import org.confluence.mod.common.data.saved.BestiaryEntry;
import org.confluence.mod.common.entity.BestiaryEntryDisplay;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.mixin.accessor.EntityAccessor;

public class ClientBestiaryEntry
extends BestiaryEntry {
    public static final ResourceLocation SURFACE = ClientBestiaryEntry.background("surface");
    public static final ResourceLocation SURFACE_SUN = ClientBestiaryEntry.background("surface_sun");
    public static final ResourceLocation SURFACE_NIGHTTIME = ClientBestiaryEntry.background("surface_nighttime");
    public static final ResourceLocation SURFACE_MOON = ClientBestiaryEntry.background("surface_moon");
    public static final ResourceLocation SURFACE_RAIN = ClientBestiaryEntry.background("surface_rain");
    public static final ResourceLocation SURFACE_NIGHTTIME_RAIN = ClientBestiaryEntry.background("surface_nighttime_rain");
    public static final ResourceLocation GRAVEYARD = ClientBestiaryEntry.background("graveyard");
    public static final ResourceLocation BLOOD_MOON = ClientBestiaryEntry.background("blodd_moon");
    public static final ResourceLocation ECLIPSE = ClientBestiaryEntry.background("eclipse");
    public static final ResourceLocation PUMPKIN_MOON = ClientBestiaryEntry.background("pumpkin_moon");
    public static final ResourceLocation FROST_MOON = ClientBestiaryEntry.background("frost_moon");
    public static final ResourceLocation SKY = ClientBestiaryEntry.background("sky");
    public static final ResourceLocation UNDERGROUND = ClientBestiaryEntry.background("underground");
    public static final ResourceLocation CAVE = ClientBestiaryEntry.background("cave");
    public static final ResourceLocation OCEAN = ClientBestiaryEntry.background("ocean");
    public static final ResourceLocation THE_JUNGLE = ClientBestiaryEntry.background("the_jungle");
    public static final ResourceLocation THE_JUNGLE_SUN = ClientBestiaryEntry.background("the_jungle_sun");
    public static final ResourceLocation UNDERGROUND_JUNGLE = ClientBestiaryEntry.background("underground_jungle");
    public static final ResourceLocation THE_JUNGLE_MOON = ClientBestiaryEntry.background("the_jungle_moon");
    public static final ResourceLocation SNOW = ClientBestiaryEntry.background("snow");
    public static final ResourceLocation SNOW_MOON = ClientBestiaryEntry.background("snow_moon");
    public static final ResourceLocation UNDERGROUND_SNOW = ClientBestiaryEntry.background("underground_snow");
    public static final ResourceLocation BLIZZARD = ClientBestiaryEntry.background("blizzard");
    public static final ResourceLocation GLOWING_MUSHROOM = ClientBestiaryEntry.background("glowing_mushroom");
    public static final ResourceLocation DESERT = ClientBestiaryEntry.background("desert");
    public static final ResourceLocation DESERT_SUN = ClientBestiaryEntry.background("desert_sun");
    public static final ResourceLocation UNDERGROUND_DESERT = ClientBestiaryEntry.background("underground_desert");
    public static final ResourceLocation SANDSTORM = ClientBestiaryEntry.background("underground_desert");
    public static final ResourceLocation THE_NETHER = ClientBestiaryEntry.background("the_nether");
    public static final ResourceLocation MARBLE = ClientBestiaryEntry.background("marble");
    public static final ResourceLocation GRANITE = ClientBestiaryEntry.background("granite");
    public static final ResourceLocation SPIDER_NEST = ClientBestiaryEntry.background("spider_nest");
    public static final ResourceLocation METEOR = ClientBestiaryEntry.background("meteor");
    public static final ResourceLocation THE_CORRUPTION = ClientBestiaryEntry.background("the_corruption");
    public static final ResourceLocation UNDERGROUND_CORRUPTION = ClientBestiaryEntry.background("underground_corruption");
    public static final ResourceLocation CORRUPT_DESERT = ClientBestiaryEntry.background("corrupt_desert");
    public static final ResourceLocation CORRUPT_CAVE_DESERT = ClientBestiaryEntry.background("corrupt_cave_desert");
    public static final ResourceLocation CORRUPT_ICE = ClientBestiaryEntry.background("corrupt_ice");
    public static final ResourceLocation THE_CRIMSON = ClientBestiaryEntry.background("the_crimson");
    public static final ResourceLocation UNDERGROUND_CRIMSON = ClientBestiaryEntry.background("underground_crimson");
    public static final ResourceLocation CRIMSON_DESERT = ClientBestiaryEntry.background("crimson_desert");
    public static final ResourceLocation CRIMSON_CAVE_DESERT = ClientBestiaryEntry.background("crimson_cave_desert");
    public static final ResourceLocation CRIMSON_ICE = ClientBestiaryEntry.background("crimson_ice");
    public static final ResourceLocation THE_HALLOW = ClientBestiaryEntry.background("the_hallow");
    public static final ResourceLocation THE_HALLOW_SUN = ClientBestiaryEntry.background("the_hallow_sun");
    public static final ResourceLocation THE_HALLOW_MOON = ClientBestiaryEntry.background("the_hallow_moon");
    public static final ResourceLocation THE_HALLOW_RAIN = ClientBestiaryEntry.background("the_hallow_rain");
    public static final ResourceLocation UNDERGROUND_HALLOW = ClientBestiaryEntry.background("underground_hallow");
    public static final ResourceLocation HALLOW_DESERT = ClientBestiaryEntry.background("hallow_desert");
    public static final ResourceLocation HALLOW_CAVE_DESERT = ClientBestiaryEntry.background("hallow_cave_desert");
    public static final ResourceLocation HALLOW_ICE = ClientBestiaryEntry.background("hallow_ice");
    public static final ResourceLocation THE_DUNGEON = ClientBestiaryEntry.background("the_dungeon");
    public static final ResourceLocation THE_TEMPLE = ClientBestiaryEntry.background("the_temple");
    public static final ResourceLocation SOLAR_PILLAR = ClientBestiaryEntry.background("solar_pillar");
    public static final ResourceLocation VORTEX_PILLAR = ClientBestiaryEntry.background("vortex_pillar");
    public static final ResourceLocation NEBULA_PILLAR = ClientBestiaryEntry.background("nebula_pillar");
    public static final ResourceLocation STARDUST_PILLAR = ClientBestiaryEntry.background("stardust_pillar");
    public static final Component UNKNOWN = Component.literal((String)"???");
    public static final Codec<ClientBestiaryEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter(BestiaryEntry::getType), (App)Codec.INT.lenientOptionalFieldOf("order", (Object)1000000).forGetter(ClientBestiaryEntry::getOrder), (App)ExtraCodecs.intRange((int)0, (int)5).lenientOptionalFieldOf("rarity", (Object)1).forGetter(ClientBestiaryEntry::getRarity), (App)ResourceLocation.CODEC.lenientOptionalFieldOf("background", (Object)SURFACE).forGetter(ClientBestiaryEntry::getBackground), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("description", (Object)UNKNOWN).forGetter(ClientBestiaryEntry::getDescription), (App)LibCodecUtils.homogenousList(FilterEntry.CODEC, (boolean)false).lenientOptionalFieldOf("filters", List.of()).forGetter(ClientBestiaryEntry::getFilters), (App)TagParser.LENIENT_CODEC.lenientOptionalFieldOf("entity_nbt").forGetter(ClientBestiaryEntry::getEntityNbt)).apply((Applicative)instance, ClientBestiaryEntry::new));
    private final int order;
    private final int rarity;
    private final ResourceLocation background;
    private final Component description;
    private final List<FilterEntry> filters;
    private final Optional<CompoundTag> entityNbt;
    private transient float unlockedProgress = -1.0f;
    private transient Component displayName;
    private transient LivingEntity renderedEntity;

    public ClientBestiaryEntry() {
        this.order = 1000000;
        this.rarity = 1;
        this.background = SURFACE;
        this.description = UNKNOWN;
        this.filters = List.of();
        this.entityNbt = Optional.empty();
    }

    private ClientBestiaryEntry(EntityType<?> type, int order, int rarity, ResourceLocation background, Component description, List<FilterEntry> filters, Optional<CompoundTag> entityNbt) {
        this.type = type;
        this.order = order;
        this.rarity = rarity;
        this.background = background;
        this.description = description;
        this.filters = filters;
        this.entityNbt = entityNbt;
    }

    public int getOrder() {
        return this.order;
    }

    public int getRarity() {
        return this.rarity;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public Component getDescription() {
        return this.description;
    }

    public List<FilterEntry> getFilters() {
        return this.filters;
    }

    public Optional<CompoundTag> getEntityNbt() {
        return this.entityNbt;
    }

    public Component getDisplayName() {
        if (this.displayName == null) {
            this.displayName = Component.translatable((String)this.key);
        }
        return this.displayName;
    }

    public void resetRenderedEntity() {
        this.renderedEntity = null;
    }

    public LivingEntity getRenderedEntity(Level level) {
        if (this.renderedEntity == null && level != null) {
            Entity entity = this.type.create(level);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (RegisterCustomBestiaryEntryRendererEvent.hasRenderer(this.key)) {
                    BestiaryEntryDisplay entity2 = new BestiaryEntryDisplay((EntityType<BestiaryEntryDisplay>)((EntityType)ModEntities.BESTIARY_ENTRY_DISPLAY.get()), level);
                    entity2.setDelegate(this.key, living);
                    this.renderedEntity = entity2;
                } else {
                    this.renderedEntity = living;
                }
                this.entityNbt.ifPresent(nbt -> ((EntityAccessor)this.renderedEntity).callReadAdditionalSaveData((CompoundTag)nbt));
            } else {
                throw new NullPointerException("Failed to create rendered entity from type " + this.key);
            }
        }
        return this.renderedEntity;
    }

    public float getUnlockedProgress() {
        return Mth.clamp((float)this.unlockedProgress, (float)0.0f, (float)1.0f);
    }

    public boolean isLocked() {
        return this.unlockedProgress < -1.0E-5f;
    }

    public boolean unlock() {
        if (this.isLocked()) {
            this.unlockedProgress = 0.0f;
            return true;
        }
        return false;
    }

    public void updateUnlockedProgress(Level level) {
        if (this.isLocked() || this.unlockedProgress >= 1.0f) {
            return;
        }
        LivingEntity living = this.getRenderedEntity(level);
        if (living instanceof Npc || LibUtils.isAnimal((LivingEntity)living) || this.type.is(Tags.EntityTypes.BOSSES)) {
            this.unlockedProgress = 1.0f;
        } else {
            float required = BannerConfig.getBasicKills((String)EntityType.getKey((EntityType)this.type).toString());
            this.unlockedProgress = Mth.clamp((float)((float)this.killedByCount / required), (float)0.0f, (float)1.0f);
        }
    }

    public static ResourceLocation background(String path) {
        return Confluence.asResource("bestiary/background/" + path);
    }

    public static Builder builderc(EntityType<?> type, String key) {
        return new Builder(type, key);
    }

    @Override
    public ClientBestiaryEntry copy() {
        ClientBestiaryEntry entry = new ClientBestiaryEntry(this.type, this.order, this.rarity, this.background, this.description, this.filters, this.entityNbt);
        entry.key = this.key;
        return entry;
    }

    public static class Builder {
        private final EntityType<?> type;
        private final String key;
        private int order = 1000000;
        private int rarity = 1;
        private ResourceLocation background = SURFACE;
        private Component description = UNKNOWN;
        private List<FilterEntry> filters = List.of();
        private CompoundTag entityNbt;

        private Builder(EntityType<?> type, String key) {
            this.type = type;
            this.key = key;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder rarity(int rarity) {
            this.rarity = rarity;
            return this;
        }

        public Builder background(ResourceLocation background) {
            this.background = background;
            return this;
        }

        public Builder description(Component description) {
            this.description = description;
            return this;
        }

        public Builder filters(FilterEntry ... entries) {
            this.filters = Arrays.stream(entries).toList();
            return this;
        }

        public Builder entityNbt(Consumer<CompoundTag> consumer) {
            CompoundTag nbt = new CompoundTag();
            consumer.accept(nbt);
            this.entityNbt = nbt;
            return this;
        }

        public Builder entityNbt(CompoundTag nbt) {
            this.entityNbt = nbt;
            return this;
        }

        public ClientBestiaryEntry build() {
            ClientBestiaryEntry entry = new ClientBestiaryEntry(this.type, this.order, this.rarity, this.background, this.description, this.filters, Optional.ofNullable(this.entityNbt));
            entry.key = this.key;
            return entry;
        }
    }
}

