/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.confluence.mod.client.particle.SimpleTextureSheetParticle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class EctoMistParticle
extends SimpleTextureSheetParticle {
    private final float nu1;
    private final float size;
    private final float ry;

    public EctoMistParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprites);
        this.gravity = 0.0f;
        this.lifetime += 40;
        int shrink = this.random.nextInt(8);
        this.nu1 = this.sprite.getU1() - (this.sprite.getU1() - this.sprite.getU0()) * 0.125f * (float)shrink;
        this.size = 8 - shrink;
        this.ry = (float)Math.random() * ((float)Math.PI * 2);
        double v = (Math.random() - 0.5) * 0.01 + 0.01;
        float r = this.ry + (this.random.nextBoolean() ? 1.5707964f : 4.712389f);
        this.xd = v * (double)Mth.sin((float)r);
        this.yd = 0.0;
        this.zd = v * (double)Mth.cos((float)r);
        this.scale(4.0f);
        this.setAlpha(0.0f);
    }

    @Override
    public void tick() {
        super.tick();
        float delta = (float)this.age / (float)this.lifetime;
        this.setAlpha(delta < 0.4f ? Mth.lerp((float)(delta / 0.4f), (float)0.0f, (float)1.0f) : (delta > 0.6f ? Mth.lerp((float)((1.0f - delta) / 0.4f), (float)0.0f, (float)1.0f) : 1.0f));
    }

    @Override
    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected float getU1() {
        return this.nu1;
    }

    protected void renderRotatedQuad(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float partialTicks) {
        float f = this.getQuadSize(partialTicks);
        float f1 = this.getU0();
        float f2 = this.getU1();
        float f3 = this.getV0();
        float f4 = this.getV1();
        int i = this.getLightColor(partialTicks);
        this.renderVertex(buffer, quaternion, x, y, z, this.size, -1.0f, f, f2, f4, i);
        this.renderVertex(buffer, quaternion, x, y, z, this.size, 1.0f, f, f2, f3, i);
        this.renderVertex(buffer, quaternion, x, y, z, -this.size, 1.0f, f, f1, f3, i);
        this.renderVertex(buffer, quaternion, x, y, z, -this.size, -1.0f, f, f1, f4, i);
    }

    public SingleQuadParticle.FacingCameraMode getFacingCameraMode() {
        return (quaternion, camera, partialTick) -> quaternion.rotationY(this.ry);
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(@NotNull SimpleParticleType type, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EctoMistParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites);
        }
    }
}

