/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import org.confluence.mod.client.model.block.WeatherVaneBlockModel;
import org.confluence.mod.common.block.functional.WeatherVaneBlock;
import org.joml.Quaternionf;

public class WeatherVaneBlockRenderer
implements BlockEntityRenderer<WeatherVaneBlock.BEntity> {
    private final WeatherVaneBlockModel model;

    public WeatherVaneBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new WeatherVaneBlockModel(context.bakeLayer(WeatherVaneBlockModel.LAYER_LOCATION));
    }

    public void render(WeatherVaneBlock.BEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.0f, 0.5f);
        Quaternionf rotation = Axis.YP.rotation(Mth.lerp((float)partialTick, (float)entity.rotationO, (float)entity.rotation)).rotateX(1.5707964f);
        poseStack.mulPose(rotation.rotateZ(Mth.lerp((float)partialTick, (float)entity.shakeO, (float)entity.shake)));
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        this.model.render(poseStack, bufferSource, packedLight, packedOverlay);
        poseStack.popPose();
    }
}

