/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import org.confluence.lib.util.LibClientUtils;
import org.joml.Matrix4f;

public class FallingStarRenderer
extends ItemEntityRenderer {
    private static final float length = 0.5f;
    private static final float width = 0.25f;

    public FallingStarRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ItemEntity itemEntity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        super.render(itemEntity, entityYaw, partialTick, poseStack, multiBufferSource, 0xF000F0);
        float delta = ((float)itemEntity.level().getGameTime() + partialTick) / 200.0f;
        VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.lightning());
        poseStack.pushPose();
        float y = Mth.sin((float)(((float)itemEntity.getAge() + partialTick) / 10.0f + itemEntity.bobOffs)) * 0.1f;
        poseStack.translate(0.0f, 0.35f + y, 0.0f);
        for (int i = 0; i < 6; ++i) {
            poseStack.mulPose(Axis.XP.rotationDegrees((float)i * 60.0f + delta * 30.0f));
            poseStack.mulPose(Axis.YN.rotationDegrees((float)i * 60.0f + delta * 60.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)i * 60.0f + delta * 90.0f));
            Matrix4f matrix4f = poseStack.last().pose();
            FallingStarRenderer.vertex1(vertexConsumer, matrix4f);
            FallingStarRenderer.vertex2(vertexConsumer, matrix4f);
            FallingStarRenderer.vertex3(vertexConsumer, matrix4f);
            FallingStarRenderer.vertex4(vertexConsumer, matrix4f);
        }
        poseStack.popPose();
    }

    private static void vertex1(VertexConsumer vertexConsumer, Matrix4f matrix4f) {
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setColor(255, 255, 255, 128);
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f matrix4f) {
        vertexConsumer.addVertex(matrix4f, -LibClientUtils.HALF_SQRT_3 * 0.25f, 0.5f, -0.125f).setColor(255, 255, 0, 0);
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f matrix4f) {
        vertexConsumer.addVertex(matrix4f, LibClientUtils.HALF_SQRT_3 * 0.25f, 0.5f, -0.125f).setColor(255, 255, 0, 0);
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f matrix4f) {
        vertexConsumer.addVertex(matrix4f, 0.0f, 0.5f, 0.25f).setColor(255, 255, 0, 0);
    }
}

