/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.model.entity.projectile.FlailModel;
import org.confluence.mod.common.entity.projectile.FlailBall;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FlailRenderer
extends EntityRenderer<FlailBall> {
    private static final ResourceLocation TEXTURE = Confluence.asResource("textures/entity/flail.png");
    protected final EntityModel<FlailBall> model;
    protected final BlockRenderDispatcher dispatcher;

    protected RenderType chainType() {
        return RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);
    }

    public FlailRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new FlailModel(pContext.bakeLayer(FlailModel.LAYER_LOCATION));
        this.dispatcher = pContext.getBlockRenderDispatcher();
    }

    public boolean shouldRender(FlailBall entity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return entity.getOwner() != null;
    }

    public BlockState getChain(FlailBall entity) {
        return Blocks.CHAIN.defaultBlockState();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FlailBall pEntity) {
        return TEXTURE;
    }

    public void render(FlailBall entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int packedLight) {
        Matrix4f chainMatrix;
        double distance;
        Player owner = (Player)entity.getOwner();
        if (owner == null) {
            return;
        }
        poseStack.pushPose();
        entity.frameCount += 5L;
        float angle = entity.frameCount * 2L;
        float yOffset = 0.25f;
        float r = -((Float)entity.getEntityData().get(FlailBall.DATA_OFFSET)).floatValue();
        Vec3 ownerRotateCenterPos = entity.position().add(0.0, (double)yOffset, 0.0).vectorTo(owner.position().add(0.0, 0.8, 0.0)).add((double)r * Math.cos(Math.toRadians(owner.yBodyRot + 180.0f)), 0.0, (double)r * Math.sin(Math.toRadians(owner.yBodyRot + 180.0f)));
        float xRot = (float)Mth.wrapDegrees((double)Math.toDegrees(Mth.atan2((double)(-ownerRotateCenterPos.y), (double)Math.sqrt(ownerRotateCenterPos.x * ownerRotateCenterPos.x + ownerRotateCenterPos.z * ownerRotateCenterPos.z))));
        float yRot = (float)Mth.wrapDegrees((double)Math.toDegrees(Mth.atan2((double)ownerRotateCenterPos.x, (double)ownerRotateCenterPos.z)));
        if (entity.getPhase() == 0) {
            ballMatrix = new Matrix4f().rotate(-((float)Math.toRadians(owner.getYRot())), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
            ballMatrix.translate((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f)).rotate((float)Math.toRadians(angle), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).translate((Vector3fc)new Vector3f(0.0f, -1.0f, 0.0f));
            poseStack.mulPose(ballMatrix);
        } else {
            ballMatrix = new Matrix4f().rotate((float)Math.toRadians(yRot), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
            ballMatrix.translate(0.0f, yOffset, 0.0f).rotate((float)(Math.toRadians(xRot) + 1.5707963267948966), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).translate(0.0f, -yOffset, 0.0f);
            poseStack.mulPose(ballMatrix);
        }
        this.model.renderToBuffer(poseStack, multiBufferSource.getBuffer(this.model.renderType(TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY, 65535);
        poseStack.popPose();
        float scale = 0.25f;
        float scaleXZ = 0.15f;
        float uv = 0.25f;
        poseStack.pushPose();
        VertexConsumer consumer = multiBufferSource.getBuffer(this.chainType());
        Matrix4f basePoseMatrix = poseStack.last().pose();
        PoseStack.Pose pose = poseStack.last();
        poseStack.scale(scaleXZ, scale, scaleXZ);
        if (entity.getPhase() == 0) {
            distance = scale;
            chainMatrix = new Matrix4f().rotate(-((float)Math.toRadians(owner.getYRot())), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
            chainMatrix.translate((Vector3fc)new Vector3f(0.0f, 1.0f / scale, 0.0f)).rotate((float)Math.toRadians(angle), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).translate((Vector3fc)new Vector3f(0.0f, -1.0f / scale, 0.0f));
        } else {
            distance = ownerRotateCenterPos.length();
            chainMatrix = new Matrix4f().translate(0.0f, yOffset / scale, 0.0f).rotate((float)Math.toRadians(yRot), (Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
            chainMatrix.rotate((float)(Math.toRadians(xRot) + 1.5707963267948966), (Vector3fc)new Vector3f(1.0f, 0.0f, 0.0f)).translate(0.0f, -yOffset / scale, 0.0f);
        }
        poseStack.mulPose(chainMatrix);
        float preDistance = 0.3f;
        float i = 0.0f;
        while ((double)i < distance / (double)scaleXZ + 0.5) {
            if (i > preDistance) {
                FlailRenderer.vertex(consumer, basePoseMatrix, pose, packedLight, 0.0f, 0.0f, 0.0f, uv);
                FlailRenderer.vertex(consumer, basePoseMatrix, pose, packedLight, 1.0f, 0.0f, uv, uv);
                FlailRenderer.vertex(consumer, basePoseMatrix, pose, packedLight, 1.0f, 1.0f, uv, 0.0f);
                FlailRenderer.vertex(consumer, basePoseMatrix, pose, packedLight, 0.0f, 1.0f, 0.0f, 0.0f);
            }
            poseStack.mulPose(Axis.YN.rotationDegrees(30.0f));
            poseStack.translate((double)(-scaleXZ) / 2.0, (double)scale, (double)scaleXZ / 2.0);
            i += scale;
        }
        poseStack.popPose();
    }

    protected static void vertex(VertexConsumer pConsumer, Matrix4f pPose, PoseStack.Pose pNormal, int pLightmapUV, float pX, float pY, float pU, float pV) {
        pConsumer.addVertex(pPose, pX - 0.5f, pY - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pLightmapUV).setNormal(pNormal, 0.0f, 1.0f, 0.0f);
    }
}

