/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.model.entity.projectile.StormSpearShotProjectileModel;
import org.confluence.mod.common.entity.projectile.StormSpearShotProjectile;

public class StormSpearShotProjectileRenderer
extends EntityRenderer<StormSpearShotProjectile> {
    private static final ResourceLocation TEXTURE = Confluence.asResource("textures/entity/storm_spear_shot_projectile.png");
    private final StormSpearShotProjectileModel model;

    public StormSpearShotProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new StormSpearShotProjectileModel(context.bakeLayer(StormSpearShotProjectileModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(StormSpearShotProjectile entity) {
        return TEXTURE;
    }

    public void render(StormSpearShotProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.375f, 0.0f);
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.mulPose(Axis.YP.rotationDegrees(entity.getYRot() - 90.0f));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)packedLight, (float)entity.xRotO, (float)entity.getXRot())));
        poseStack.mulPose(Axis.YP.rotation(-1.5707964f));
        poseStack.mulPose(Axis.ZP.rotation(Mth.lerp((float)partialTick, (float)entity.rotate.old, (float)entity.rotate.neo)));
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(this.model.renderType(TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

