/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.model.entity.projectile.TitaniumShardsProjectileModel;
import org.confluence.mod.common.entity.projectile.TitaniumShardsProjectile;
import org.joml.Vector3d;

public class TitaniumShardsProjectileRenderer
extends EntityRenderer<TitaniumShardsProjectile> {
    private static final RenderType[] RENDER_TYPES = new RenderType[]{RenderType.entityCutoutNoCull((ResourceLocation)Confluence.asResource("textures/entity/titanium_shards/_0.png")), RenderType.entityCutoutNoCull((ResourceLocation)Confluence.asResource("textures/entity/titanium_shards/_1.png")), RenderType.entityCutoutNoCull((ResourceLocation)Confluence.asResource("textures/entity/titanium_shards/_2.png"))};
    private final TitaniumShardsProjectileModel model;

    public TitaniumShardsProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TitaniumShardsProjectileModel(context.bakeLayer(TitaniumShardsProjectileModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(TitaniumShardsProjectile entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public boolean shouldRender(TitaniumShardsProjectile livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(TitaniumShardsProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        for (int i = 0; i < entity.shardPos.size(); ++i) {
            Vector3d start = entity.shardPosO.get(i);
            Vector3d end = entity.shardPos.get(i);
            double x = Mth.lerp((double)partialTick, (double)start.x, (double)end.x);
            double y = Mth.lerp((double)partialTick, (double)start.y, (double)end.y);
            double z = Mth.lerp((double)partialTick, (double)start.z, (double)end.z);
            poseStack.pushPose();
            poseStack.translate(x, y, z);
            poseStack.mulPose(Axis.YN.rotation(((float)entity.tickCount + partialTick) * ((float)Math.PI / 180) + (float)i));
            poseStack.scale(1.0f, -1.0f, 1.0f);
            this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RENDER_TYPES[i % 3]), packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
    }
}

