/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.model.entity.projectile.VilethronProjectileModel;
import org.confluence.mod.common.entity.projectile.strip.VilethronProjectile;

public class VilethronProjectileRenderer
extends EntityRenderer<VilethronProjectile> {
    private static final ResourceLocation TEXTURE = Confluence.asResource("textures/entity/vilethron_projectile.png");
    private final VilethronProjectileModel model;

    public VilethronProjectileRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new VilethronProjectileModel(context.bakeLayer(VilethronProjectileModel.LAYER_LOCATION));
    }

    public ResourceLocation getTextureLocation(VilethronProjectile entity) {
        return TEXTURE;
    }

    public void render(VilethronProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float[] rot = entity.getRot();
        poseStack.mulPose(Axis.YP.rotation(rot[0] - 1.5707964f));
        poseStack.mulPose(Axis.ZP.rotation(rot[1]));
        int color = FastColor.ARGB32.color((int)entity.getAlpha(), (int)0xFFFFFF);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)TEXTURE)), packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
    }
}

