/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile.sword;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.confluence.terraentity.client.entity.renderer.BaseEntityRenderer;

public class ForwardProjRenderer<T extends Entity, S extends Entity, M extends EntityModel<S>>
extends BaseEntityRenderer<T, S, M> {
    private final ResourceLocation texture;
    protected boolean rotateZ;
    protected float rotateZSpeed;

    public ForwardProjRenderer(EntityRendererProvider.Context context, M model, ResourceLocation texture, float size, float offsetY, float rotateZSpeed) {
        super(context, model, size, offsetY);
        this.texture = texture;
        this.rotateZ = rotateZSpeed > 0.0f;
        this.rotateZSpeed = rotateZSpeed;
    }

    public ForwardProjRenderer(EntityRendererProvider.Context context, M model, ResourceLocation texture, float size, float offsetY) {
        this(context, model, texture, size, offsetY, 0.0f);
    }

    public ForwardProjRenderer(EntityRendererProvider.Context context, M model, ResourceLocation texture) {
        this(context, model, texture, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(T swordProjectile) {
        return this.texture;
    }

    public void preRender(T entity, float pEntityYaw, float partialTick, PoseStack poseStack, int packedLight) {
        super.preRender(entity, pEntityYaw, partialTick, poseStack, packedLight);
        float f = Math.min(((float)((Entity)entity).tickCount + partialTick) * 0.1f, 1.0f);
        poseStack.scale(f, f, f);
        Vec3 v = entity.getDeltaMovement();
        float yaw = (float)Math.atan2(v.z, v.x);
        poseStack.mulPose(Axis.YN.rotation(yaw + 1.5707964f));
        float pitch = -((float)Math.atan2(v.y, v.horizontalDistance()));
        poseStack.mulPose(Axis.XN.rotation(pitch));
        if (this.rotateZ) {
            poseStack.mulPose(Axis.ZN.rotation(((float)((Entity)entity).tickCount + partialTick) * this.rotateZSpeed));
        }
    }
}

