/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile.sword;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.model.entity.projectile.EnchantedSwordProjectileModel;
import org.confluence.mod.client.renderer.entity.projectile.sword.ForwardProjRenderer;
import org.confluence.mod.common.entity.projectile.sword.LightBaneProjectile;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.joml.Vector3f;

public class LightsBaneProjectileRenderer
extends ForwardProjRenderer<LightBaneProjectile, SwordProjectile, EnchantedSwordProjectileModel> {
    public LightsBaneProjectileRenderer(EntityRendererProvider.Context context) {
        super(context, new EnchantedSwordProjectileModel(context.bakeLayer(EnchantedSwordProjectileModel.LAYER_LOCATION)), Confluence.asResource("textures/entity/lights_bane.png"));
    }

    @Override
    public void preRender(LightBaneProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, int packedLight) {
        float scale = entity.tickCount > entity.lifetime - 10 ? 1.0f - ((float)entity.tickCount + partialTick - (float)(entity.lifetime - 10)) * 0.1f : Math.min(((float)entity.tickCount + partialTick) * 0.2f, 1.0f);
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0f, 0.125f, -0.125f);
        poseStack.mulPose(Axis.YP.rotationDegrees(-Mth.lerp((float)partialTick, (float)entity.getYRot(), (float)entity.getYRot())));
        float yRot = entity.getYHeadRot();
        double rad = (double)yRot * Math.PI / 180.0;
        float xRot = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
        poseStack.mulPose(Axis.of((Vector3f)new Vector3f((float)Math.cos(rad), 0.0f, (float)Math.sin(rad))).rotationDegrees(xRot));
    }

    public RenderType getRenderType(LightBaneProjectile entity, float partialTicks) {
        return RenderType.energySwirl((ResourceLocation)this.getTextureLocation(entity), (float)((float)Math.sin((float)entity.tickCount * 0.1f)), (float)((float)Math.sin((float)entity.tickCount * 0.2f)));
    }
}

