/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.entity.projectile.sword;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class StarFuryProjectileRenderer
extends EntityRenderer<SwordProjectile> {
    protected ResourceLocation TEXTURE_LOCATION = Confluence.asResource("textures/entity/star_fury_projectile.png");
    private int frame = 0;

    public ResourceLocation getTextureLocation(SwordProjectile swordProjectile) {
        return this.TEXTURE_LOCATION;
    }

    private float getScale() {
        return 2.0f;
    }

    protected int getBlockLightLevel(SwordProjectile entity, BlockPos pos) {
        return 10;
    }

    public StarFuryProjectileRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(SwordProjectile entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(this.getScale(), this.getScale(), this.getScale());
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        Matrix3f matrix3f = pose.normal();
        poseStack.mulPose(Axis.YP.rotationDegrees((float)this.frame++));
        VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation((SwordProjectile)null)));
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 0.0f, 0.0f, 0, 1);
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 1.0f, 0.0f, 1, 1);
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 1.0f, 1.0f, 1, 0);
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 0.0f, 1.0f, 0, 0);
        poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 0.0f, 0.0f, 0, 1);
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 1.0f, 0.0f, 1, 1);
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 1.0f, 1.0f, 1, 0);
        StarFuryProjectileRenderer.vertex(vertexconsumer, matrix4f, pose, packedLight, 0.0f, 1.0f, 0, 0);
        poseStack.translate(0.0, 0.5, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    protected static void vertex(VertexConsumer pConsumer, Matrix4f pPose, PoseStack.Pose pNormal, int pLightmapUV, float pX, float pY, int pU, int pV) {
        pConsumer.addVertex(pPose, pX - 0.5f, pY - 0.5f, 0.0f).setColor(255, 150, 150, 255).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pLightmapUV).setNormal(pNormal, 0.0f, 1.0f, 0.0f);
    }
}

