/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.phys.Vec3;

public class DungeonCompassRenderer {
    private static DungeonCompassRenderer INSTANCE;
    private final SkullModel model = new SkullModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.SKELETON_SKULL));

    private DungeonCompassRenderer() {
    }

    public static DungeonCompassRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DungeonCompassRenderer();
        }
        return INSTANCE;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, AbstractClientPlayer player, int x, int y, int z) {
        if (!Minecraft.getInstance().options.getCameraType().isFirstPerson()) {
            return;
        }
        RenderSystem.enableDepthTest();
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        float ry = (float)Math.PI - player.getYRot() * ((float)Math.PI / 180);
        float cos = Mth.cos((float)ry);
        float sin = Mth.sin((float)ry);
        double mx = -0.75;
        double mz = -1.0;
        double vx = mx * (double)cos + mz * (double)(-sin);
        double vz = mx * (double)sin + mz * (double)cos;
        poseStack.translate(vx, 0.25, vz);
        Vec3 delta = new Vec3((double)x - player.getX(), 0.0, (double)z - player.getZ());
        float yaw = (float)Mth.atan2((double)(-delta.x), (double)delta.z) * 57.295776f;
        this.model.setupAnim(0.0f, 180.0f + yaw, 0.0f);
        this.model.renderToBuffer(poseStack, bufferSource.getBuffer(SkullBlockRenderer.getRenderType((SkullBlock.Type)SkullBlock.Types.SKELETON, null)), 0xF000F0, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        RenderSystem.disableDepthTest();
    }
}

