/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;

public class EntityDisplayItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private Map<UUID, Entity> entityMap = new Hashtable<UUID, Entity>();
    private final Function<ClientLevel, RemotePlayer> magicHarp2333 = new Function<ClientLevel, RemotePlayer>(this){
        private RemotePlayer cache;

        @Override
        public RemotePlayer apply(ClientLevel level) {
            if (this.cache == null) {
                this.cache = new RemotePlayer(this, level, new GameProfile(Mth.createInsecureUUID((RandomSource)level.random), "MagicHarp2333")){
                    private PlayerSkin playerSkin;

                    public PlayerSkin getSkin() {
                        if (this.playerSkin == null) {
                            this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (Object)127);
                            this.playerSkin = new PlayerSkin(Confluence.asResource("textures/magic_harp_2333.png"), null, null, null, PlayerSkin.Model.WIDE, false);
                        }
                        return this.playerSkin;
                    }
                };
            }
            return this.cache;
        }
    };

    public EntityDisplayItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Entity entity;
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        CompoundTag tag = LibUtils.getItemStackNbtIfPresent((ItemStack)stack);
        if (tag == null) {
            entity = (Entity)this.magicHarp2333.apply(level);
        } else {
            if (!this.entityMap.isEmpty() && level.getGameTime() % 24000L == 0L) {
                this.entityMap = new HashMap<UUID, Entity>();
            }
            try {
                entity = this.entityMap.computeIfAbsent(tag.getUUID("UUID"), uuid -> {
                    Entity loaded = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)level, Function.identity());
                    return loaded == null ? new Pig(EntityType.PIG, (Level)level) : loaded;
                });
            }
            catch (Exception e) {
                entity = (Entity)this.magicHarp2333.apply(level);
            }
        }
        poseStack.pushPose();
        EntityRenderDispatcher erd = minecraft.getEntityRenderDispatcher();
        MultiBufferSource.BufferSource immediate = minecraft.renderBuffers().bufferSource();
        erd.setRenderShadow(false);
        poseStack.translate(0.5f, 0.25f, 0.5f);
        float rotation = 0.0f;
        if (displayContext == ItemDisplayContext.GUI) {
            rotation = -0.7853982f;
        } else if (displayContext == ItemDisplayContext.FIXED) {
            rotation = 2.3561945f;
        }
        poseStack.mulPose(Axis.YP.rotation(rotation));
        erd.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)immediate, packedLight);
        erd.setRenderShadow(true);
        immediate.endBatch();
        poseStack.popPose();
    }
}

