/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.init.item.SwordItems;
import org.confluence.mod.mixin.client.accessor.LivingEntityRendererAccessor;

public class ZombieArmRenderer {
    private static ZombieArmRenderer INSTANCE;
    private static final ResourceLocation ZOMBIE_LOCATION;
    private final HumanoidModel<AbstractClientPlayer> zombieModel = new HumanoidModel(Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.ZOMBIE));

    private ZombieArmRenderer() {
    }

    public void render(PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Player player, float partialTick) {
        PlayerModel playerModel = (PlayerModel)playerRenderer.getModel();
        this.zombieModel.setAllVisible(false);
        if (player.getItemInHand(InteractionHand.MAIN_HAND).is(SwordItems.ZOMBIE_ARM)) {
            playerModel.rightArm.visible = false;
            playerModel.rightSleeve.visible = false;
            this.zombieModel.rightArm.visible = true;
        }
        if (player.getItemInHand(InteractionHand.OFF_HAND).is(SwordItems.ZOMBIE_ARM)) {
            playerModel.leftArm.visible = false;
            playerModel.leftSleeve.visible = false;
            this.zombieModel.leftArm.visible = true;
        }
        playerModel.copyPropertiesTo(this.zombieModel);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(this.zombieModel.renderType(ZOMBIE_LOCATION));
        poseStack.pushPose();
        float f8 = player.getScale();
        poseStack.scale(f8, f8, f8);
        float f = Mth.rotLerp((float)partialTick, (float)player.yBodyRotO, (float)player.yBodyRot);
        LivingEntityRendererAccessor accessor = (LivingEntityRendererAccessor)playerRenderer;
        float f9 = accessor.callGetBob((LivingEntity)player, partialTick);
        accessor.callSetupRotations((LivingEntity)player, poseStack, f9, f, partialTick, f8);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        accessor.callScale((LivingEntity)player, poseStack, partialTick);
        poseStack.translate(0.0f, -1.501f, 0.0f);
        this.zombieModel.renderToBuffer(poseStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }

    public boolean renderHand(PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, HumanoidArm humanoidArm) {
        ModelPart rendererArm;
        if (humanoidArm == HumanoidArm.RIGHT && player.getItemInHand(InteractionHand.MAIN_HAND).is(SwordItems.ZOMBIE_ARM)) {
            rendererArm = this.zombieModel.rightArm;
        } else if (humanoidArm == HumanoidArm.LEFT && player.getItemInHand(InteractionHand.OFF_HAND).is(SwordItems.ZOMBIE_ARM)) {
            rendererArm = this.zombieModel.leftArm;
        } else {
            return false;
        }
        PlayerModel playermodel = (PlayerModel)playerRenderer.getModel();
        playerRenderer.setModelProperties(player);
        playermodel.attackTime = 0.0f;
        playermodel.crouching = false;
        playermodel.swimAmount = 0.0f;
        playermodel.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        rendererArm.xRot = 0.0f;
        rendererArm.render(poseStack, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)ZOMBIE_LOCATION)), combinedLight, OverlayTexture.NO_OVERLAY);
        return true;
    }

    public static ZombieArmRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ZombieArmRenderer();
        }
        return INSTANCE;
    }

    static {
        ZOMBIE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/zombie/zombie.png");
    }
}

