/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.mixed.IServerPlayer;
import org.confluence.mod.network.s2c.DropletsSyncPacketS2C;

public class ChunkDropletsData
implements INBTSerializable<CompoundTag> {
    private final Map<ChunkPos, Map<BlockPos, ParticleOptions>> dataMap = new Hashtable<ChunkPos, Map<BlockPos, ParticleOptions>>();
    private final transient Map<UUID, Set<ChunkPos>> lastSync = new HashMap<UUID, Set<ChunkPos>>();

    public Map<ChunkPos, Map<BlockPos, ParticleOptions>> getDataMap() {
        return this.dataMap;
    }

    public Map<ChunkPos, Map<BlockPos, ParticleOptions>> getDataMap(Player player, boolean force) {
        HashMap<ChunkPos, Map<BlockPos, ParticleOptions>> map = null;
        ChunkPos center = null;
        Set posSet = null;
        for (int i = -1; i <= 1; ++i) {
            boolean a = i == 0;
            for (int j = -1; j <= 1; ++j) {
                ChunkPos pos;
                Map<BlockPos, ParticleOptions> map1;
                if (map == null) {
                    map = new HashMap<ChunkPos, Map<BlockPos, ParticleOptions>>();
                    center = player.chunkPosition();
                    posSet = this.lastSync.computeIfAbsent(player.getUUID(), uuid -> new HashSet());
                }
                if ((map1 = this.dataMap.get(pos = a && j == 0 ? center : new ChunkPos(center.x + i, center.z + j))) == null || !force && posSet.contains(pos)) continue;
                map.put(pos, map1);
                posSet.add(pos);
            }
        }
        return map;
    }

    public Map<UUID, Set<ChunkPos>> getLastSync() {
        return this.lastSync;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag listTag = new ListTag();
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (Map.Entry<ChunkPos, Map<BlockPos, ParticleOptions>> entry : this.dataMap.entrySet()) {
            ChunkPos chunkPos = entry.getKey();
            CompoundTag map = new CompoundTag();
            map.putInt("x", chunkPos.x);
            map.putInt("z", chunkPos.z);
            ListTag data = new ListTag();
            for (Map.Entry<BlockPos, ParticleOptions> posEntry : entry.getValue().entrySet()) {
                ParticleTypes.CODEC.encodeStart((DynamicOps)ops, (Object)posEntry.getValue()).ifSuccess(result -> {
                    CompoundTag tag = new CompoundTag();
                    tag.putInt("pos", LibUtils.compressRelativePos((BlockPos)((BlockPos)posEntry.getKey())));
                    tag.put("particle", result);
                    data.add((Object)tag);
                });
            }
            map.put("data", (Tag)data);
            listTag.add((Object)map);
        }
        nbt.put("dataMap", (Tag)listTag);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.dataMap.clear();
        ListTag listTag = nbt.getList("dataMap", 10);
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        for (Tag tag : listTag) {
            CompoundTag map = (CompoundTag)tag;
            ChunkPos chunkPos = new ChunkPos(map.getInt("x"), map.getInt("z"));
            Hashtable value = new Hashtable();
            for (Tag data : map.getList("data", 10)) {
                CompoundTag compoundTag = (CompoundTag)data;
                ParticleTypes.CODEC.parse((DynamicOps)ops, (Object)compoundTag.get("particle")).ifSuccess(result -> value.put(LibUtils.decompressRelativePos((ChunkPos)chunkPos, (int)compoundTag.getInt("pos")), result));
            }
            this.dataMap.put(chunkPos, value);
        }
    }

    public static void syncDroplets(ServerPlayer player) {
        block2: {
            Map<ChunkPos, Map<BlockPos, ParticleOptions>> dataMap;
            block3: {
                if (!IServerPlayer.of(player).confluence$chunkPosChanged()) break block2;
                ChunkDropletsData data = ChunkDropletsData.of((Level)player.serverLevel());
                dataMap = data.getDataMap((Player)player, false);
                if (!dataMap.isEmpty()) break block3;
                if (!data.getLastSync().computeIfAbsent(player.getUUID(), uuid -> new HashSet()).stream().anyMatch(dataMap.keySet()::contains)) break block2;
            }
            DropletsSyncPacketS2C.sendToClient(player, dataMap);
        }
    }

    public static ChunkDropletsData of(Level level) {
        return (ChunkDropletsData)level.getData(ModAttachmentTypes.CHUNK_DROPLETS_DATA);
    }
}

