/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.attachment;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.confluence.mod.common.init.ModAttachmentTypes;
import org.confluence.mod.common.item.hook.BaseHookItem;
import org.confluence.mod.network.s2c.ExtraInventoryStackPacketS2C;
import org.confluence.mod.util.AchievementUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class ExtraInventory
implements Container,
INBTSerializable<CompoundTag> {
    public static final int SIZE_VANITY_ARMOR = 4;
    public static final int SIZE_COINS = 4;
    public static final int SIZE_AMMO = 4;
    public static final int SIZE_EQUIPMENT = 5;
    public static final int SIZE_TRASH = 1;
    public static final int SIZE_EXCEPT_ACCESSORY_DYE = 27;
    public static final int VANITY_ARMOR_START = 0;
    public static final int VANITY_ARMOR_DYE_START = 4;
    public static final int COINS_START = 8;
    public static final int AMMO_START = 12;
    public static final int EQUIPMENT_START = 16;
    public static final int EQUIPMENT_DYE_START = 21;
    public static final int TRASH_START = 26;
    public static final int ACCESSORY_DYE_START = 27;
    public static final int PET_INDEX = 0;
    public static final int LIGHT_PET_INDEX = 1;
    public static final int MINECART_INDEX = 2;
    public static final int HOOK_INDEX = 3;
    public static final int MOUNT_INDEX = 4;
    public static final StreamCodec<RegistryFriendlyByteBuf, ExtraInventory> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ExtraInventory>(){

        public ExtraInventory decode(RegistryFriendlyByteBuf buffer) {
            ExtraInventory extraInventory = new ExtraInventory(false);
            int accessoryDye = buffer.readVarInt();
            int size = 27 + accessoryDye;
            extraInventory.initialized = true;
            extraInventory.accessoryDye = NonNullList.withSize((int)accessoryDye, (Object)ItemStack.EMPTY);
            extraInventory.previousStacks = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
            extraInventory.dirty = false;
            List list = (List)ItemStack.OPTIONAL_LIST_STREAM_CODEC.decode((Object)buffer);
            for (int i = 0; i < size; ++i) {
                extraInventory.setItem(i, (ItemStack)list.get(i));
            }
            return extraInventory;
        }

        public void encode(RegistryFriendlyByteBuf buffer, ExtraInventory extraInventory) {
            buffer.writeVarInt(extraInventory.getSizeAccessoryDye());
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            for (int i = 0; i < extraInventory.getContainerSize(); ++i) {
                list.add(i, extraInventory.getItem(i));
            }
            ItemStack.OPTIONAL_LIST_STREAM_CODEC.encode((Object)buffer, list);
        }
    };
    private NonNullList<IStackWithDye> vanityArmor = NonNullList.withSize((int)4, (Object)StackWithDye.DEFAULT);
    private NonNullList<ItemStack> coin = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private NonNullList<ItemStack> ammo = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private NonNullList<IStackWithDye> equipment = NonNullList.withSize((int)5, (Object)StackWithDye.DEFAULT);
    private ItemStack trash = ItemStack.EMPTY;
    private NonNullList<ItemStack> accessoryDye;
    private transient boolean initialized = false;
    private transient NonNullList<ItemStack> previousStacks;
    private transient boolean dirty = true;
    private transient LivingEntity living;

    public ExtraInventory(boolean init) {
        if (init) {
            this.accessoryDye = NonNullList.withSize((int)0, (Object)ItemStack.EMPTY);
            this.previousStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
        }
    }

    public int getSizeAccessoryDye() {
        return this.accessoryDye.size();
    }

    public ItemStack getVanityArmor(int index, boolean dye) {
        ExtraInventory.validateIndex(index, 4);
        IStackWithDye stack = (IStackWithDye)this.vanityArmor.get(index);
        return dye ? stack.getDye() : stack.getStack();
    }

    public void setVanityArmor(int index, ItemStack stack, boolean dye) {
        ExtraInventory.validateIndex(index, 4);
        if (dye) {
            this.vanityArmor.set(index, (Object)((IStackWithDye)this.vanityArmor.get(index)).setDye(stack));
        } else {
            this.vanityArmor.set(index, (Object)((IStackWithDye)this.vanityArmor.get(index)).setStack(stack));
        }
        this.setChanged();
    }

    public ItemStack getCoins(int index) {
        ExtraInventory.validateIndex(index, 4);
        return (ItemStack)this.coin.get(index);
    }

    public List<ItemStack> getAllCoins() {
        return this.coin;
    }

    public void setCoins(int index, ItemStack stack) {
        ExtraInventory.validateIndex(index, 4);
        this.coin.set(index, (Object)stack);
        this.setChanged();
    }

    public ItemStack getAmmo(int index) {
        ExtraInventory.validateIndex(index, 4);
        return (ItemStack)this.ammo.get(index);
    }

    public List<ItemStack> getAllAmmo() {
        return this.ammo;
    }

    public void setAmmo(int index, ItemStack stack) {
        ExtraInventory.validateIndex(index, 4);
        this.ammo.set(index, (Object)stack);
        this.setChanged();
    }

    public ItemStack getEquipment(int index, boolean dye) {
        ExtraInventory.validateIndex(index, 5);
        IStackWithDye stack = (IStackWithDye)this.equipment.get(index);
        return dye ? stack.getDye() : stack.getStack();
    }

    public ItemStack getPet(boolean dye) {
        return this.getEquipment(0, dye);
    }

    public ItemStack getLightPet(boolean dye) {
        return this.getEquipment(1, dye);
    }

    public ItemStack getMinecart(boolean dye) {
        return this.getEquipment(2, dye);
    }

    public ItemStack getHook(boolean dye) {
        return this.getEquipment(3, dye);
    }

    public void setEquipment(int index, ItemStack stack, boolean dye) {
        ExtraInventory.validateIndex(index, 5);
        if (dye) {
            this.equipment.set(index, (Object)((IStackWithDye)this.equipment.get(index)).setDye(stack));
        } else {
            this.equipment.set(index, (Object)((IStackWithDye)this.equipment.get(index)).setStack(stack));
        }
        this.setChanged();
    }

    public ItemStack getTrash() {
        return this.trash;
    }

    public void setTrash(ItemStack stack) {
        this.trash = stack;
        this.setChanged();
    }

    public ItemStack getAccessoryDye(int index) {
        ExtraInventory.validateIndex(index, this.accessoryDye.size());
        return (ItemStack)this.accessoryDye.get(index);
    }

    public void setAccessoryDye(int index, ItemStack stack) {
        ExtraInventory.validateIndex(index, this.accessoryDye.size());
        this.accessoryDye.set(index, (Object)stack);
        this.setChanged();
    }

    private static void validateIndex(int index, int size) {
        if (index < 0 || index >= size) {
            throw new RuntimeException("Slot " + index + " not in valid range - [0," + size + ")");
        }
    }

    public void sync(ServerPlayer player) {
        this.initialize(player);
        if (this.dirty) {
            for (int i = 0; i < this.getContainerSize(); ++i) {
                ItemStack previous;
                ItemStack itemStack = this.getItem(i);
                if (ItemStack.matches((ItemStack)itemStack, (ItemStack)(previous = (ItemStack)this.previousStacks.get(i)))) continue;
                ExtraInventoryStackPacketS2C.sendToPlayersTrackingEntityAndSelf(player, player, this.accessoryDye.size(), i, itemStack);
                Item item = previous.getItem();
                if (item instanceof BaseHookItem) {
                    BaseHookItem hookItem = (BaseHookItem)item;
                    hookItem.onUnequip(player, itemStack, previous);
                }
                this.previousStacks.set(i, (Object)itemStack.copy());
            }
            this.dirty = false;
            this.checkAchievements(player);
        }
    }

    private void checkAchievements(ServerPlayer player) {
        if (this.vanityArmor.stream().noneMatch(IStackWithDye::isDyeEmpty) && this.equipment.stream().noneMatch(IStackWithDye::isDyeEmpty) && this.accessoryDye.stream().noneMatch(ItemStack::isEmpty)) {
            AchievementUtils.awardAchievement(player, "dye_hard");
        }
        if (this.vanityArmor.stream().noneMatch(IStackWithDye::isStackEmpty)) {
            AchievementUtils.awardAchievement(player, "fashion_statement");
        }
        if (!this.getHook(false).isEmpty()) {
            AchievementUtils.awardAchievement(player, "hold_on_tight");
        }
    }

    public void initialize(ServerPlayer player) {
        if (!this.initialized) {
            Optional inventory = CuriosApi.getCuriosInventory((LivingEntity)player);
            this.updateAccessorySize((Player)player, inventory.map(handler -> {
                ICurioStacksHandler accessory = (ICurioStacksHandler)handler.getCurios().get("accessory");
                return accessory == null ? 0 : accessory.getSlots();
            }).orElse(0));
            inventory.ifPresent(handler -> {
                BiConsumer<Integer, ICurioStacksHandler> function = (i, t) -> this.equipment.set(i.intValue(), (Object)new CurioStackWithDye(0, (ICurioStacksHandler)t, (IStackWithDye)this.equipment.get(i.intValue())));
                handler.getStacksHandler("pet").ifPresent(t -> function.accept(0, (ICurioStacksHandler)t));
                handler.getStacksHandler("light_pet").ifPresent(t -> function.accept(1, (ICurioStacksHandler)t));
                handler.getStacksHandler("mount").ifPresent(t -> function.accept(4, (ICurioStacksHandler)t));
            });
            this.initialized = true;
        }
    }

    public void updateAccessorySize(Player player, int accessoryDye) {
        this.setAccessoryDyes(player, accessoryDye);
        this.previousStacks = NonNullList.withSize((int)(27 + accessoryDye), (Object)ItemStack.EMPTY);
    }

    public void setAccessoryDyes(Player player, int sizeCurrent) {
        int sizeBefore = this.accessoryDye.size();
        NonNullList itemStacks = NonNullList.withSize((int)sizeCurrent, (Object)ItemStack.EMPTY);
        if (!player.isLocalPlayer() && sizeBefore > sizeCurrent) {
            for (ItemStack remain : this.accessoryDye.subList(sizeCurrent, sizeBefore)) {
                if (remain.isEmpty()) continue;
                player.drop(remain, true);
            }
        }
        for (int i = 0; i < sizeCurrent; ++i) {
            if (i >= sizeBefore) continue;
            itemStacks.set(i, (Object)((ItemStack)this.accessoryDye.get(i)));
        }
        this.accessoryDye = itemStacks;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CompoundTag tag = new CompoundTag();
        ListTag t = new ListTag();
        for (IStackWithDye stack : this.vanityArmor) {
            t.add((Object)stack.encode((DynamicOps<Tag>)ops));
        }
        tag.put("VanityArmor", (Tag)t);
        tag.put("Coin", ExtraInventory.encodeList(this.coin, (DynamicOps<Tag>)ops));
        tag.put("Ammo", ExtraInventory.encodeList(this.ammo, (DynamicOps<Tag>)ops));
        t = new ListTag();
        for (IStackWithDye stack : this.equipment) {
            t.add((Object)stack.encode((DynamicOps<Tag>)ops));
        }
        tag.put("Equipment", (Tag)t);
        tag.put("Trash", ExtraInventory.encode(this.trash, (DynamicOps<Tag>)ops));
        tag.put("AccessoryDye", ExtraInventory.encodeList(this.accessoryDye, (DynamicOps<Tag>)ops));
        tag.putBoolean("confluence:fixed", true);
        return tag;
    }

    private static Tag encodeList(NonNullList<ItemStack> list, DynamicOps<Tag> ops) {
        ListTag tag = new ListTag();
        for (ItemStack stack : list) {
            tag.add((Object)ExtraInventory.encode(stack, ops));
        }
        return tag;
    }

    private static Tag encode(ItemStack stack, DynamicOps<Tag> ops) {
        return ItemStack.OPTIONAL_CODEC.encodeStart(ops, (Object)stack).result().orElseGet(CompoundTag::new);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        if (nbt.getBoolean("confluence:fixed")) {
            int i;
            RegistryOps ops = provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ListTag t = nbt.getList("VanityArmor", 10);
            for (i = 0; i < this.vanityArmor.size(); ++i) {
                this.vanityArmor.set(i, (Object)StackWithDye.DEFAULT.decode(t.getCompound(i), (DynamicOps<Tag>)ops));
            }
            ExtraInventory.decodeList(this.coin, nbt.getList("Coin", 10), (DynamicOps<Tag>)ops);
            ExtraInventory.decodeList(this.ammo, nbt.getList("Ammo", 10), (DynamicOps<Tag>)ops);
            t = nbt.getList("Equipment", 10);
            for (i = 0; i < this.equipment.size(); ++i) {
                this.equipment.set(i, (Object)StackWithDye.DEFAULT.decode(t.getCompound(i), (DynamicOps<Tag>)ops));
            }
            this.trash = ExtraInventory.decode(nbt.getCompound("Trash"), (DynamicOps<Tag>)ops);
            t = nbt.getList("AccessoryDye", 10);
            this.accessoryDye = NonNullList.withSize((int)t.size(), (Object)ItemStack.EMPTY);
            ExtraInventory.encodeList((NonNullList<ItemStack>)this.accessoryDye, (DynamicOps<Tag>)ops);
        } else {
            int size = nbt.contains("Size", 3) ? nbt.getInt("Size") : this.getContainerSize();
            this.accessoryDye = NonNullList.withSize((int)(size - 25), (Object)ItemStack.EMPTY);
            ListTag tagList = nbt.getList("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.getCompound(i);
                int slot = itemTags.getInt("Slot");
                if (slot < 0 || slot >= size) continue;
                ItemStack.parse((HolderLookup.Provider)provider, (Tag)itemTags).ifPresent(stack -> {
                    if (slot < 4) {
                        this.setVanityArmor(slot, (ItemStack)stack, false);
                    } else if (slot < 8) {
                        this.setCoins(slot - 4, (ItemStack)stack);
                    } else if (slot < 12) {
                        this.setAmmo(slot - 8, (ItemStack)stack);
                    } else if (slot == 12) {
                        this.setEquipment(0, (ItemStack)stack, false);
                    } else if (slot == 13) {
                        this.setEquipment(1, (ItemStack)stack, false);
                    } else if (slot == 14) {
                        this.setEquipment(2, (ItemStack)stack, false);
                    } else if (slot == 15) {
                        this.setEquipment(3, (ItemStack)stack, false);
                    } else if (slot == 16) {
                        this.setTrash((ItemStack)stack);
                    } else if (slot < 21) {
                        this.setVanityArmor(slot - 17, (ItemStack)stack, true);
                    } else if (slot == 21) {
                        this.setEquipment(0, (ItemStack)stack, true);
                    } else if (slot == 22) {
                        this.setEquipment(1, (ItemStack)stack, true);
                    } else if (slot == 23) {
                        this.setEquipment(2, (ItemStack)stack, true);
                    } else if (slot == 24) {
                        this.setEquipment(3, (ItemStack)stack, true);
                    } else if (slot < 25 + this.accessoryDye.size()) {
                        this.setAccessoryDye(slot - 25, (ItemStack)stack);
                    }
                });
            }
        }
    }

    private static void decodeList(NonNullList<ItemStack> list, ListTag tag, DynamicOps<Tag> ops) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)ExtraInventory.decode(tag.getCompound(i), ops));
        }
    }

    private static ItemStack decode(CompoundTag tag, DynamicOps<Tag> ops) {
        return ItemStack.OPTIONAL_CODEC.parse(ops, (Object)tag).result().orElse(ItemStack.EMPTY);
    }

    public void copyFrom(ExtraInventory other) {
        this.vanityArmor = other.vanityArmor;
        this.coin = other.coin;
        this.ammo = other.ammo;
        this.equipment = other.equipment;
        this.trash = other.trash;
        this.accessoryDye = other.accessoryDye;
        this.initialized = other.initialized;
        this.previousStacks = other.previousStacks;
        this.dirty = other.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public int getContainerSize() {
        return 27 + this.accessoryDye.size();
    }

    public ItemStack getItem(int index) {
        if (index < 4) {
            return this.getVanityArmor(index - 0, false);
        }
        if (index < 8) {
            return this.getVanityArmor(index - 4, true);
        }
        if (index < 12) {
            return this.getCoins(index - 8);
        }
        if (index < 16) {
            return this.getAmmo(index - 12);
        }
        if (index < 21) {
            return this.getEquipment(index - 16, false);
        }
        if (index < 26) {
            return this.getEquipment(index - 21, true);
        }
        if (index < 27) {
            return this.getTrash();
        }
        if (index < this.getContainerSize()) {
            return this.getAccessoryDye(index - 27);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.removeItemNoUpdate(slot);
        this.setDirty();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getItem(slot);
        this.setItem(slot, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        if (index < 4) {
            this.setVanityArmor(index - 0, stack, false);
        } else if (index < 8) {
            this.setVanityArmor(index - 4, stack, true);
        } else if (index < 12) {
            this.setCoins(index - 8, stack);
        } else if (index < 16) {
            this.setAmmo(index - 12, stack);
        } else if (index < 21) {
            this.setEquipment(index - 16, stack, false);
        } else if (index < 26) {
            this.setEquipment(index - 21, stack, true);
        } else if (index < 27) {
            this.setTrash(stack);
        } else if (index < this.getContainerSize()) {
            this.setAccessoryDye(index - 27, stack);
        }
    }

    public boolean isEmpty() {
        for (IStackWithDye stack : this.vanityArmor) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (IStackWithDye stack : this.coin) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (IStackWithDye stack : this.ammo) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (IStackWithDye stack : this.equipment) {
            if (stack.isEmpty()) continue;
            return false;
        }
        for (IStackWithDye stack : this.accessoryDye) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setChanged() {
        this.setDirty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.vanityArmor.clear();
        this.coin.clear();
        this.ammo.clear();
        this.equipment.clear();
        this.trash = ItemStack.EMPTY;
        this.accessoryDye.clear();
    }

    public static ItemStack getProjectile(ItemStack projectile, ItemStack weapon, LivingEntity living) {
        Item item;
        if (projectile.isEmpty() && (item = weapon.getItem()) instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item;
            if (living instanceof Player) {
                Player player = (Player)living;
                Predicate predicate = weaponItem.getSupportedHeldProjectiles(weapon);
                ExtraInventory extraInventory = ExtraInventory.of((LivingEntity)player);
                for (int i = 0; i < 4; ++i) {
                    ItemStack ammo = extraInventory.getAmmo(i);
                    if (!predicate.test(ammo)) continue;
                    extraInventory.setChanged();
                    return ammo;
                }
            }
        }
        return projectile;
    }

    public static ExtraInventory of(LivingEntity living) {
        ExtraInventory extraInventory = (ExtraInventory)living.getData(ModAttachmentTypes.EXTRA_INVENTORY);
        extraInventory.living = living;
        return extraInventory;
    }

    public record StackWithDye(ItemStack stack, ItemStack dye) implements IStackWithDye
    {
        public static final StackWithDye DEFAULT = new StackWithDye(ItemStack.EMPTY, ItemStack.EMPTY);

        @Override
        public IStackWithDye setStack(ItemStack stack) {
            return new StackWithDye(stack, this.dye);
        }

        @Override
        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public IStackWithDye setDye(ItemStack dye) {
            return new StackWithDye(this.stack, dye);
        }

        @Override
        public ItemStack getDye() {
            return this.dye;
        }
    }

    public static interface IStackWithDye {
        public IStackWithDye setStack(ItemStack var1);

        public ItemStack getStack();

        public IStackWithDye setDye(ItemStack var1);

        public ItemStack getDye();

        default public boolean isStackEmpty() {
            return this.getStack().isEmpty();
        }

        default public boolean isDyeEmpty() {
            return this.getDye().isEmpty();
        }

        default public boolean isEmpty() {
            return this.isStackEmpty() && this.isDyeEmpty();
        }

        default public Tag encode(DynamicOps<Tag> ops) {
            CompoundTag tag = new CompoundTag();
            tag.put("Stack", ExtraInventory.encode(this.getStack(), ops));
            tag.put("Dye", ExtraInventory.encode(this.getDye(), ops));
            return tag;
        }

        default public IStackWithDye decode(CompoundTag tag, DynamicOps<Tag> ops) {
            return this.setStack(ExtraInventory.decode(tag.getCompound("Stack"), ops)).setDye(ExtraInventory.decode(tag.getCompound("Dye"), ops));
        }
    }

    public class CurioStackWithDye
    implements IStackWithDye {
        private final int slot;
        private final ICurioStacksHandler handler;
        private ItemStack dye;

        public CurioStackWithDye(int slot, ICurioStacksHandler handler, IStackWithDye original) {
            this.slot = slot;
            this.handler = handler;
            this.setStack(original.getStack());
            this.setDye(original.getDye());
        }

        @Override
        public IStackWithDye setStack(ItemStack stack) {
            ItemStack from = this.getStack();
            this.handler.getStacks().setStackInSlot(this.slot, stack);
            if (ExtraInventory.this.living != null) {
                NeoForge.EVENT_BUS.post((Event)new CurioChangeEvent(ExtraInventory.this.living, this.handler.getIdentifier(), this.slot, from, stack));
            }
            return this;
        }

        @Override
        public ItemStack getStack() {
            return this.handler.getStacks().getStackInSlot(this.slot);
        }

        @Override
        public IStackWithDye setDye(ItemStack dye) {
            this.dye = dye;
            return this;
        }

        @Override
        public ItemStack getDye() {
            return this.dye;
        }
    }
}

